/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.DivideLinearLayout;
import xyqb.library.AnimatorCompat;
import xyqb.library.AnimatorListenerAdapter;
import xyqb.library.AnimatorUpdateListener;

public class TabLinearLayout
extends DivideLinearLayout {
    private static final int STRIP = 0;
    private static final int CLIP = 1;
    private static final int FULL = 2;
    private static final String TAG = "TabLinearLayout";
    private Drawable tabDrawable;
    private int tabWidth;
    private int tabHeight;
    private int horizontalPadding;
    private int verticalPadding;
    private float fraction;
    private int tabMode;
    private AnimatorCompat.Animator animator;
    private OnSelectListener listener;
    private int selectPosition;
    private int lastPosition;

    public TabLinearLayout(Context context) {
        this(context, null);
    }

    public TabLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.setClipChildren(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabLinearLayout);
        this.setTabImage(a.getDrawable(R.styleable.TabLinearLayout_tll_tabImage));
        this.setTabWidth((int)a.getDimension(R.styleable.TabLinearLayout_tll_tabWidth, 0.0f));
        this.setTabHeight((int)a.getDimension(R.styleable.TabLinearLayout_tll_tabHeight, (float)Utils.dip2px(2.0f)));
        this.setTabMode(a.getInt(R.styleable.TabLinearLayout_tll_tabMode, 0));
        this.setHorizontalPadding((int)a.getDimension(R.styleable.TabLinearLayout_tll_horizontalPadding, 0.0f));
        this.setVerticalPadding((int)a.getDimension(R.styleable.TabLinearLayout_tll_verticalPadding, 0.0f));
        a.recycle();
    }

    public void setHorizontalPadding(int padding) {
        this.horizontalPadding = padding;
        this.invalidate();
    }

    public void setVerticalPadding(int padding) {
        this.verticalPadding = padding;
        this.invalidate();
    }

    public void setTabWidth(int width) {
        this.tabWidth = width;
        this.invalidate();
    }

    public void setTabHeight(int height) {
        this.tabHeight = height;
        this.invalidate();
    }

    public void setTabImage(Drawable drawable) {
        this.tabDrawable = drawable;
        this.invalidate();
    }

    public void setTabMode(int mode) {
        this.tabMode = mode;
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup viewParent = (ViewGroup)parent;
            viewParent.setClipChildren(1 != mode);
        }
        this.invalidate();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup viewParent = (ViewGroup)parent;
            viewParent.setClipChildren(1 != this.tabMode);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            final int index = i;
            View childView = this.getChildAt(i);
            childView.setSelected(i == this.selectPosition);
            childView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TabLinearLayout.this.setSelectPosition(index);
                }
            });
        }
    }

    public void setSelectPosition(int index) {
        if (index != this.selectPosition) {
            if (null != this.animator) {
                this.animator.cancel();
            }
            this.selectPosition = index;
            this.animator = AnimatorCompat.ofFloat((float)1.0f);
            this.animator.addUpdateListener(new AnimatorUpdateListener(){

                public void onAnimationUpdate(AnimatorCompat.Animator animation, float fraction) {
                    TabLinearLayout.this.fraction = animation.getAnimatedFraction();
                    TabLinearLayout.this.invalidate();
                }
            });
            this.animator.addListener(new AnimatorListenerAdapter(){

                public void onAnimationEnd(AnimatorCompat.Animator animation) {
                    TabLinearLayout.this.lastPosition = TabLinearLayout.this.selectPosition;
                }
            });
            this.animator.start();
            View selectView = this.getChildAt(this.selectPosition);
            View lastView = this.getChildAt(this.lastPosition);
            if (null != selectView) {
                selectView.setSelected(true);
            }
            if (null != lastView) {
                lastView.setSelected(false);
            }
            if (null != this.listener) {
                this.listener.onSelectTab(selectView, this.selectPosition, this.lastPosition);
            }
        }
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        int childCount = this.getChildCount();
        if (0 >= childCount || null == this.tabDrawable) {
            return;
        }
        View lastView = this.getChildAt(this.lastPosition);
        View selectView = this.getChildAt(this.selectPosition);
        Rect outRect1 = new Rect();
        Rect outRect2 = new Rect();
        lastView.getHitRect(outRect1);
        selectView.getHitRect(outRect2);
        this.tabDrawable.setBounds(this.getBoundLeft(outRect1, outRect2), this.getBoundTop(outRect1, outRect2), this.getBoundRight(outRect1, outRect2), this.getBoundBottom(outRect1, outRect2));
        this.tabDrawable.draw(canvas);
    }

    private int getBoundLeft(Rect rect1, Rect rect2) {
        int orientation = this.getOrientation();
        int start = 0;
        int end = 0;
        if (0 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerX() - this.tabWidth / 2;
                end = rect2.centerX() - this.tabWidth / 2;
            } else {
                start = rect1.left + this.horizontalPadding;
                end = rect2.left + this.horizontalPadding;
            }
        } else if (1 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.right - this.verticalPadding - this.tabHeight;
                    end = rect2.right - this.verticalPadding - this.tabHeight;
                    break;
                }
                case 1: {
                    start = rect1.right + this.verticalPadding;
                    end = rect2.right + this.verticalPadding;
                    break;
                }
                case 2: {
                    start = rect1.left + this.verticalPadding;
                    end = rect2.left + this.verticalPadding;
                }
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    private int getBoundTop(Rect rect1, Rect rect2) {
        int start = 0;
        int end = 0;
        int orientation = this.getOrientation();
        if (0 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.bottom - this.verticalPadding - this.tabHeight;
                    end = rect2.bottom - this.verticalPadding - this.tabHeight;
                    break;
                }
                case 1: {
                    start = rect1.bottom + this.verticalPadding;
                    end = rect2.bottom + this.verticalPadding;
                    break;
                }
                case 2: {
                    start = rect1.top + this.verticalPadding;
                    end = rect2.top + this.verticalPadding;
                }
            }
        } else if (1 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerY() - this.tabWidth / 2;
                end = rect2.centerY() - this.tabWidth / 2;
            } else {
                start = rect1.top + this.horizontalPadding;
                end = rect2.top + this.horizontalPadding;
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    private int getBoundRight(Rect rect1, Rect rect2) {
        int orientation = this.getOrientation();
        int start = 0;
        int end = 0;
        if (0 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerX() + this.tabWidth / 2;
                end = rect2.centerX() + this.tabWidth / 2;
            } else {
                start = rect1.right - this.horizontalPadding;
                end = rect2.right - this.horizontalPadding;
            }
        } else if (1 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.right - this.verticalPadding;
                    end = rect2.right - this.verticalPadding;
                    break;
                }
                case 1: {
                    start = rect1.right + this.verticalPadding + this.tabHeight;
                    end = rect2.right + this.verticalPadding + this.tabHeight;
                    break;
                }
                case 2: {
                    start = rect1.right - this.verticalPadding;
                    end = rect2.right - this.verticalPadding;
                }
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    private int getBoundBottom(Rect rect1, Rect rect2) {
        int start = 0;
        int end = 0;
        int orientation = this.getOrientation();
        if (0 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.bottom - this.verticalPadding;
                    end = rect2.bottom - this.verticalPadding;
                    break;
                }
                case 1: {
                    start = rect1.bottom + this.verticalPadding + this.tabHeight;
                    end = rect2.bottom + this.verticalPadding + this.tabHeight;
                    break;
                }
                case 2: {
                    start = rect1.bottom - this.verticalPadding;
                    end = rect2.bottom - this.verticalPadding;
                }
            }
        } else if (1 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerY() + this.tabWidth / 2;
                end = rect2.centerY() + this.tabWidth / 2;
            } else {
                start = rect1.bottom - this.horizontalPadding;
                end = rect2.bottom - this.horizontalPadding;
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    public void setOnSelectListener(OnSelectListener listener) {
        this.listener = listener;
    }

    public static interface OnSelectListener {
        public void onSelectTab(View var1, int var2, int var3);
    }
}

