/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.cz.library.R;
import com.cz.library.widget.CenterGridLayout;
import java.util.ArrayList;
import java.util.List;

public class RadioGridLayout
extends CenterGridLayout {
    public static final int SINGLE_CHOOSE = 0;
    public static final int MORE_CHOOSE = 1;
    public static final int RECTANGLE_CHOOSE = 2;
    private static final String TAG = "RadioGridLayout";
    public static final int LEFT = 3;
    public static final int TOP = 48;
    public static final int RIGHT = 5;
    public static final int BOTTOM = 80;
    private Drawable buttonDrawable;
    private int imageWidth;
    private int imageHeight;
    private int horizontalPadding;
    private int verticalPadding;
    private int imageGravity;
    private int choiceMode;
    private OnCheckListener choiceListener;
    private int singleChoiceIndex;
    private ArrayList<Integer> multChoiceItems;
    private int start;
    private int end;

    public RadioGridLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RadioGridLayout(Context context) {
        this(context, null, 0);
    }

    public RadioGridLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.multChoiceItems = new ArrayList();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RadioGridLayout);
        this.setButtonImage(a.getDrawable(R.styleable.RadioGridLayout_rl_buttonImage));
        this.setButtonWidth((int)a.getDimension(R.styleable.RadioGridLayout_rl_imageWidth, 0.0f));
        this.setButtonHeight((int)a.getDimension(R.styleable.RadioGridLayout_rl_imageHeight, 0.0f));
        this.setButtonHorizontalPadding((int)a.getDimension(R.styleable.RadioGridLayout_rl_buttonHorizontalPadding, 0.0f));
        this.setButtonVerticalPadding((int)a.getDimension(R.styleable.RadioGridLayout_rl_buttonVerticalPadding, 0.0f));
        this.setImageGravity(a.getInt(R.styleable.RadioGridLayout_rl_imageGravity, 85));
        this.choiceMode = a.getInt(R.styleable.RadioGridLayout_rl_choiceMode, 0);
        a.recycle();
    }

    public void setButtonImage(@DrawableRes int res) {
        this.buttonDrawable = this.getResources().getDrawable(res);
        this.invalidate();
    }

    public void setButtonImage(Drawable drawable) {
        this.buttonDrawable = drawable;
        this.invalidate();
    }

    public void setButtonWidth(int width) {
        this.imageWidth = width;
        this.invalidate();
    }

    public void setButtonHeight(int height) {
        this.imageHeight = height;
        this.invalidate();
    }

    public void setButtonHorizontalPadding(int padding) {
        this.horizontalPadding = padding;
        this.invalidate();
    }

    public void setButtonVerticalPadding(int padding) {
        this.verticalPadding = padding;
        this.invalidate();
    }

    public void setImageGravity(int gravity) {
        this.imageGravity = gravity;
        this.invalidate();
    }

    public void setChoiceMode(@ChoiceMode int mode) {
        this.choiceMode = mode;
        this.invalidate();
    }

    @Override
    public void addView(View child, int i) {
        super.addView(child, i);
        this.setViewListener(child);
    }

    private void setViewListener(View view) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int index = RadioGridLayout.this.indexOfChild(v);
                switch (RadioGridLayout.this.choiceMode) {
                    case 1: {
                        RadioGridLayout.this.singleChoiceIndex = (RadioGridLayout.this.start = (RadioGridLayout.this.end = -1));
                        if (RadioGridLayout.this.multChoiceItems.contains(index)) {
                            RadioGridLayout.this.multChoiceItems.remove((Object)index);
                        } else {
                            RadioGridLayout.this.multChoiceItems.add(index);
                        }
                        if (null == RadioGridLayout.this.choiceListener) break;
                        RadioGridLayout.this.choiceListener.onMultiChoice(v, RadioGridLayout.this.multChoiceItems);
                        break;
                    }
                    case 2: {
                        if (-1 != RadioGridLayout.this.start && -1 != RadioGridLayout.this.end) {
                            RadioGridLayout.this.start = (RadioGridLayout.this.end = -1);
                            break;
                        }
                        if (-1 == RadioGridLayout.this.start) {
                            RadioGridLayout.this.start = index;
                            break;
                        }
                        if (-1 != RadioGridLayout.this.end) break;
                        RadioGridLayout.this.end = index;
                        if (null == RadioGridLayout.this.choiceListener) break;
                        RadioGridLayout.this.choiceListener.onRectangleChoice(RadioGridLayout.this.start, RadioGridLayout.this.end);
                        break;
                    }
                    default: {
                        RadioGridLayout.this.start = (RadioGridLayout.this.end = -1);
                        RadioGridLayout.this.multChoiceItems.clear();
                        if (null != RadioGridLayout.this.choiceListener) {
                            RadioGridLayout.this.choiceListener.onSingleChoice(v, index, RadioGridLayout.this.singleChoiceIndex);
                        }
                        RadioGridLayout.this.singleChoiceIndex = index;
                    }
                }
                RadioGridLayout.this.invalidate();
            }
        });
    }

    public int getSingleChoiceIndex() {
        return this.singleChoiceIndex;
    }

    public List<Integer> getMultiChoiceIndexs() {
        return this.multChoiceItems;
    }

    public int getRactangleStartIndex() {
        return this.start;
    }

    public int getRactangleEndIndex() {
        return this.end;
    }

    public void setOnCheckedListener(OnCheckListener listener) {
        this.choiceListener = listener;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (0 >= this.getChildCount() || null == this.buttonDrawable) {
            return;
        }
        switch (this.choiceMode) {
            case 1: {
                for (Integer index : this.multChoiceItems) {
                    this.drawChoiceView(canvas, this.getChildAt(index));
                }
                break;
            }
            case 2: {
                if (-1 != this.start && -1 != this.end) {
                    for (int i = Math.min(this.start, this.end); i <= Math.max(this.start, this.end); ++i) {
                        this.drawChoiceView(canvas, this.getChildAt(i));
                    }
                    break;
                }
                if (-1 == this.start) break;
                this.drawChoiceView(canvas, this.getChildAt(this.start));
                break;
            }
            default: {
                if (0 > this.singleChoiceIndex) break;
                this.drawChoiceView(canvas, this.getChildAt(this.singleChoiceIndex));
            }
        }
    }

    private void drawChoiceView(Canvas canvas, View childView) {
        Rect outRect = new Rect();
        childView.getHitRect(outRect);
        this.imageWidth = 0 == this.imageWidth ? this.buttonDrawable.getIntrinsicWidth() : this.imageWidth;
        this.imageHeight = 0 == this.imageHeight ? this.buttonDrawable.getIntrinsicHeight() : this.imageHeight;
        Log.e((String)TAG, (String)("gravity:" + this.imageGravity + " left|right:" + 3 + " right:" + 5 + " " + 7));
        switch (this.imageGravity) {
            case 3: 
            case 48: 
            case 51: {
                this.drawDrawable(canvas, outRect.left + this.horizontalPadding, outRect.top + this.verticalPadding, outRect.left + this.imageWidth + this.horizontalPadding, outRect.top + this.imageHeight + this.verticalPadding);
                break;
            }
            case 5: 
            case 53: {
                this.drawDrawable(canvas, outRect.right - this.horizontalPadding - this.imageWidth, outRect.top + this.verticalPadding, outRect.right - this.horizontalPadding, outRect.top + this.imageHeight + this.verticalPadding);
                break;
            }
            case 7: 
            case 55: {
                this.drawDrawable(canvas, outRect.centerX() - this.imageWidth / 2, outRect.top + this.verticalPadding, outRect.centerX() + this.imageWidth / 2, outRect.top + this.imageHeight + this.verticalPadding);
                break;
            }
            case 87: {
                this.drawDrawable(canvas, outRect.centerX() - this.imageWidth / 2, outRect.bottom - this.verticalPadding - this.imageHeight, outRect.centerX() + this.imageWidth / 2, outRect.bottom - this.verticalPadding);
                break;
            }
            case 112: 
            case 115: {
                this.drawDrawable(canvas, outRect.left + this.horizontalPadding, outRect.centerY() - this.imageHeight / 2, outRect.left + this.horizontalPadding + this.imageWidth, outRect.centerY() + this.imageHeight / 2);
                break;
            }
            case 117: {
                this.drawDrawable(canvas, outRect.right - this.horizontalPadding - this.imageWidth, outRect.centerY() - this.imageHeight / 2, outRect.right - this.horizontalPadding, outRect.centerY() + this.imageHeight / 2);
                break;
            }
            case 80: 
            case 83: {
                this.drawDrawable(canvas, outRect.left + this.horizontalPadding, outRect.bottom - this.verticalPadding - this.imageHeight, outRect.left + this.horizontalPadding + this.imageWidth, outRect.bottom - this.verticalPadding);
                break;
            }
            case 85: {
                this.drawDrawable(canvas, outRect.right - this.horizontalPadding - this.imageWidth, outRect.bottom - this.verticalPadding - this.imageHeight, outRect.right - this.horizontalPadding, outRect.bottom - this.verticalPadding);
                break;
            }
            case 119: {
                this.drawDrawable(canvas, outRect.centerX() - this.imageWidth / 2, outRect.centerY() - this.imageHeight / 2, outRect.centerX() + this.imageWidth / 2, outRect.centerY() + this.imageHeight / 2);
            }
        }
    }

    private void drawDrawable(Canvas canvas, int left, int top, int right, int bottom) {
        this.buttonDrawable.setBounds(left, top, right, bottom);
        this.buttonDrawable.draw(canvas);
    }

    public static interface OnCheckListener {
        public void onSingleChoice(View var1, int var2, int var3);

        public void onMultiChoice(View var1, ArrayList<Integer> var2);

        public void onRectangleChoice(int var1, int var2);
    }

    public static @interface ChoiceMode {
    }
}

