/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.DivideLinearLayout;

public class PagerSlidingTabStrip
extends HorizontalScrollView
implements ViewPager.OnPageChangeListener {
    private static final int DEFAULT_ITEM_PADDING = 15;
    private static final int TAB_VIEW_TEXT_SIZE_SP = 14;
    private static final int INDICATOR_HEIGHT = Utils.dip2px(2.0f);
    private Drawable indicatorDrawable;
    private int textColor;
    private int textSelectColor;
    private int dividerColor;
    private int underlineColor;
    private int itemHorizontalPadding;
    private int itemVerticalPadding;
    private DivideLinearLayout tabsContainer;
    private int tabCount;
    private int position;
    private int selectPosition;
    private float scale;
    private float positionOffset;
    private float indicatorPadding;
    private ViewPager viewPager;
    private int mScrollOffset;
    private int lastScrollX;
    private ViewPager.OnPageChangeListener pageChangeListener;
    private boolean isExpand;
    private float textSize;
    private Paint paint;

    public PagerSlidingTabStrip(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.paint = new Paint();
        this.tabsContainer = new DivideLinearLayout(context);
        this.tabsContainer.setOrientation(0);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.tabsContainer);
        this.initAttrs(context, attrs);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PagerSlidingTabStrip(Context context) {
        this(context, null, 0);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PagerSlidingTabStrip);
        this.setIndicatorColor(a.getColor(R.styleable.PagerSlidingTabStrip_ps_indicatorImage, -7829368));
        this.setIndicatorImage(a.getDrawable(R.styleable.PagerSlidingTabStrip_ps_indicatorImage));
        this.setTextColor(a.getColor(R.styleable.PagerSlidingTabStrip_ps_textColor, -12303292));
        this.setTextSelectColor(a.getColor(R.styleable.PagerSlidingTabStrip_ps_textSelectColor, -7829368));
        this.setItemHorizontalPadding(a.getDimension(R.styleable.PagerSlidingTabStrip_ps_itemHorizontalPadding, (float)Utils.dip2px(15.0f)));
        this.setItemVerticalPadding(a.getDimension(R.styleable.PagerSlidingTabStrip_ps_itemVerticalPadding, (float)Utils.dip2px(15.0f)));
        this.setIndicatorPadding(a.getDimension(R.styleable.PagerSlidingTabStrip_ps_indicatorPadding, 0.0f));
        this.setItemDivideColor(a.getColor(R.styleable.PagerSlidingTabStrip_ps_itemDivideColor, 0));
        this.setUnderlineColor(a.getColor(R.styleable.PagerSlidingTabStrip_ps_underlineColor, 0));
        this.setTabScale(a.getFloat(R.styleable.PagerSlidingTabStrip_ps_tabScale, 0.0f));
        this.setExpand(a.getBoolean(R.styleable.PagerSlidingTabStrip_ps_expand, false));
        this.setTextSize((int)a.getDimension(R.styleable.PagerSlidingTabStrip_ps_textSize, (float)Utils.sp2px(14.0f)));
        a.recycle();
    }

    private void setIndicatorPadding(float padding) {
        this.indicatorPadding = padding;
        this.invalidate();
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.updateTabs();
    }

    private void updateTabs() {
        DivideLinearLayout tabsContainer = this.tabsContainer;
        int childCount = tabsContainer.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = tabsContainer.getChildAt(i);
            if (!(childView instanceof TextView)) continue;
            ((TextView)childView).setTextSize(0, this.textSize);
        }
    }

    public void setTextColor(int color2) {
        this.textColor = color2;
    }

    public void setTextSelectColor(int color2) {
        this.textSelectColor = color2;
    }

    public void setItemDivideColor(int color2) {
        this.dividerColor = color2;
        this.invalidate();
    }

    public void setUnderlineColor(int color2) {
        this.underlineColor = color2;
        this.invalidate();
    }

    public void setItemHorizontalPadding(float padding) {
        this.itemHorizontalPadding = (int)padding;
    }

    public void setItemVerticalPadding(float padding) {
        this.itemVerticalPadding = (int)padding;
    }

    public void setIndicatorColor(int color2) {
        this.setIndicatorImage((Drawable)new ColorDrawable(color2));
    }

    public void setIndicatorImage(Drawable drawable) {
        this.indicatorDrawable = drawable;
        this.invalidate();
    }

    public void setTabScale(float scale) {
        this.scale = scale;
    }

    public void setExpand(boolean isExpand) {
        this.isExpand = isExpand;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        PagerAdapter adapter;
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && null != this.viewPager && null != (adapter = this.viewPager.getAdapter())) {
            this.tabsContainer.removeAllViews();
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.addPagerTabs(this.viewPager);
        }
    }

    private void addPagerTabs(final ViewPager viewPager) {
        PagerAdapter adapter = viewPager.getAdapter();
        this.tabCount = adapter.getCount();
        int width = this.getWidth() / this.tabCount;
        for (int i = 0; i < this.tabCount; ++i) {
            TextView tab = new TextView(this.getContext());
            tab.setGravity(17);
            tab.setText(adapter.getPageTitle(i));
            tab.setSingleLine();
            tab.setTextSize(0, this.textSize);
            tab.setTextColor(0 != i ? this.textColor : this.textSelectColor);
            tab.setPadding(this.itemHorizontalPadding, this.itemVerticalPadding, this.itemHorizontalPadding, this.itemVerticalPadding);
            final int position = i;
            tab.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    viewPager.setCurrentItem(position);
                }
            });
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.isExpand ? width : -2, -1);
            params.gravity = 17;
            if (0 == i) {
                ViewCompat.setScaleX((View)tab, (float)(1.0f + this.scale));
                ViewCompat.setScaleY((View)tab, (float)(1.0f + this.scale));
            }
            this.tabsContainer.addView((View)tab, (ViewGroup.LayoutParams)params);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pageChangeListener = listener;
    }

    public void setTabTextColor(int position, boolean selected) {
        TextView textView = (TextView)this.tabsContainer.getChildAt(position);
        if (null != textView) {
            textView.setTextColor(selected ? this.textSelectColor : this.textColor);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = this.getHeight();
        View view = this.tabsContainer.getChildAt(this.position);
        View nextView = this.tabsContainer.getChildAt(this.position + 1);
        float divideHeight = this.getResources().getDimension(R.dimen.divideSize);
        if (null != view) {
            int left = view.getLeft();
            int right = view.getRight();
            if (null != nextView) {
                left = (int)(this.positionOffset * (float)nextView.getLeft() + (1.0f - this.positionOffset) * (float)left);
                right = (int)(this.positionOffset * (float)nextView.getRight() + (1.0f - this.positionOffset) * (float)right);
            }
            this.paint.setColor(this.underlineColor);
            this.paint.setStrokeWidth(divideHeight);
            canvas.drawLine(0.0f, (float)height, (float)this.getWidth(), (float)height, this.paint);
            this.indicatorDrawable.setBounds(left + (int)this.indicatorPadding, height - INDICATOR_HEIGHT, right - (int)this.indicatorPadding, height);
            this.indicatorDrawable.draw(canvas);
        }
        this.paint.setColor(this.dividerColor);
        this.paint.setStrokeWidth(divideHeight);
        int childCount = this.tabsContainer.getChildCount();
        for (int i = 0; i < childCount - 1; ++i) {
            View childView = this.tabsContainer.getChildAt(i);
            int right = childView.getRight();
            canvas.drawLine((float)right, 10.0f, (float)right, (float)(height - 10), this.paint);
        }
    }

    private void scrollToChild(int position, int offset) {
        if (this.tabCount == 0) {
            return;
        }
        int newScrollX = this.tabsContainer.getChildAt(position).getLeft() + offset;
        if (position > 0 || offset > 0) {
            newScrollX -= this.mScrollOffset;
        }
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (null != this.pageChangeListener) {
            this.pageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
        this.scrollToChild(position, (int)(positionOffset * (float)this.tabsContainer.getChildAt(position).getWidth()));
        this.position = position;
        this.positionOffset = positionOffset;
        if (position < this.tabCount) {
            TextView lastView = null;
            TextView textView = null;
            if (position + 1 < this.tabCount) {
                lastView = (TextView)this.tabsContainer.getChildAt(position + 1);
            }
            textView = (TextView)this.tabsContainer.getChildAt(position);
            if (null != lastView) {
                ViewCompat.setScaleX((View)lastView, (float)(1.0f + positionOffset * this.scale));
                ViewCompat.setScaleY((View)lastView, (float)(1.0f + positionOffset * this.scale));
                lastView.setTextColor(this.evaluate(1.0f - positionOffset, this.textSelectColor, this.textColor));
            }
            ViewCompat.setScaleX((View)textView, (float)(1.0f + (1.0f - positionOffset) * this.scale));
            ViewCompat.setScaleY((View)textView, (float)(1.0f + (1.0f - positionOffset) * this.scale));
            textView.setTextColor(this.evaluate(1.0f - positionOffset, this.textColor, this.textSelectColor));
        }
        if (this.selectPosition == position && 0.0f == this.positionOffset) {
            for (int i = 0; i < this.tabCount; ++i) {
                this.setTabTextColor(i, i == position);
            }
        }
        this.invalidate();
    }

    public void onPageSelected(int position) {
        if (null != this.pageChangeListener) {
            this.pageChangeListener.onPageSelected(position);
        }
        this.selectPosition = position;
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.scrollToChild(this.position, 0);
        }
        if (null != this.pageChangeListener) {
            this.pageChangeListener.onPageScrollStateChanged(state);
        }
    }

    private int evaluate(float fraction, int startValue, int endValue) {
        int startInt = startValue;
        int startA = startInt >> 24;
        int startR = startInt >> 16 & 0xFF;
        int startG = startInt >> 8 & 0xFF;
        int startB = startInt & 0xFF;
        int endInt = endValue;
        int endA = endInt >> 24;
        int endR = endInt >> 16 & 0xFF;
        int endG = endInt >> 8 & 0xFF;
        int endB = endInt & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }
}

