/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.DivideLinearLayout;
import com.cz.library.widget.IndicateView;

public class IndicateView
extends DivideLinearLayout {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    private Paint paint;
    private float textSize;
    private int textColor;
    private float indicatePadding;
    private float dividerSize;
    private int dividerColor;
    private float indicateSize;
    private int indicateBackground;
    private Drawable indicateDrawable;
    private int gravity;

    public IndicateView(Context context) {
        this(context, null);
    }

    public IndicateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.paint = new Paint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IndicateView);
        this.setTextColor(a.getColor(R.styleable.IndicateView_iv_textColor, -1));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.IndicateView_iv_textSize, Utils.sp2px(12.0f)));
        this.setIndicatePadding(a.getDimension(R.styleable.IndicateView_iv_indicatePadding, 0.0f));
        this.setDividerColor(a.getColor(R.styleable.IndicateView_iv_dividerColor, -12303292));
        this.setDividerSize(a.getDimension(R.styleable.IndicateView_iv_dividerSize, (float)Utils.dip2px(1.0f)));
        this.setIndicateImage(a.getDrawable(R.styleable.IndicateView_iv_indicateImage));
        this.setIndicateSize(a.getDimension(R.styleable.IndicateView_iv_indicateSize, (float)Utils.dip2px(40.0f)));
        this.setIndicateBackground(a.getColor(R.styleable.IndicateView_iv_indicateBackground, 0));
        this.gravity = a.getInt(R.styleable.IndicateView_iv_indicateGravity, 0);
        a.recycle();
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public void setTextColor(int color2) {
        this.textColor = color2;
        this.invalidate();
    }

    public void setIndicatePadding(float padding) {
        this.indicatePadding = padding;
        this.invalidate();
    }

    public void setDividerSize(float size) {
        this.dividerSize = size;
        this.invalidate();
    }

    public void setDividerColor(int color2) {
        this.dividerColor = color2;
        this.invalidate();
    }

    public void setIndicateColor(int color2) {
        this.setIndicateImage((Drawable)new ColorDrawable(color2));
    }

    public void setIndicateImage(Drawable drawable) {
        if (null == drawable) {
            return;
        }
        this.indicateDrawable = drawable;
        this.invalidate();
    }

    private void setIndicateSize(float size) {
        this.indicateSize = size;
        this.invalidate();
    }

    public void setIndicateBackground(int color2) {
        this.indicateBackground = color2;
        this.invalidate();
    }

    public void setIndicateGravity(@IndicateGravity int gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        int orientation = this.getOrientation();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)childView.getLayoutParams();
            if (1 == orientation) {
                layoutParams.leftMargin = (int)this.indicateSize;
                continue;
            }
            if (0 != orientation) continue;
            layoutParams.topMargin = (int)this.indicateSize;
        }
        this.requestLayout();
    }

    private float getStartX() {
        float startX = 0.0f;
        if (1 == this.getOrientation()) {
            startX = this.indicateSize / 2.0f;
        }
        return startX;
    }

    private float getStartY() {
        float startY = 0.0f;
        if (0 == this.getOrientation()) {
            startY = this.indicateSize / 2.0f;
        }
        return startY;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float x = this.getStartX();
        float y = this.getStartY();
        this.drawDivide(canvas, x, y);
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.drawText(canvas, x, y, i);
        }
    }

    private void drawDivide(Canvas canvas, float x, float y) {
        int width = this.getWidth();
        int height = this.getHeight();
        int orientation = this.getOrientation();
        this.paint.setColor(this.indicateBackground);
        this.paint.setStrokeWidth(this.dividerSize);
        if (1 == orientation) {
            canvas.drawRect(0.0f, 0.0f, this.indicateSize, (float)height, this.paint);
            this.paint.setColor(this.dividerColor);
            canvas.drawLine(x, y, x, (float)height, this.paint);
        } else if (0 == orientation) {
            canvas.drawRect(0.0f, 0.0f, (float)width, this.indicateSize, this.paint);
            this.paint.setColor(this.dividerColor);
            canvas.drawLine(x, y, (float)width, y, this.paint);
        }
    }

    private void drawText(Canvas canvas, float x, float y, int index) {
        Rect textRect = new Rect();
        Rect outRect = new Rect();
        View childView = this.getChildAt(index);
        childView.getHitRect(outRect);
        int orientation = this.getOrientation();
        String text = String.valueOf(index + 1);
        this.paint.setTextSize(this.textSize);
        this.paint.getTextBounds(text, 0, text.length(), textRect);
        float textWidth = this.paint.measureText(text);
        Paint.FontMetrics fm = this.paint.getFontMetrics();
        float centerBaselineY = (float)(textRect.height() / 2) - fm.descent + (fm.descent - fm.ascent) / 2.0f;
        float radius = (this.indicateSize - this.indicatePadding - this.paint.getStrokeWidth() / 2.0f) / 2.0f;
        float textLeft = 0.0f;
        float textTop = 0.0f;
        float circleX = 0.0f;
        float circleY = 0.0f;
        if (1 == orientation) {
            switch (this.gravity) {
                case 0: {
                    textTop = (float)outRect.top + radius + centerBaselineY / 2.0f;
                    circleY = (float)outRect.top + radius;
                    break;
                }
                case 1: {
                    textTop = (float)outRect.centerY() + centerBaselineY / 2.0f;
                    circleY = outRect.centerY();
                    break;
                }
                case 2: {
                    textTop = (float)outRect.bottom - radius + centerBaselineY / 2.0f;
                    circleY = (float)outRect.bottom - radius;
                }
            }
            textLeft = x - textWidth / 2.0f;
            circleX = x;
        } else if (0 == orientation) {
            switch (this.gravity) {
                case 0: {
                    textLeft = (float)outRect.left + radius - textWidth / 2.0f;
                    circleX = (float)outRect.left + radius;
                    break;
                }
                case 1: {
                    textLeft = (float)outRect.centerX() - textWidth / 2.0f;
                    circleX = outRect.centerX();
                    break;
                }
                case 2: {
                    textLeft = (float)outRect.right - radius - textWidth / 2.0f;
                    circleX = (float)outRect.right - radius;
                }
            }
            textTop = y + (float)(textRect.height() / 2);
            circleY = y;
        }
        if (null != this.indicateDrawable) {
            this.indicateDrawable.setBounds((int)(circleX - radius), (int)(circleY - radius), (int)(circleX + radius), (int)(circleY + radius));
            this.indicateDrawable.draw(canvas);
        }
        this.paint.setColor(this.textColor);
        this.paint.setTypeface(Typeface.DEFAULT_BOLD);
        canvas.drawText(text, textLeft, textTop, this.paint);
    }
}

