/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;
import com.cz.library.R;

public class DivideTextView
extends TextView {
    public static final int NONE = 1;
    public static final int LEFT = 2;
    public static final int TOP = 4;
    public static final int RIGHT = 8;
    public static final int BOTTOM = 16;
    private Drawable divideDrawable;
    private int strokeWidth;
    private int divideColor;
    private int dividePadding;
    private int leftPadding;
    private int gravity;

    public DivideTextView(Context context) {
        this(context, null, 0);
    }

    public DivideTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DivideTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.initAttribute(context, attrs);
    }

    private void initAttribute(Context context, AttributeSet attrs) {
        Resources resources = this.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DivideTextView);
        this.setDivideGravityInner(a.getInt(R.styleable.DivideTextView_dt_divideGravity, 1));
        this.setStrokeWidth(a.getDimension(R.styleable.DivideTextView_dt_divideSize, resources.getDimension(R.dimen.divideSize)));
        this.setDivideColor(a.getColor(R.styleable.DivideTextView_dt_divideDrawable, resources.getColor(R.color.divide)));
        this.setDividePadding(a.getDimension(R.styleable.DivideTextView_dt_dividePadding, 0.0f));
        this.setLeftPadding(a.getDimension(R.styleable.DivideTextView_dt_leftPadding, 0.0f));
        a.recycle();
    }

    public void setDivideGravity(@DivideGravity int gravity) {
        this.setDivideGravityInner(gravity);
    }

    public void setDivideGravityInner(int gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = Math.round(strokeWidth);
        this.invalidate();
    }

    public void setDivideColor(int color2) {
        this.divideColor = color2;
        this.invalidate();
    }

    public void setDividePadding(float padding) {
        this.dividePadding = Math.round(padding);
        this.invalidate();
    }

    private void setLeftPadding(float padding) {
        this.leftPadding = Math.round(padding);
        this.invalidate();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawDivide(canvas);
    }

    private void drawDivide(Canvas canvas) {
        this.drawDivide(canvas, this.gravity == (this.gravity | 2), this.gravity == (this.gravity | 4), this.gravity == (this.gravity | 8), this.gravity == (this.gravity | 0x10));
    }

    private void drawDivide(Canvas canvas, boolean drawLeft, boolean drawTop, boolean drawRight, boolean drawBottom) {
        if (null == this.divideDrawable) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (drawLeft) {
            this.divideDrawable.setBounds(0, this.dividePadding, this.strokeWidth, height - this.dividePadding);
            this.divideDrawable.draw(canvas);
        }
        if (drawTop) {
            this.divideDrawable.setBounds(this.dividePadding, 0, width - this.dividePadding, this.strokeWidth);
            this.divideDrawable.draw(canvas);
        }
        if (drawRight) {
            this.divideDrawable.setBounds(width - this.strokeWidth, this.dividePadding, width, height - this.dividePadding);
            this.divideDrawable.draw(canvas);
        }
        if (drawBottom) {
            this.divideDrawable.setBounds(this.dividePadding + this.leftPadding, height - this.strokeWidth, width - this.dividePadding, height);
            this.divideDrawable.draw(canvas);
        }
    }

    public static @interface DivideGravity {
    }
}

