/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.cz.library.R;

public class RecyclerTabLayout
extends RecyclerView {
    protected static final long DEFAULT_SCROLL_DURATION = 200L;
    protected static final float DEFAULT_POSITION_THRESHOLD = 1.0f;
    protected Paint mIndicatorPaint = new Paint();
    protected int mTabMinWidth;
    protected int mTabMaxWidth;
    protected int mIndicatorHeight;
    protected float mIndicatorPadding;
    protected float mTabScale;
    protected LinearLayoutManager mLinearLayoutManager = new LinearLayoutManager(this.getContext());
    protected RecyclerOnScrollListener mRecyclerOnScrollListener;
    private ViewPager.OnPageChangeListener mListener;
    protected ViewPager mViewPager;
    protected Adapter<?> mAdapter;
    protected int mIndicatorPositoin;
    protected int mIndicatorOffset;
    protected int mScrollOffset;
    protected float mOldPositionOffset;
    protected float mPositionThreshold;
    protected boolean mRequestScrollToTab;
    private int mTabSelectColor;
    private int mTabDefaultColor;

    public RecyclerTabLayout(Context context) {
        this(context, null);
    }

    public RecyclerTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerTabLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mLinearLayoutManager.setOrientation(0);
        this.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
        this.setItemAnimator(null);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerTabLayout);
        this.setTabIndicatorColor(a.getColor(R.styleable.RecyclerTabLayout_rtl_tabIndicatorColor, 0));
        this.setTabIndicatorHeight(a.getDimensionPixelSize(R.styleable.RecyclerTabLayout_rtl_tabIndicatorHeight, 0));
        this.setTabDefaultColor(a.getColor(R.styleable.RecyclerTabLayout_rtl_tabDefaultColor, -1));
        this.setTabSelectColor(a.getColor(R.styleable.RecyclerTabLayout_rtl_tabSelectColor, -16711936));
        this.setTabIndicatorPadding(a.getDimension(R.styleable.RecyclerTabLayout_rtl_tabIndicatorPadding, 0.0f));
        this.setTabScale(a.getFloat(R.styleable.RecyclerTabLayout_rtl_tabScale, 0.0f));
        a.recycle();
        this.mPositionThreshold = 1.0f;
    }

    public void setTabScale(float scale) {
        this.mTabScale = scale;
    }

    protected void onDetachedFromWindow() {
        if (this.mRecyclerOnScrollListener != null) {
            this.removeOnScrollListener(this.mRecyclerOnScrollListener);
            this.mRecyclerOnScrollListener = null;
        }
        super.onDetachedFromWindow();
    }

    public void setTabIndicatorColor(int color2) {
        this.mIndicatorPaint.setColor(color2);
        this.invalidate();
    }

    public void setTabIndicatorHeight(int indicatorHeight) {
        this.mIndicatorHeight = indicatorHeight;
    }

    public void setTabIndicatorPadding(float padding) {
        this.mIndicatorPadding = padding;
    }

    public void setAutoSelectionMode(boolean autoSelect) {
        if (this.mRecyclerOnScrollListener != null) {
            this.removeOnScrollListener(this.mRecyclerOnScrollListener);
            this.mRecyclerOnScrollListener = null;
        }
        if (autoSelect) {
            this.mRecyclerOnScrollListener = new RecyclerOnScrollListener(this, this.mLinearLayoutManager);
            this.addOnScrollListener(this.mRecyclerOnScrollListener);
        }
    }

    public void setPositionThreshold(float positionThreshold) {
        this.mPositionThreshold = positionThreshold;
    }

    public void setUpWithAdapter(Adapter<?> adapter) {
        this.mAdapter = adapter;
        ((Adapter)this.mAdapter).setTabScale(this.mTabScale);
        this.mAdapter.setSelectColor(this.mTabSelectColor);
        this.mAdapter.setDefaultColor(this.mTabDefaultColor);
        this.mViewPager = adapter.getViewPager();
        if (this.mViewPager.getAdapter() == null) {
            throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
        }
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPagerOnPageChangeListener(this));
        this.setAdapter(adapter);
        this.scrollToTab(this.mViewPager.getCurrentItem());
    }

    public void setCurrentItem(int position, boolean smoothScroll) {
        if (this.mViewPager != null) {
            this.mViewPager.setCurrentItem(position, smoothScroll);
            this.scrollToTab(this.mViewPager.getCurrentItem());
            return;
        }
        if (smoothScroll && position != this.mIndicatorPositoin) {
            if (Build.VERSION.SDK_INT > 11) {
                this.startAnimation(position);
            } else {
                this.scrollToTab(position);
            }
        } else {
            this.scrollToTab(position);
        }
    }

    @TargetApi(value=11)
    protected void startAnimation(final int position) {
        float distance = 1.0f;
        View view = this.mLinearLayoutManager.findViewByPosition(position);
        if (view != null) {
            float currentX = view.getX() + (float)view.getMeasuredWidth() / 2.0f;
            float centerX = (float)this.getMeasuredWidth() / 2.0f;
            distance = Math.abs(centerX - currentX) / (float)view.getMeasuredWidth();
        }
        ValueAnimator animator = position < this.mIndicatorPositoin ? ValueAnimator.ofFloat((float[])new float[]{distance, 0.0f}) : ValueAnimator.ofFloat((float[])new float[]{-distance, 0.0f});
        animator.setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                RecyclerTabLayout.this.scrollToTab(position, ((Float)animation.getAnimatedValue()).floatValue(), true);
            }
        });
        animator.start();
    }

    protected void scrollToTab(int position) {
        this.scrollToTab(position, 0.0f, false);
        this.mAdapter.setCurrentIndicatorPosition(position);
        this.mAdapter.notifyDataSetChanged();
    }

    protected void scrollToTab(int position, float positionOffset, boolean fitIndicator) {
        int width;
        int scrollOffset = 0;
        View selectedView = this.mLinearLayoutManager.findViewByPosition(position);
        View nextView = this.mLinearLayoutManager.findViewByPosition(position + 1);
        if (selectedView != null) {
            width = this.getMeasuredWidth();
            float scroll1 = (float)width / 2.0f - (float)selectedView.getMeasuredWidth() / 2.0f;
            if (nextView != null) {
                float scroll2 = (float)width / 2.0f - (float)nextView.getMeasuredWidth() / 2.0f;
                float scroll = scroll1 + ((float)selectedView.getMeasuredWidth() - scroll2);
                float dx = scroll * positionOffset;
                scrollOffset = (int)(scroll1 - dx);
                this.mScrollOffset = (int)dx;
                this.mIndicatorOffset = (int)((scroll1 - scroll2) * positionOffset);
            } else {
                scrollOffset = (int)scroll1;
                this.mScrollOffset = 0;
                this.mIndicatorOffset = 0;
            }
            if (fitIndicator) {
                this.mScrollOffset = 0;
                this.mIndicatorOffset = 0;
            }
            if (this.mAdapter != null && this.mIndicatorPositoin == position) {
                this.updateCurrentIndicatorPosition(position, positionOffset - this.mOldPositionOffset, positionOffset);
            }
            this.mIndicatorPositoin = position;
        } else {
            if (this.getMeasuredWidth() > 0 && this.mTabMinWidth == this.mTabMaxWidth) {
                width = this.mTabMinWidth;
                int offset = (int)(positionOffset * (float)(-width));
                int leftOffset = (int)((float)(this.getMeasuredWidth() - width) / 2.0f);
                scrollOffset = offset + leftOffset;
            }
            this.mRequestScrollToTab = true;
        }
        if (null != this.mAdapter) {
            this.mAdapter.onTabScroll(selectedView, nextView, positionOffset, this.mTabScale, this.mTabSelectColor, this.mTabDefaultColor);
        }
        this.mLinearLayoutManager.scrollToPositionWithOffset(position, scrollOffset);
        if (this.mIndicatorHeight > 0) {
            this.invalidate();
        }
        if (null != this.mAdapter) {
            this.mAdapter.setAdapterPosition(position);
            int adapterPosition = this.mAdapter.getAdapterPosition();
            if (position == adapterPosition && 0.0f == positionOffset) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
        this.mOldPositionOffset = positionOffset;
    }

    protected void updateCurrentIndicatorPosition(int position, float dx, float positionOffset) {
        int indicatorPosition = -1;
        if (dx > 0.0f && positionOffset >= this.mPositionThreshold) {
            indicatorPosition = position + 1;
        } else if (dx < 0.0f && positionOffset <= 1.0f - this.mPositionThreshold) {
            indicatorPosition = position;
        }
        if (indicatorPosition >= 0 && indicatorPosition != this.mAdapter.getCurrentIndicatorPosition()) {
            this.mAdapter.setCurrentIndicatorPosition(indicatorPosition);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onDraw(Canvas canvas) {
        View view = this.mLinearLayoutManager.findViewByPosition(this.mIndicatorPositoin);
        if (view == null) {
            if (this.mRequestScrollToTab) {
                this.mRequestScrollToTab = false;
                this.scrollToTab(this.mViewPager.getCurrentItem());
            }
            return;
        }
        this.mRequestScrollToTab = false;
        int left = view.getLeft() + this.mScrollOffset - this.mIndicatorOffset;
        int right = view.getRight() + this.mScrollOffset + this.mIndicatorOffset;
        int top = this.getHeight() - this.mIndicatorHeight;
        int bottom = this.getHeight();
        canvas.drawRect((float)left + this.mIndicatorPadding, (float)top, (float)right - this.mIndicatorPadding, (float)bottom, this.mIndicatorPaint);
    }

    public void setTabSelectColor(int color2) {
        this.mTabSelectColor = color2;
        if (null != this.mAdapter) {
            this.mAdapter.setSelectColor(color2);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void setTabDefaultColor(int color2) {
        this.mTabDefaultColor = color2;
        if (null != this.mAdapter) {
            this.mAdapter.setDefaultColor(color2);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public static abstract class Adapter<T extends RecyclerView.ViewHolder>
    extends RecyclerView.Adapter<T> {
        protected ViewPager mViewPager;
        protected int mIndicatorPosition;
        protected int mAdapterPosition;
        protected float mTabScale;
        protected int selectColor;
        protected int defaultColor;

        public Adapter(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        public ViewPager getViewPager() {
            return this.mViewPager;
        }

        public void setCurrentIndicatorPosition(int indicatorPosition) {
            this.mIndicatorPosition = indicatorPosition;
        }

        public int getCurrentIndicatorPosition() {
            return this.mIndicatorPosition;
        }

        public void setSelectColor(int color2) {
            this.selectColor = color2;
        }

        public void setDefaultColor(int color2) {
            this.defaultColor = color2;
        }

        private void setTabScale(float scale) {
            this.mTabScale = scale;
        }

        public float getTabScale() {
            return this.mTabScale;
        }

        public void setAdapterPosition(int position) {
            this.mAdapterPosition = position;
        }

        public int getAdapterPosition() {
            return this.mAdapterPosition;
        }

        public void onBindViewHolder(T holder, int position) {
            this.onBindViewHolder(holder, position, this.selectColor, this.defaultColor);
        }

        public abstract void onBindViewHolder(T var1, int var2, int var3, int var4);

        public abstract void onTabScroll(View var1, View var2, float var3, float var4, int var5, int var6);
    }

    protected class ViewPagerOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final RecyclerTabLayout mRecyclerTabLayout;
        private int mScrollState;

        public ViewPagerOnPageChangeListener(RecyclerTabLayout recyclerTabLayout) {
            this.mRecyclerTabLayout = recyclerTabLayout;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            this.mRecyclerTabLayout.scrollToTab(position, positionOffset, false);
            if (null != RecyclerTabLayout.this.mListener) {
                RecyclerTabLayout.this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            this.mScrollState = state;
            if (null != RecyclerTabLayout.this.mListener) {
                RecyclerTabLayout.this.mListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            if (this.mScrollState == 0 && this.mRecyclerTabLayout.mIndicatorPositoin != position) {
                this.mRecyclerTabLayout.scrollToTab(position);
            }
            if (null != RecyclerTabLayout.this.mListener) {
                RecyclerTabLayout.this.mListener.onPageSelected(position);
            }
        }
    }

    protected static class RecyclerOnScrollListener
    extends RecyclerView.OnScrollListener {
        protected RecyclerTabLayout mRecyclerTabLayout;
        protected LinearLayoutManager mLinearLayoutManager;
        public int mDx;

        public RecyclerOnScrollListener(RecyclerTabLayout recyclerTabLayout, LinearLayoutManager linearLayoutManager) {
            this.mRecyclerTabLayout = recyclerTabLayout;
            this.mLinearLayoutManager = linearLayoutManager;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            this.mDx += dx;
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            switch (newState) {
                case 0: {
                    if (this.mDx > 0) {
                        this.selectCenterTabForRightScroll();
                    } else {
                        this.selectCenterTabForLeftScroll();
                    }
                    this.mDx = 0;
                    break;
                }
            }
        }

        protected void selectCenterTabForRightScroll() {
            int first = this.mLinearLayoutManager.findFirstVisibleItemPosition();
            int last = this.mLinearLayoutManager.findLastVisibleItemPosition();
            int center = this.mRecyclerTabLayout.getWidth() / 2;
            for (int position = first; position <= last; ++position) {
                View view = this.mLinearLayoutManager.findViewByPosition(position);
                if (view.getLeft() + view.getWidth() < center) continue;
                this.mRecyclerTabLayout.setCurrentItem(position, false);
                break;
            }
        }

        protected void selectCenterTabForLeftScroll() {
            int first = this.mLinearLayoutManager.findFirstVisibleItemPosition();
            int last = this.mLinearLayoutManager.findLastVisibleItemPosition();
            int center = this.mRecyclerTabLayout.getWidth() / 2;
            for (int position = last; position >= first; --position) {
                View view = this.mLinearLayoutManager.findViewByPosition(position);
                if (view.getLeft() > center) continue;
                this.mRecyclerTabLayout.setCurrentItem(position, false);
                break;
            }
        }
    }
}

