/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.cz.library.R;

public class DivideRelativeLayout
extends RelativeLayout {
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    private float strokeWidth;
    private int divideColor;
    private int dividePadding;
    private int leftPadding;
    private int gravity;
    private Paint paint = new Paint();

    public DivideRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.initAttribute(context, attrs);
    }

    public DivideRelativeLayout(Context context) {
        this(context, null);
    }

    private void initAttribute(Context context, AttributeSet attrs) {
        Resources resources = this.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DivideLinearLayout);
        this.gravity = a.getInt(R.styleable.DivideLinearLayout_dl_divideGravity, 0);
        this.setStrokeWidth(a.getDimension(R.styleable.DivideLinearLayout_dl_divideSize, resources.getDimension(R.dimen.divideSize)));
        this.setDivideColor(a.getColor(R.styleable.DivideLinearLayout_dl_divideColor, resources.getColor(R.color.divide)));
        this.setDividePadding((int)a.getDimension(R.styleable.DivideLinearLayout_dl_dividePadding, 0.0f));
        this.setLeftPadding((int)a.getDimension(R.styleable.DivideLinearLayout_dl_leftPadding, 0.0f));
        a.recycle();
    }

    public void setDivideGravity(@DivideGravity int gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public void setDivideColor(int color2) {
        this.divideColor = color2;
        this.invalidate();
    }

    public void setDividePadding(int padding) {
        this.dividePadding = padding;
        this.invalidate();
    }

    private void setLeftPadding(int padding) {
        this.leftPadding = padding;
        this.invalidate();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawDivide(canvas);
    }

    private void drawDivide(Canvas canvas) {
        this.drawDivide(canvas, this.gravity == (this.gravity | 1), this.gravity == (this.gravity | 2), this.gravity == (this.gravity | 4), this.gravity == (this.gravity | 8));
    }

    private void drawDivide(Canvas canvas, boolean drawLeft, boolean drawTop, boolean drawRight, boolean drawBottom) {
        this.paint.reset();
        this.paint.setColor(this.divideColor);
        int width = this.getWidth();
        int height = this.getHeight();
        float interval = this.strokeWidth / 2.0f;
        this.paint.setStrokeWidth(this.strokeWidth);
        if (drawLeft) {
            canvas.drawLine(interval, (float)this.dividePadding, interval, (float)(height - this.dividePadding), this.paint);
        }
        if (drawTop) {
            canvas.drawLine((float)this.dividePadding, interval, (float)(width - this.dividePadding), interval, this.paint);
        }
        if (drawRight) {
            canvas.drawLine((float)width - interval, (float)this.dividePadding, (float)width - interval, (float)(height - this.dividePadding), this.paint);
        }
        if (drawBottom) {
            canvas.drawLine((float)(this.dividePadding + this.leftPadding), (float)height - interval, (float)(width - this.dividePadding), (float)height - interval, this.paint);
        }
    }

    public static @interface DivideGravity {
    }
}

