/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.cz.library.R;

public class DivideLinearLayout
extends LinearLayout {
    public static final String MATERIALDESIGNXML = "http://schemas.android.com/apk/res-auto";
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    private boolean isShowItemDivide;
    private float strokeSize;
    private float itemStrokeSize;
    private int divideColor;
    private int itemDivideColor;
    private int dividePadding;
    private int itemDividePadding;
    private int leftPadding;
    private int gravity;
    private Paint paint = new Paint();

    public DivideLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.initAttribute(context, attrs);
    }

    public DivideLinearLayout(Context context) {
        this(context, null);
    }

    private void initAttribute(Context context, AttributeSet attrs) {
        Resources resources = this.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DivideLinearLayout);
        this.setDivideGravity(a.getInt(R.styleable.DivideLinearLayout_dl_divideGravity, 0));
        this.setItemDivide(a.getBoolean(R.styleable.DivideLinearLayout_dl_itemDivide, false));
        this.setDivideSize(a.getDimension(R.styleable.DivideLinearLayout_dl_divideSize, this.getResources().getDimension(R.dimen.divideSize)));
        this.setItemDivideSize(a.getDimension(R.styleable.DivideLinearLayout_dl_itemDivideSize, this.getResources().getDimension(R.dimen.divideSize)));
        this.setDivideColor(a.getColor(R.styleable.DivideLinearLayout_dl_divideColor, resources.getColor(R.color.divide)));
        this.setItemDivideColor(a.getColor(R.styleable.DivideLinearLayout_dl_itemDivideColor, resources.getColor(R.color.divide)));
        this.setDividePadding((int)a.getDimension(R.styleable.DivideLinearLayout_dl_dividePadding, 0.0f));
        this.setLeftPadding((int)a.getDimension(R.styleable.DivideLinearLayout_dl_leftPadding, 0.0f));
        this.setItemDividePadding((int)a.getDimension(R.styleable.DivideLinearLayout_dl_itemDividePadding, 0.0f));
        a.recycle();
    }

    private void setLeftPadding(int padding) {
        this.leftPadding = padding;
        this.invalidate();
    }

    private int getResourceColor(AttributeSet attrs, String attrName, int defaultColor) {
        int color2 = attrs.getAttributeResourceValue(MATERIALDESIGNXML, attrName, defaultColor);
        color2 = defaultColor == color2 ? attrs.getAttributeIntValue(MATERIALDESIGNXML, attrName, defaultColor) : this.getResources().getColor(color2);
        return color2;
    }

    public void setItemDivide(boolean showItemDivide) {
        this.isShowItemDivide = showItemDivide;
        this.invalidate();
    }

    public void setDivideGravity(int gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    public void setDivideSize(float size) {
        this.strokeSize = size;
        this.invalidate();
    }

    public void setItemDivideSize(float size) {
        this.itemStrokeSize = size;
        this.invalidate();
    }

    public void setDivideColor(int color2) {
        this.divideColor = color2;
        this.invalidate();
    }

    public void setItemDivideColor(int color2) {
        this.itemDivideColor = color2;
        this.invalidate();
    }

    public void setDividePadding(int padding) {
        this.dividePadding = padding;
        this.invalidate();
    }

    public void setItemDividePadding(int padding) {
        this.itemDividePadding = padding;
        this.invalidate();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawDivide(canvas);
        this.drawItemDivide(canvas);
    }

    private void drawDivide(Canvas canvas) {
        this.drawDivide(canvas, this.gravity == (this.gravity | 1), this.gravity == (this.gravity | 2), this.gravity == (this.gravity | 4), this.gravity == (this.gravity | 8));
    }

    private void drawDivide(Canvas canvas, boolean drawLeft, boolean drawTop, boolean drawRight, boolean drawBottom) {
        this.paint.reset();
        this.paint.setColor(this.divideColor);
        int width = this.getWidth();
        int height = this.getHeight();
        float interval = this.strokeSize / 2.0f;
        this.paint.setStrokeWidth(this.strokeSize);
        if (drawLeft) {
            canvas.drawLine(interval, (float)this.dividePadding, interval, (float)(height - this.dividePadding), this.paint);
        }
        if (drawTop) {
            canvas.drawLine((float)this.dividePadding, interval, (float)(width - this.dividePadding), interval, this.paint);
        }
        if (drawRight) {
            canvas.drawLine((float)width - interval, (float)this.dividePadding, (float)width - interval, (float)(height - this.dividePadding), this.paint);
        }
        if (drawBottom) {
            canvas.drawLine((float)(this.dividePadding + this.leftPadding), (float)height - interval, (float)(width - this.dividePadding), (float)height - interval, this.paint);
        }
    }

    private void drawItemDivide(Canvas canvas) {
        if (this.isShowItemDivide) {
            this.paint.reset();
            this.paint.setColor(this.itemDivideColor);
            this.paint.setStrokeWidth((float)((int)(this.itemStrokeSize / 2.0f + 0.5f)));
            int width = this.getWidth();
            int height = this.getHeight();
            int orientation = this.getOrientation();
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount - 1; ++i) {
                View childView = this.getChildAt(i);
                if (0 != childView.getVisibility()) continue;
                int paddingLeft = this.getPaddingLeft();
                int paddingTop = this.getPaddingTop();
                int paddingRight = this.getPaddingRight();
                int paddingBottom = this.getPaddingBottom();
                if (0 == orientation) {
                    int right = childView.getRight();
                    canvas.drawLine((float)right, (float)(this.itemDividePadding + paddingTop), (float)right, (float)(height - this.itemDividePadding - paddingBottom), this.paint);
                    continue;
                }
                if (1 != orientation) continue;
                int bottom = childView.getBottom();
                canvas.drawLine((float)(this.itemDividePadding + paddingLeft), (float)bottom, (float)(width - this.itemDividePadding - paddingRight), (float)bottom, this.paint);
            }
        }
    }
}

