/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import com.cz.library.R;
import com.cz.library.util.Utils;

public class BorderLabelTextView
extends TextView {
    private int textColor;
    private float textSize;
    private int borderColor;
    private float borderSize;
    private float leftPadding;
    private float borderPadding;
    private float labelPadding;
    private String text;
    private Paint paint = new Paint(1);

    public BorderLabelTextView(Context context) {
        this(context, null, 0);
    }

    public BorderLabelTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BorderLabelTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BorderLabelTextView);
        this.setTextColor(a.getColor(R.styleable.BorderLabelTextView_bt_textColor, -16777216));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.BorderLabelTextView_bt_textSize, 12));
        this.setLeftLabelPadding(a.getDimension(R.styleable.BorderLabelTextView_bt_leftLabelPadding, 0.0f));
        this.setBorderColor(a.getColor(R.styleable.BorderLabelTextView_bt_borderColor, -12303292));
        this.setBorderSize(a.getDimension(R.styleable.BorderLabelTextView_bt_borderSize, this.getResources().getDimension(R.dimen.divideSize)));
        this.setBorderPadding(a.getDimension(R.styleable.BorderLabelTextView_bt_borderPadding, 0.0f));
        this.setLabelPadding(a.getDimension(R.styleable.BorderLabelTextView_bt_labelPadding, (float)Utils.dip2px(8.0f)));
        this.setLabel(a.getString(R.styleable.BorderLabelTextView_bt_label));
        a.recycle();
    }

    public void setLabelPadding(float padding) {
        this.labelPadding = padding;
        this.invalidate();
    }

    public void setLabel(String text) {
        this.text = text;
        this.invalidate();
    }

    public void setLabel(@StringRes int res) {
        if (-1 != res) {
            this.setLabel(this.getResources().getString(res));
        }
    }

    public void setBorderColor(int mBorderColor) {
        this.borderColor = mBorderColor;
        this.invalidate();
    }

    public void setBorderSize(float mBorderSize) {
        this.borderSize = mBorderSize;
        this.invalidate();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public void setLeftLabelPadding(float leftPadding) {
        this.leftPadding = leftPadding;
        this.invalidate();
    }

    public void setBorderPadding(float padding) {
        this.borderPadding = padding;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            this.paint.setColor(this.textColor);
            this.paint.setTextSize(this.textSize);
            textWidth = this.paint.measureText(this.text);
            Rect textRect = new Rect();
            this.paint.getTextBounds(this.text, 0, this.text.length(), textRect);
            Paint.FontMetrics fm = this.paint.getFontMetrics();
            textHeight = (float)(textRect.height() / 2) - fm.descent + (fm.descent - fm.ascent) / 2.0f;
            canvas.drawText(this.text, this.leftPadding + this.borderPadding, textHeight + this.borderPadding, this.paint);
        }
        this.drawDivide(canvas, (int)textWidth, (int)textHeight, (int)this.leftPadding);
    }

    private void drawDivide(Canvas canvas, int textWidth, int textHeight, int leftPadding) {
        this.paint.reset();
        int width = this.getWidth();
        int height = this.getHeight();
        this.paint.setColor(this.borderColor);
        this.paint.setStrokeWidth(this.borderSize);
        float interval = this.borderSize / 2.0f;
        float halfTextHeight = textHeight / 2;
        canvas.drawLine(interval + this.borderPadding, halfTextHeight + this.borderPadding, interval + this.borderPadding, (float)height - this.borderPadding, this.paint);
        canvas.drawLine((float)width - interval - this.borderPadding, this.borderPadding + halfTextHeight, (float)width - interval - this.borderPadding, (float)height - this.borderPadding, this.paint);
        canvas.drawLine(this.borderPadding, (float)height - interval - this.borderPadding, (float)width - this.borderPadding, (float)height - interval - this.borderPadding, this.paint);
        canvas.drawLine(this.borderPadding, interval + halfTextHeight + this.borderPadding, this.borderPadding + (float)leftPadding - this.labelPadding, interval + halfTextHeight + this.borderPadding, this.paint);
        canvas.drawLine(this.borderPadding + (float)leftPadding + (float)textWidth + this.labelPadding, interval + halfTextHeight + this.borderPadding, (float)width - this.borderPadding, interval + halfTextHeight + this.borderPadding, this.paint);
    }
}

