/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.util;

import android.app.Application;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ArrayRes;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorRes;
import android.support.annotation.StringRes;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.lang.reflect.Method;

public class Utils {
    private static Context appContext = Utils.getContext();

    public static Context getContext() {
        if (appContext == null) {
            try {
                Class<?> activityThreadClass = Utils.class.getClassLoader().loadClass("android.app.ActivityThread");
                Method currentActivityThread = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
                Object activityThread = currentActivityThread.invoke(null, new Object[0]);
                Method getApplication = activityThreadClass.getDeclaredMethod("getApplication", new Class[0]);
                Application application = (Application)getApplication.invoke(activityThread, new Object[0]);
                appContext = application.getApplicationContext();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return appContext;
    }

    public static int getColor(@ColorRes int res) {
        Context context = Utils.getContext();
        return context.getResources().getColor(res);
    }

    public static String getString(@StringRes int res, Object value) {
        Context context = Utils.getContext();
        return context.getString(res, new Object[]{value});
    }

    public static int dip2px(float value) {
        return (int)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)appContext.getResources().getDisplayMetrics());
    }

    public static int px2dip(float value) {
        float scale = Utils.appContext.getResources().getDisplayMetrics().density;
        return (int)(value / scale + 0.5f);
    }

    public static int sp2px(float value) {
        return (int)TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)appContext.getResources().getDisplayMetrics());
    }

    public static float px2sp(float px) {
        float scaledDensity = Utils.appContext.getResources().getDisplayMetrics().scaledDensity;
        return px / scaledDensity;
    }

    public static float getDimensionPixelSize(@AttrRes int attr) {
        int[] attribute = new int[]{attr};
        TypedArray array = appContext.obtainStyledAttributes(null, attribute);
        int value = array.getDimensionPixelSize(0, 0);
        array.recycle();
        return value;
    }

    public static int getResourceId(@AttrRes int attr) {
        int[] attribute = new int[]{attr};
        TypedArray array = appContext.obtainStyledAttributes(null, attribute);
        int res = array.getResourceId(0, 0);
        array.recycle();
        return res;
    }

    public static String[] getStringArray(@ArrayRes int id) {
        return appContext.getResources().getStringArray(id);
    }

    public static int[] getIntArray(@ArrayRes int id) {
        return appContext.getResources().getIntArray(id);
    }
}

