/*
 * Decompiled with CFR 0.152.
 */
package com.cz.dblibrary.provider;

import android.app.ActivityManager;
import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import com.cz.dblibrary.DbHelper;
import com.cz.dblibrary.DbTable;
import com.cz.dblibrary.annotation.FieldFilter;
import com.cz.dblibrary.annotation.Table;
import com.cz.dblibrary.annotation.TableField;
import com.cz.dblibrary.db.MyDb;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DbProvider
extends ContentProvider {
    private static final String TAG = "DbProvider";
    private static final String HOST_CLASS = "/class:";
    private static final String HOST_TABLE = "/table:";
    private static final UriMatcher matcher = new UriMatcher(-1);
    private static final SparseArray<String> matchIds = new SparseArray();
    private static final SparseArray<LinkedHashMap<String, String>> selectionMaps = new SparseArray();
    public static SQLiteDatabase db;

    private static SQLiteDatabase getDatabase() {
        if (null == db) {
            db = new MyDb(DbHelper.getContext()).getWritableDatabase();
        }
        return db;
    }

    public static void execSQL(String sql) {
        DbProvider.getDatabase().execSQL(sql);
    }

    public static void execSQL(String sql, String[] bindArgs) {
        DbProvider.getDatabase().execSQL(sql, (Object[])bindArgs);
    }

    public static Cursor rawQuery(String sql, String[] selectionArgs) {
        return DbProvider.getDatabase().rawQuery(sql, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExist(String tableName) {
        boolean result = false;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            Cursor cursor = null;
            try {
                String sql = "select * from sqlite_master where name='" + tableName + "'";
                cursor = DbProvider.rawQuery(sql, null);
                if (cursor.moveToNext()) {
                    result = cursor.getCount() != 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != cursor) {
                    cursor.close();
                }
            }
        }
        return result;
    }

    private void ensureTable(Class<?> clazz) {
        String tableName = DbTable.getTable(clazz);
        if (!this.tableExist(tableName)) {
            this.createTable(clazz);
        }
        if (0 > matchIds.indexOfValue((Object)tableName)) {
            DbProvider.addTable(clazz);
        }
    }

    private void createTable(Class<?> clazz) {
        int size;
        Table table;
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Pair> primaryKeys = new ArrayList<Pair>();
        HashMap<Object, String> fieldItems = new HashMap<Object, String>();
        for (int i = 0; i < fields.length; ++i) {
            Object fieldName;
            Class<?> type = fields[i].getType();
            String fieldType = Integer.TYPE == type || Short.TYPE == type || Integer.class == type || Short.class == type ? " INTEGER" : (Float.TYPE == type || Double.TYPE == type || Float.class == type || Double.class == type ? " FLOAT" : (Boolean.TYPE == type || Boolean.class == type ? " BOOLEAN" : (Long.TYPE == type || Long.class == type ? " LONG" : " TEXT")));
            FieldFilter fieldFilter = fields[i].getAnnotation(FieldFilter.class);
            if (8 == (fields[i].getModifiers() & 8) || null != fieldFilter && fieldFilter.value()) continue;
            TableField tableField = fields[i].getAnnotation(TableField.class);
            if (null != tableField && !TextUtils.isEmpty((CharSequence)tableField.value())) {
                fieldName = tableField.value();
                if (tableField.primaryKey()) {
                    primaryKeys.add(new Pair(fieldName, (Object)tableField.autoIncrement()));
                }
            } else {
                fieldName = fields[i].getName();
            }
            fieldItems.put(fieldName, fieldType);
        }
        String tableName = DbTable.getTable(clazz);
        String sql = "CREATE TABLE " + tableName + "(";
        if (primaryKeys.isEmpty() && null != (table = clazz.getAnnotation(Table.class)) && !TextUtils.isEmpty((CharSequence)table.primaryKey())) {
            sql = sql + table.primaryKey() + " INTEGER PRIMARY KEY " + (table.autoIncrement() ? "AUTOINCREMENT" : "") + ",";
        }
        if (1 == (size = primaryKeys.size())) {
            Pair primaryPair = (Pair)primaryKeys.get(0);
            sql = sql + (String)primaryPair.first + " " + (String)fieldItems.get(primaryPair.first) + " PRIMARY KEY " + ((Boolean)primaryPair.second != false ? "AUTOINCREMENT" : "") + ",";
        }
        int index = 0;
        for (Map.Entry entry : fieldItems.entrySet()) {
            sql = sql + (String)entry.getKey() + " " + (String)entry.getValue() + " " + (index++ != fieldItems.size() - 1 ? "," : " ");
        }
        if (1 < size) {
            sql = sql + ", PRIMARY KEY(";
            for (int i = 0; i < size; ++i) {
                Pair pair = (Pair)primaryKeys.get(i);
                sql = sql + (String)pair.first + (i != size - 1 ? "," : "))");
            }
        } else {
            sql = sql + ")";
        }
        DbProvider.execSQL(sql);
    }

    private static void addTable(Class<?> clazz) {
        String tableName = DbTable.getTable(clazz);
        int index = matchIds.size();
        matcher.addURI(DbTable.AUTHORITY, tableName, index + 1);
        matchIds.append(index + 1, (Object)tableName);
        String[] selection = DbTable.getSelection(clazz);
        LinkedHashMap<String, String> selectionMap = new LinkedHashMap<String, String>();
        for (int s = 0; s < selection.length; ++s) {
            selectionMap.put(selection[s], selection[s]);
        }
        selectionMaps.append(index + 1, selectionMap);
    }

    private synchronized Uri ensureUri(Uri uri) {
        String path = uri.getPath();
        String authority = uri.getAuthority();
        Uri newUri = null;
        if (path.startsWith(HOST_CLASS)) {
            try {
                Class<?> clazz = Class.forName(path.substring(HOST_CLASS.length()));
                Table table = clazz.getAnnotation(Table.class);
                if (null != table && (table.exported() || this.isApplicationProcess(this.getContext()))) {
                    this.ensureTable(clazz);
                }
                newUri = Uri.parse((String)("content://" + authority + "/" + DbTable.getTable(clazz)));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            newUri = path.startsWith(HOST_TABLE) ? Uri.parse((String)("content://" + authority + "/" + path.substring(HOST_TABLE.length()))) : uri;
        }
        return newUri;
    }

    private boolean isApplicationProcess(Context context) {
        boolean result = false;
        String packageName = context.getPackageName();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List runningApps = am.getRunningAppProcesses();
        if (null != runningApps) {
            int pid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo processInfo : runningApps) {
                if (processInfo.pid != pid || !packageName.equals(processInfo.processName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean onCreate() {
        db = new MyDb(DbHelper.getContext()).getWritableDatabase();
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Uri newUri = this.ensureUri(uri);
        SQLiteQueryBuilder builder = new SQLiteQueryBuilder();
        int matchId = matcher.match(newUri);
        String tableName = (String)matchIds.get(matchId);
        HashMap map = (HashMap)selectionMaps.get(matchId);
        Cursor cursor = null;
        if (!TextUtils.isEmpty((CharSequence)tableName) && null != map) {
            builder.setTables(tableName);
            builder.setProjectionMap((Map)map);
            try {
                cursor = builder.query(DbProvider.getDatabase(), projection, selection, selectionArgs, null, null, sortOrder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null != cursor) {
                cursor.setNotificationUri(this.getContext().getContentResolver(), newUri);
            }
        }
        return cursor;
    }

    public Uri insert(Uri uri, ContentValues values) {
        Uri newUri = this.ensureUri(uri);
        int matchId = matcher.match(newUri);
        String tableName = (String)matchIds.get(matchId);
        Uri notifyUri = null;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            ContentValues contentValues = null != values ? new ContentValues(values) : new ContentValues();
            long rowId = DbProvider.getDatabase().insert(tableName, null, contentValues);
            if (rowId > 0L) {
                notifyUri = ContentUris.withAppendedId((Uri)newUri, (long)rowId);
                this.getContext().getContentResolver().notifyChange(notifyUri, null);
            }
        }
        return notifyUri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        Uri newUri = this.ensureUri(uri);
        int matchId = matcher.match(newUri);
        String tableName = (String)matchIds.get(matchId);
        int count = -1;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            if (!TextUtils.isEmpty((CharSequence)tableName)) {
                try {
                    count = DbProvider.getDatabase().delete(tableName, selection, selectionArgs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (-1 != count) {
                this.getContext().getContentResolver().notifyChange(newUri, null);
            }
        }
        return count;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        Uri newUri = this.ensureUri(uri);
        int matchId = matcher.match(newUri);
        String tableName = (String)matchIds.get(matchId);
        int count = -1;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            if (!TextUtils.isEmpty((CharSequence)tableName)) {
                try {
                    count = DbProvider.getDatabase().update(tableName, values, selection, selectionArgs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (-1 != count) {
                this.getContext().getContentResolver().notifyChange(newUri, null);
            }
        }
        return count;
    }

    public int bulkInsert(Uri uri, ContentValues[] values) {
        Uri newUri = this.ensureUri(uri);
        int matchId = matcher.match(newUri);
        String tableName = (String)matchIds.get(matchId);
        long lastId = -1L;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            SQLiteDatabase db = DbProvider.getDatabase();
            if (!TextUtils.isEmpty((CharSequence)tableName) && null != db) {
                db.beginTransaction();
                for (int i = 0; i < values.length; ++i) {
                    long rowId = db.insert(tableName, null, values[i]);
                    if (i == values.length - 1) {
                        lastId = rowId;
                    }
                    if (0L < rowId) continue;
                }
                db.setTransactionSuccessful();
                db.endTransaction();
            }
            if (lastId > 0L) {
                Uri noteUri = ContentUris.withAppendedId((Uri)newUri, (long)lastId);
                this.getContext().getContentResolver().notifyChange(noteUri, null);
            }
        }
        return (int)lastId;
    }

    public String getType(Uri uri) {
        return null;
    }
}

