/*
 * Decompiled with CFR 0.152.
 */
package com.cz.dblibrary;

import android.app.Application;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.cz.dblibrary.DbTable;
import com.cz.dblibrary.annotation.FieldFilter;
import com.cz.dblibrary.annotation.TableField;
import com.cz.dblibrary.provider.DbProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DbHelper {
    private static String packageName;
    private static final DbHelper helper;
    private static Context appContext;
    private OnDbUpgradeListener upgradeListener;

    public static Context getContext() {
        if (null == appContext) {
            try {
                Class<?> activityThreadClass = DbHelper.class.getClassLoader().loadClass("android.app.ActivityThread");
                Application application = (Application)activityThreadClass.getMethod("currentApplication", new Class[0]).invoke(null, new Object[0]);
                appContext = application.getApplicationContext();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return appContext;
    }

    public static String getPackageName() {
        if (packageName == null) {
            packageName = DbHelper.getContext().getPackageName();
        }
        return packageName;
    }

    public static String getDefaultDatabaseName() {
        return DbHelper.getPackageName() + "_db";
    }

    public static DbHelper get() {
        return helper;
    }

    private DbHelper() {
    }

    public void execSQL(String sql, String[] bindArgs) {
        DbProvider.execSQL(sql, bindArgs);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return DbProvider.rawQuery(sql, selectionArgs);
    }

    public final Uri insertItem(Object item) {
        Uri rtnUri = null;
        if (null != item) {
            Uri uri = DbTable.getUri(item.getClass());
            Context context = DbHelper.getContext();
            if (null != context && null != uri) {
                ContentResolver resolver = context.getContentResolver();
                rtnUri = resolver.insert(uri, DbTable.getContentValue(item));
            }
        }
        return rtnUri;
    }

    public final int bulkInsert(ArrayList items) {
        int code = -1;
        if (null != items && !items.isEmpty()) {
            Object obj = items.get(0);
            Uri uri = DbTable.getUri(obj.getClass());
            ContentValues[] values = new ContentValues[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                values[i] = DbTable.getContentValue(items.get(i));
            }
            Context context = DbHelper.getContext();
            if (null != context && null != uri) {
                ContentResolver resolver = context.getContentResolver();
                code = resolver.bulkInsert(uri, values);
            }
        }
        return code;
    }

    public final int updateItem(Object item, String where, String ... whereArgs) {
        int code = -1;
        if (null != item) {
            Uri uri = DbTable.getUri(item.getClass());
            Context context = DbHelper.getContext();
            if (null != context && null != uri) {
                ContentResolver resolver = context.getContentResolver();
                code = resolver.update(uri, DbTable.getContentValue(item), where, whereArgs);
            }
        }
        return code;
    }

    public final int deleteItem(Object item) {
        int code = -1;
        if (null != item) {
            Pair<String, String[]> where = this.getWhere(item);
            code = this.deleteItem(item, (String)where.first, (String[])where.second);
        }
        return code;
    }

    public final int deleteItem(Object item, String where, String ... whereArgs) {
        int code = -1;
        if (null != item) {
            Uri uri = DbTable.getUri(item.getClass());
            Context context = DbHelper.getContext();
            if (null != context && null != uri) {
                ContentResolver resolver = context.getContentResolver();
                code = resolver.delete(uri, where, whereArgs);
            }
        }
        return code;
    }

    public final Pair<String, String[]> getWhere(Object item) {
        Pair wherePair = new Pair(null, null);
        if (null != item) {
            Field[] fields = item.getClass().getDeclaredFields();
            HashMap<String, String> fieldItems = new HashMap<String, String>();
            for (int i = 0; i < fields.length; ++i) {
                FieldFilter fieldFilter = fields[i].getAnnotation(FieldFilter.class);
                if (8 == (fields[i].getModifiers() & 8) || null != fieldFilter && fieldFilter.value()) continue;
                fields[i].setAccessible(true);
                try {
                    Object value = fields[i].get(item);
                    if (null == value) continue;
                    fieldItems.put(fields[i].getName(), value.toString());
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            int index = 0;
            if (!fieldItems.isEmpty()) {
                String where = new String();
                String[] whereArgs = new String[fieldItems.size()];
                for (Map.Entry entry : fieldItems.entrySet()) {
                    where = where + (String)entry.getKey() + "=? " + (index != fieldItems.size() - 1 ? "and " : "");
                    whereArgs[index++] = (String)entry.getValue();
                }
                wherePair = new Pair((Object)where, (Object)whereArgs);
            }
        }
        return wherePair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E> E queryItem(Class<E> clazz, String where, String[] whereArgs, String order) {
        E item = null;
        Uri uri = DbTable.getUri(clazz);
        Context context = DbHelper.getContext();
        if (null != context && null != uri) {
            ContentResolver resolver = context.getContentResolver();
            Cursor cursor = null;
            try {
                String[] selection = DbTable.getSelection(clazz);
                cursor = resolver.query(uri, selection, where, whereArgs, order);
                if (null != cursor) {
                    item = this.getItemByCursor(clazz, cursor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != cursor) {
                    cursor.close();
                }
            }
        }
        return item;
    }

    public final <E> ArrayList<E> queryItems(Class<E> clazz) {
        return this.queryItems(clazz, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E> ArrayList<E> queryItems(Class<E> clazz, String where, String[] whereArgs, String order) {
        ArrayList<E> items = new ArrayList<E>();
        Uri uri = DbTable.getUri(clazz);
        Context context = DbHelper.getContext();
        if (null != context && null != uri) {
            ContentResolver resolver = context.getContentResolver();
            Cursor cursor = null;
            try {
                String[] selection = DbTable.getSelection(clazz);
                cursor = resolver.query(uri, selection, where, whereArgs, order);
                if (null != cursor) {
                    while (cursor.moveToNext()) {
                        items.add(this.getItemByCursor(clazz, cursor));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != cursor) {
                    cursor.close();
                }
            }
        }
        return items;
    }

    private <E> E getItemByCursor(Class<E> clazz, Cursor cursor) throws InstantiationException, IllegalAccessException {
        E item = clazz.newInstance();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int columnIndex;
            Field field = fields[i];
            field.setAccessible(true);
            TableField tableField = field.getAnnotation(TableField.class);
            String name = null != tableField && !TextUtils.isEmpty((CharSequence)tableField.value()) ? tableField.value() : field.getName();
            Class<?> type = field.getType();
            FieldFilter fieldFilter = fields[i].getAnnotation(FieldFilter.class);
            if (8 == (fields[i].getModifiers() & 8) || null != fieldFilter && fieldFilter.value() || 0 > (columnIndex = cursor.getColumnIndex(name))) continue;
            if (Integer.TYPE == type || Integer.class == type) {
                field.set(item, cursor.getInt(columnIndex));
                continue;
            }
            if (Short.TYPE == type || Short.class == type) {
                field.set(item, cursor.getShort(columnIndex));
                continue;
            }
            if (Float.TYPE == type || Float.class == type) {
                field.set(item, Float.valueOf(cursor.getFloat(columnIndex)));
                continue;
            }
            if (Double.TYPE == type || Double.class == type) {
                field.set(item, cursor.getDouble(columnIndex));
                continue;
            }
            if (Boolean.TYPE == type || Boolean.class == type) {
                field.set(item, 1 == cursor.getInt(columnIndex));
                continue;
            }
            if (Long.TYPE == type || Long.class == type) {
                field.set(item, cursor.getLong(columnIndex));
                continue;
            }
            field.set(item, cursor.getString(columnIndex));
        }
        return item;
    }

    public void truncateTable(Class<?> clazz) {
        Uri uri = DbTable.getUri(clazz);
        Context context = DbHelper.getContext();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.delete(uri, null, null);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (null != this.upgradeListener) {
            this.upgradeListener.onUpgrade(db, oldVersion, newVersion);
        }
    }

    public void setOnDbUpgradeListener(OnDbUpgradeListener listener) {
        this.upgradeListener = listener;
    }

    static {
        appContext = DbHelper.getContext();
        packageName = DbHelper.getPackageName();
        helper = new DbHelper();
    }

    public static interface OnDbUpgradeListener {
        public void onUpgrade(SQLiteDatabase var1, int var2, int var3);
    }
}

