/*
 * Decompiled with CFR 0.152.
 */
package com.cz.dblibrary.provider;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.cz.dblibrary.DbHelper;
import com.cz.dblibrary.DbTable;
import com.cz.dblibrary.db.MyDb;
import java.util.HashMap;
import java.util.Map;

public class DbProvider
extends ContentProvider {
    private static final String TAG = "DbProvider";
    private static final UriMatcher matcher = new UriMatcher(-1);
    private static final SparseArray<String> matchIds = new SparseArray();
    private static final SparseArray<HashMap<String, String>> selectionMaps = new SparseArray();
    public static SQLiteDatabase db;

    private static SQLiteDatabase getDatabase() {
        if (null == db) {
            db = new MyDb(DbHelper.getContext()).getWritableDatabase();
        }
        return db;
    }

    public static void execSQL(String sql) {
        DbProvider.getDatabase().execSQL(sql);
    }

    public static void execSQL(String sql, String[] bindArgs) {
        DbProvider.getDatabase().execSQL(sql, (Object[])bindArgs);
    }

    public static Cursor rawQuery(String sql, String[] selectionArgs) {
        return DbProvider.getDatabase().rawQuery(sql, selectionArgs);
    }

    public static void ensureTable(Class<?> clazz) {
        String tableName = DbTable.getTable(clazz);
        if (0 > matchIds.indexOfValue((Object)tableName)) {
            DbProvider.addTable(clazz);
        }
    }

    public static void addTable(Class<?> clazz) {
        String tableName = DbTable.getTable(clazz);
        int index = matchIds.size();
        matcher.addURI(DbTable.AUTHORITY, tableName, index + 1);
        matchIds.append(index + 1, (Object)tableName);
        String[] selection = DbTable.getSelection(clazz);
        HashMap<String, String> selectionMap = new HashMap<String, String>();
        for (int s = 0; s < selection.length; ++s) {
            selectionMap.put(selection[s], selection[s]);
        }
        selectionMaps.append(index + 1, selectionMap);
    }

    public boolean onCreate() {
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder builder = new SQLiteQueryBuilder();
        int matchId = matcher.match(uri);
        String tableName = (String)matchIds.get(matchId);
        HashMap map = (HashMap)selectionMaps.get(matchId);
        if (TextUtils.isEmpty((CharSequence)tableName) || null == map) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        builder.setTables(tableName);
        builder.setProjectionMap((Map)map);
        Cursor cursor = null;
        try {
            cursor = builder.query(DbProvider.getDatabase(), projection, selection, selectionArgs, null, null, sortOrder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != cursor) {
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    public Uri insert(Uri uri, ContentValues values) {
        int matchId = matcher.match(uri);
        String tableName = (String)matchIds.get(matchId);
        Log.e((String)TAG, (String)("matchId:" + matchId + " tableName:" + tableName));
        if (TextUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        ContentValues contentValues = null != values ? new ContentValues(values) : new ContentValues();
        long rowId = DbProvider.getDatabase().insert(tableName, null, contentValues);
        if (rowId > 0L) {
            Uri noteUri = ContentUris.withAppendedId((Uri)uri, (long)rowId);
            this.getContext().getContentResolver().notifyChange(noteUri, null);
            return noteUri;
        }
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int matchId = matcher.match(uri);
        String tableName = (String)matchIds.get(matchId);
        if (TextUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        int count = -1;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            try {
                count = DbProvider.getDatabase().delete(tableName, selection, selectionArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (-1 != count) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return count;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int matchId = matcher.match(uri);
        String tableName = (String)matchIds.get(matchId);
        if (TextUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        int count = -1;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            try {
                count = DbProvider.getDatabase().update(tableName, values, selection, selectionArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (-1 != count) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return count;
    }

    public int bulkInsert(Uri uri, ContentValues[] values) {
        int matchId = matcher.match(uri);
        String tableName = (String)matchIds.get(matchId);
        if (TextUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        long lastId = -1L;
        SQLiteDatabase db = DbProvider.getDatabase();
        if (!TextUtils.isEmpty((CharSequence)tableName) && null != db) {
            db.beginTransaction();
            for (int i = 0; i < values.length; ++i) {
                long rowId = db.replace(tableName, null, values[i]);
                if (i == values.length - 1) {
                    lastId = rowId;
                }
                if (0L < rowId) continue;
            }
            db.setTransactionSuccessful();
            db.endTransaction();
        }
        if (lastId > 0L) {
            Uri noteUri = ContentUris.withAppendedId((Uri)uri, (long)lastId);
            this.getContext().getContentResolver().notifyChange(noteUri, null);
        }
        return (int)lastId;
    }

    public String getType(Uri uri) {
        return null;
    }
}

