/*
 * Decompiled with CFR 0.152.
 */
package com.cz.dblibrary;

import android.content.ContentValues;
import android.net.Uri;
import android.text.TextUtils;
import com.cz.dblibrary.DbHelper;
import com.cz.dblibrary.annotation.FieldFilter;
import com.cz.dblibrary.annotation.Table;
import com.cz.dblibrary.annotation.TableField;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class DbTable {
    public static final String AUTHORITY = DbHelper.getPackageName();

    public static String[] getSelection(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<String> selectionLists = new ArrayList<String>();
        Table table = clazz.getAnnotation(Table.class);
        if (null != table && !TextUtils.isEmpty((CharSequence)table.primaryKey())) {
            selectionLists.add(table.primaryKey());
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            TableField tableField = fields[i].getAnnotation(TableField.class);
            String fieldName = null != tableField && !TextUtils.isEmpty((CharSequence)tableField.value()) ? tableField.value() : fields[i].getName();
            FieldFilter fieldFilter = fields[i].getAnnotation(FieldFilter.class);
            if (null != fieldFilter && fieldFilter.value()) continue;
            selectionLists.add(fieldName);
        }
        return selectionLists.toArray(new String[selectionLists.size()]);
    }

    public static String getTable(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        String tableName = null != table && !TextUtils.isEmpty((CharSequence)table.value()) ? table.value() : clazz.getSimpleName();
        return tableName;
    }

    public static ContentValues getContentValue(Object item) {
        Class<?> clazz = item.getClass();
        ContentValues values = new ContentValues();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            TableField tableField = field.getAnnotation(TableField.class);
            String name = null != tableField && !TextUtils.isEmpty((CharSequence)tableField.value()) ? tableField.value() : field.getName();
            Class<?> type = field.getType();
            FieldFilter fieldFilter = fields[i].getAnnotation(FieldFilter.class);
            if (null != fieldFilter && fieldFilter.value()) continue;
            try {
                if (Integer.TYPE == type || Integer.class == type) {
                    values.put(name, Integer.valueOf(field.getInt(item)));
                    continue;
                }
                if (Short.TYPE == type || Short.class == type) {
                    values.put(name, Short.valueOf(field.getShort(item)));
                    continue;
                }
                if (Float.TYPE == type || Float.class == type) {
                    values.put(name, Float.valueOf(field.getFloat(item)));
                    continue;
                }
                if (Double.TYPE == type || Double.class == type) {
                    values.put(name, Double.valueOf(field.getDouble(item)));
                    continue;
                }
                if (Boolean.TYPE == type || Boolean.class == type) {
                    values.put(name, Boolean.valueOf(field.getBoolean(item)));
                    continue;
                }
                if (Long.TYPE == type || Long.class == type) {
                    values.put(name, Long.valueOf(field.getLong(item)));
                    continue;
                }
                if (null == field.get(item)) continue;
                values.put(name, field.get(item).toString());
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return values;
    }

    public static Uri getUri(Class<?> clazz) {
        return Uri.parse((String)("content://" + AUTHORITY + "/" + DbTable.getTable(clazz)));
    }

    public static Uri getUri(String tableName) {
        return Uri.parse((String)("content://" + AUTHORITY + "/" + tableName));
    }

    public static Uri getUri(String authority, Class<?> clazz) {
        Uri uri = null;
        if (!TextUtils.isEmpty((CharSequence)authority)) {
            uri = Uri.parse((String)("content://" + authority + "/" + DbTable.getTable(clazz)));
        }
        return uri;
    }
}

