/*
 * Decompiled with CFR 0.152.
 */
package xyqb.library;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.List;
import xyqb.library.AnimatorListener;
import xyqb.library.AnimatorListenerAdapter;
import xyqb.library.AnimatorUpdateListener;

public final class AnimatorCompat {
    public static Animator ofInt(int value) {
        return new Animator(value);
    }

    public static Animator ofFloat(float value) {
        return new Animator(Float.valueOf(value));
    }

    public static class Animator {
        private final Handler handler = new Handler(Looper.getMainLooper());
        private List<AnimatorListener> listeners = new ArrayList<AnimatorListener>();
        private List<AnimatorUpdateListener> updateListeners = new ArrayList<AnimatorUpdateListener>();
        private long startTime;
        private long duration = 200L;
        private float fraction = 0.0f;
        private Object target;
        private Object animatorValue;
        private boolean started = false;
        private boolean ended = false;
        private Runnable loopRunnable = new Runnable(){

            @Override
            public void run() {
                long dt = System.currentTimeMillis() - Animator.this.startTime;
                float fraction = (float)dt * 1.0f / (float)Animator.this.duration;
                if (Animator.this.target instanceof Integer) {
                    Integer target = (Integer)Animator.this.target;
                    Animator.this.animatorValue = (int)((float)target.intValue() * fraction);
                } else if (Animator.this.target instanceof Float) {
                    Float target = (Float)Animator.this.target;
                    Animator.this.animatorValue = Float.valueOf(target.floatValue() * fraction);
                }
                if (fraction > 1.0f) {
                    fraction = 1.0f;
                    Animator.this.animatorValue = Animator.this.target;
                }
                Animator.this.fraction = fraction;
                Animator.this.notifyUpdateListeners(fraction);
                if (Animator.this.fraction >= 1.0f) {
                    Animator.this.dispatchEnd();
                } else {
                    Animator.this.handler.postDelayed(Animator.this.loopRunnable, 16L);
                }
            }
        };

        private Animator(Object v) {
            this.target = v;
        }

        private void notifyUpdateListeners(float fraction) {
            for (int i = this.updateListeners.size() - 1; i >= 0; --i) {
                this.updateListeners.get(i).onAnimationUpdate(this, fraction);
            }
        }

        public void addListener(AnimatorListenerAdapter listener) {
            this.listeners.add(listener);
        }

        public void setDuration(long duration) {
            if (!this.started) {
                this.duration = duration;
            }
        }

        public void start() {
            if (this.started) {
                return;
            }
            this.started = true;
            this.dispatchStart();
            this.fraction = 0.0f;
            this.startTime = System.currentTimeMillis();
            this.handler.postDelayed(this.loopRunnable, 16L);
        }

        private void dispatchStart() {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).onAnimationStart(this);
            }
        }

        private void dispatchEnd() {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).onAnimationEnd(this);
            }
        }

        private void dispatchCancel() {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).onAnimationCancel(this);
            }
        }

        public void cancel() {
            if (this.ended) {
                return;
            }
            this.ended = true;
            if (this.started) {
                this.dispatchCancel();
            }
            this.dispatchEnd();
        }

        public void addUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
            this.updateListeners.add(animatorUpdateListener);
        }

        public float getAnimatedFraction() {
            return this.fraction;
        }

        public Object getAnimatedValue() {
            return this.animatorValue;
        }

        public Integer getAnimatedIntValue() {
            return (Integer)this.animatorValue;
        }

        public Float getAnimatedFloatValue() {
            return (Float)this.animatorValue;
        }
    }
}

