/*
 * Decompiled with CFR 0.152.
 */
package com.cysion.mvcation.base;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.cysion.mvcation.CacheProxy;
import com.cysion.mvcation.MvcPointer;
import com.cysion.mvcation.MvcUtils;
import com.cysion.mvcation.base.DataState;
import com.cysion.mvcation.base.HttpProxy;
import com.cysion.mvcation.base.TActionListener;
import com.cysion.mvcation.base.THttpListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class MvcAction {
    private static final String TAG = "MvcAction";
    protected static Context mContext;
    private static boolean DEBUG;
    private String url;
    protected DataState mActionCode;
    protected Method mReqMethod;
    private int taskId = -1;
    protected Map<String, String> params;
    protected TActionListener listener;
    private String key;
    protected static Map<String, String> mHeader;
    private String mPath;
    protected THttpListener callBack = new THttpListener(){

        @Override
        public void onSuccess(Object obj, int aTaskId) {
            String result = (String)obj;
            if (MvcAction.this.handleDataFromNet(result, aTaskId)) {
                MvcAction.this.writeToCache(result);
            } else if (MvcAction.this.mActionCode != DataState.NET_FIRST || !MvcAction.this.isCacheValid(aTaskId)) {
                MvcAction.this.listener.onFailure("connect success but no target data", aTaskId);
            }
        }

        @Override
        public void onFailure(Object obj, int taskId) {
            if ("in Lan without network".equals(obj)) {
                MvcAction.this.listener.onFailure("in Lan without network", taskId);
            } else {
                MvcAction.this.listener.onFailure("no target data", taskId);
            }
        }
    };

    public static void initAction(Context aContext, boolean isDebug) {
        mContext = aContext.getApplicationContext();
        if (isDebug) {
            MvcAction.setDebug();
        }
    }

    public MvcAction(TActionListener aListener) {
        if (mContext != null) {
            this.listener = aListener;
            this.mActionCode = DataState.NO_CACHE;
        } else {
            try {
                throw new Exception("should invoke initAction firstly");
            }
            catch (Exception aE) {
                aE.printStackTrace();
            }
        }
    }

    public MvcAction params(Map<String, String> aParams) {
        this.params = aParams;
        return this;
    }

    public MvcAction taskId(int id) {
        this.taskId = id;
        return this;
    }

    public MvcAction path(String path) {
        this.mPath = path;
        return this;
    }

    public void execute(DataState actionCode) {
        this.mActionCode = actionCode;
        this.url = this.getUrl(this.taskId);
        this.mReqMethod = this.getHttpMethod(this.taskId);
        if (!TextUtils.isEmpty((CharSequence)this.mPath)) {
            this.url = this.url + this.mPath;
            this.mPath = null;
        }
        this.checkUrlAndId();
        this.checkActionCode();
        this.getKey();
        if (!MvcUtils.isNetAvailable(mContext)) {
            this.whenNoNet();
            return;
        }
        if (this.mActionCode == DataState.CACHE_FIRST) {
            if (!this.isCacheValid(this.taskId)) {
                this.byHttp();
            }
        } else {
            this.byHttp();
        }
    }

    protected int getKeepTime() {
        return Integer.MAX_VALUE;
    }

    protected Map<String, String> getHeader() {
        if (mHeader == null) {
            mHeader = new HashMap<String, String>();
        }
        return mHeader;
    }

    protected Map<String, String> fixedParams() {
        return new HashMap<String, String>();
    }

    protected void whenNoNet() {
        this.logv("no-network");
        this.listener.onFailure("find no net", this.taskId);
        switch (this.mActionCode) {
            case CACHE_FIRST: 
            case NET_FIRST: {
                this.isCacheValid(this.taskId);
                break;
            }
        }
    }

    protected HttpProxy getHttpProxy() {
        return MvcPointer.getHttpProxy();
    }

    protected void byHttp() {
        if (this.mReqMethod == Method.Method_GET) {
            if (this.params.size() > 0) {
                this.url = this.getAppearUrl(this.params);
            }
            this.getHttpProxy().getData(this.url, this.callBack, this.getParams(), this.getHeader(), this.taskId);
        } else if (this.mReqMethod == Method.Method_POST) {
            this.getHttpProxy().postData(this.url, this.callBack, this.getParams(), this.getHeader(), this.taskId);
        }
        Map<String, String> tempHeader = this.getHeader();
        for (Map.Entry<String, String> entry : tempHeader.entrySet()) {
            String key = entry.getKey();
            this.logv("header--" + key + ":" + entry.getValue());
        }
        this.taskId = -1;
        this.url = this.getUrl(this.taskId);
        this.params = null;
        this.logv("clear the field of action");
    }

    protected abstract String getUrl(int var1);

    protected abstract Method getHttpMethod(int var1);

    protected abstract boolean getTargetDataFromJson(String var1, int var2);

    protected boolean handleDataFromNet(String aResult, int aTaskId) {
        this.logv("from network");
        return this.getTargetDataFromJson(aResult, aTaskId);
    }

    protected boolean handleDataFromCache(String aResult, int aTaskId) {
        this.logv("from cache");
        return this.getTargetDataFromJson(aResult, aTaskId);
    }

    protected void loadMoreCache(String aShouldCache) {
    }

    protected void addHeadCache(String aShouldCache) {
        CacheProxy cacheObj = CacheProxy.get(mContext);
        cacheObj.remove(this.key);
        cacheObj.put(this.key, aShouldCache, this.getKeepTime());
    }

    private void getKey() {
        this.params = this.getParams();
        String buffer = this.getAppearUrl(this.params);
        this.logv("method--" + (Object)((Object)this.getHttpMethod(this.taskId)) + "--url---" + buffer);
        try {
            this.key = MvcUtils.MD5encrypt(buffer.toString(), "utf-8");
        }
        catch (Exception aE) {
            aE.printStackTrace();
        }
    }

    private void checkUrlAndId() {
        if (TextUtils.isEmpty((CharSequence)this.url) || this.taskId == -1) {
            try {
                throw new Exception("should give url a value or give taskId a value");
            }
            catch (Exception aE) {
                aE.printStackTrace();
            }
        }
    }

    private void checkActionCode() {
        DataState[] values = DataState.values();
        if (!Arrays.asList(values).contains((Object)this.mActionCode)) {
            try {
                throw new Exception("invalid actionCode");
            }
            catch (Exception aE) {
                aE.printStackTrace();
            }
        }
    }

    private Map<String, String> getParams() {
        if (this.params != null) {
            return this.params;
        }
        Map<String, String> temp = this.fixedParams();
        return temp;
    }

    private String getAppearUrl(Map<String, String> aParams) {
        String temp = this.url + "?";
        Set<String> strings = aParams.keySet();
        for (String aKey : strings) {
            temp = temp + aKey + "=" + aParams.get(aKey) + "&";
        }
        temp = temp.substring(0, temp.length() - 1);
        return temp;
    }

    private void logv(String lable) {
        if (DEBUG) {
            Log.d((String)TAG, (String)lable);
        }
    }

    private String readCache(long aTaskId) {
        if (this.mActionCode == DataState.NO_CACHE) {
            return null;
        }
        CacheProxy cacheObj = CacheProxy.get(mContext);
        String fromCache = cacheObj.getAsString(this.key);
        return fromCache;
    }

    private static void setDebug() {
        DEBUG = true;
    }

    private void writeToCache(String shouldCache) {
        if (this.mActionCode == DataState.NO_CACHE) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)shouldCache)) {
            return;
        }
        CacheProxy cacheObj = CacheProxy.get(mContext);
        switch (this.mActionCode) {
            case CACHE_FIRST: 
            case NET_FIRST: {
                cacheObj.remove(this.key);
                cacheObj.put(this.key, shouldCache, this.getKeepTime());
                break;
            }
            case HEAD_REFRESH: {
                this.addHeadCache(shouldCache);
                break;
            }
            case LOAD_MORE: {
                this.loadMoreCache(shouldCache);
            }
        }
    }

    private boolean isCacheValid(int aTaskId) {
        String fromCache = this.readCache(aTaskId);
        if (!TextUtils.isEmpty((CharSequence)fromCache)) {
            return this.handleDataFromCache(fromCache, aTaskId);
        }
        return false;
    }

    static {
        DEBUG = false;
    }

    public static enum Method {
        Method_GET,
        Method_POST;

    }
}

