/*
 * Decompiled with CFR 0.152.
 */
package com.cyrillrx.logger.extension;

import com.cyrillrx.logger.LogHelper;
import com.cyrillrx.logger.SeverityLogChild;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CrashlyticsLogger
extends SeverityLogChild {
    static final String ISO_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ssZZZZZ'['zzz']'";
    private final SimpleDateFormat dateFormatter;
    private final FirebaseCrashlytics crashlytics = FirebaseCrashlytics.getInstance();

    public CrashlyticsLogger(int severity, String dateTimePattern) {
        super(severity);
        this.dateFormatter = new SimpleDateFormat(dateTimePattern, Locale.getDefault());
    }

    public CrashlyticsLogger(int severity) {
        this(severity, ISO_DATE_TIME);
    }

    protected void doLog(int severity, String tag, String message, Throwable throwable) {
        if (throwable == null) {
            this.simpleLog(severity, tag, message);
            return;
        }
        String stackTrace = LogHelper.getStackTrace((Throwable)throwable);
        if (stackTrace == null) {
            this.simpleLog(severity, tag, message);
            return;
        }
        this.logWithStackTrace(severity, tag, message, stackTrace);
    }

    private void simpleLog(int severity, String tag, String message) {
        this.println("%s/%s : %s - %s", CrashlyticsLogger.severityLabel(severity), tag, this.getCurrentDateTime(), message);
    }

    private void logWithStackTrace(int severity, String tag, String message, String stackTrace) {
        this.println("%s/%s : %s - %s\n%s", CrashlyticsLogger.severityLabel(severity), tag, this.getCurrentDateTime(), message, stackTrace);
    }

    private String getCurrentDateTime() {
        return this.dateFormatter.format(new Date());
    }

    private void println(String format, Object ... args) {
        this.println(String.format(format, args));
    }

    private void println(String x) {
        this.crashlytics.log(x);
    }

    private static String severityLabel(int severity) {
        switch (severity) {
            case 5: {
                return "V";
            }
            case 4: {
                return "D";
            }
            case 3: {
                return "I";
            }
            case 2: {
                return "W";
            }
        }
        return "E";
    }
}

