/*
 * Decompiled with CFR 0.152.
 */
package com.cyrillrx.logger.extension;

import com.crashlytics.android.Crashlytics;
import com.cyrillrx.logger.LogHelper;
import com.cyrillrx.logger.Severity;
import com.cyrillrx.logger.SeverityLogChild;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CrashlyticsLogger
extends SeverityLogChild {
    static final String ISO_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ssZZZZZ'['zzz']'";
    private final SimpleDateFormat dateFormatter;

    public CrashlyticsLogger(int severity, String dateTimePattern) {
        super(severity);
        this.dateFormatter = new SimpleDateFormat(dateTimePattern, Locale.getDefault());
    }

    public CrashlyticsLogger(int severity) {
        this(severity, ISO_DATE_TIME);
    }

    protected void doLog(int severity, String tag, String message, Throwable throwable) {
        if (throwable == null) {
            this.simpleLog(severity, tag, message);
            return;
        }
        String stackTrace = LogHelper.getStackTrace((Throwable)throwable);
        if (stackTrace == null) {
            this.simpleLog(severity, tag, message);
            return;
        }
        this.logWithStackTrace(severity, tag, message, stackTrace);
        Crashlytics.logException((Throwable)throwable);
    }

    private void simpleLog(int severity, String tag, String message) {
        CrashlyticsLogger.println("%s - %s - %s - %s", this.getCurrentDateTime(), Severity.getLabel((int)severity), tag, message);
    }

    private void logWithStackTrace(int severity, String tag, String message, String stackTrace) {
        CrashlyticsLogger.println("%s - %s - %s - %s\n%s", this.getCurrentDateTime(), Severity.getLabel((int)severity), tag, message, stackTrace);
    }

    private String getCurrentDateTime() {
        return this.dateFormatter.format(new Date());
    }

    private static void println(String format, Object ... args) {
        CrashlyticsLogger.println(String.format(format, args));
    }

    private static void println(String x) {
        Crashlytics.log((String)x);
    }
}

