/*
 * Decompiled with CFR 0.152.
 */
package com.cyrillrx.logger.extension;

import com.crashlytics.android.Crashlytics;
import com.cyrillrx.logger.LogHelper;
import com.cyrillrx.logger.Severity;
import com.cyrillrx.logger.SeverityLogChild;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CrashlyticsLogger
extends SeverityLogChild {
    private static final SimpleDateFormat ISO_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX'['zzzz']'", Locale.getDefault());

    public CrashlyticsLogger(int severity) {
        super(severity);
    }

    protected void doLog(int severity, String tag, String message, Throwable throwable) {
        if (throwable == null) {
            CrashlyticsLogger.simpleLog(severity, tag, message);
            return;
        }
        String stackTrace = LogHelper.getStackTrace((Throwable)throwable);
        if (stackTrace == null) {
            CrashlyticsLogger.simpleLog(severity, tag, message);
            return;
        }
        CrashlyticsLogger.logWithStackTrace(severity, tag, message, stackTrace);
        Crashlytics.logException((Throwable)throwable);
    }

    private static void simpleLog(int severity, String tag, String message) {
        CrashlyticsLogger.println("%s - %s - %s - %s", CrashlyticsLogger.getCurrentDateTime(), Severity.getLabel((int)severity), tag, message);
    }

    private static void logWithStackTrace(int severity, String tag, String message, String stackTrace) {
        CrashlyticsLogger.println("%s - %s - %s - %s\n%s", CrashlyticsLogger.getCurrentDateTime(), Severity.getLabel((int)severity), tag, message, stackTrace);
    }

    private static void println(String format, Object ... args) {
        CrashlyticsLogger.println(String.format(format, args));
    }

    private static void println(String x) {
        Crashlytics.log((String)x);
    }

    private static String getCurrentDateTime() {
        return ISO_DATE_TIME.format(new Date());
    }
}

