/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.Connection;
import com.cybersource.ws.client.ConnectionHelper;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public class JDKHttpURLConnection
extends Connection {
    private boolean _isRequestSent = false;
    private HttpURLConnection con = null;

    JDKHttpURLConnection(MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) {
        super(mc, builder, logger);
        logger.log("INFO     ", "Using JDKHttpURLConnection for connections.");
    }

    @Override
    void postDocument(Document request, long startTime) throws IOException, TransformerException {
        String serverURL = this.mc.getEffectiveServerURL();
        URL url = new URL(serverURL);
        this.con = ConnectionHelper.openConnection(url, this.mc);
        this.con.setRequestProperty("v-c-client-iat", String.valueOf(System.currentTimeMillis()));
        this.con.setRequestProperty("v-c-client-computetime", String.valueOf(System.currentTimeMillis() - startTime));
        this.con.setRequestMethod("POST");
        this.con.setDoOutput(true);
        ConnectionHelper.setTimeout(this.con, this.mc);
        this.logRequestHeaders();
        OutputStream out = this.con.getOutputStream();
        byte[] requestBytes = JDKHttpURLConnection.documentToByteArray(request);
        this.logger.log("INFO     ", "Sending " + requestBytes.length + " bytes to " + serverURL);
        out.write(requestBytes);
        out.close();
        this._isRequestSent = true;
    }

    @Override
    public boolean isRequestSent() {
        return this._isRequestSent;
    }

    @Override
    public void release() {
        this.con = null;
    }

    @Override
    int getHttpResponseCode() throws IOException {
        return this.con != null ? this.con.getResponseCode() : -1;
    }

    @Override
    InputStream getResponseStream() throws IOException {
        return this.con != null ? this.con.getInputStream() : null;
    }

    @Override
    InputStream getResponseErrorStream() {
        return this.con != null ? this.con.getErrorStream() : null;
    }

    private static byte[] documentToByteArray(Document doc) throws TransformerConfigurationException, TransformerException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = JDKHttpURLConnection.makeStream(doc);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
    }

    @Override
    public void logResponseHeaders() {
        if (this.mc.getEnableLog() && this.con != null) {
            long resIAT;
            String responseTime = this.con.getHeaderField("v-c-response-time");
            if (StringUtils.isNotBlank((CharSequence)responseTime) && (resIAT = Utility.getResponseIssuedAtTime(responseTime)) > 0L) {
                this.logger.log("INFO     ", "responseTransitTimeSec : " + Utility.getResponseTransitTime(resIAT));
            }
            this.logger.log("INFO     ", "Response headers : " + this.con.getHeaderFields());
        }
    }

    @Override
    public void logRequestHeaders() {
        if (this.mc.getEnableLog() && this.con != null) {
            this.logger.log("INFO     ", "Request Headers : " + this.con.getRequestProperties());
        }
    }
}

