/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.CardProcessingConfigCommonAcquirer;
import Model.CardProcessingConfigCommonCurrencies1;
import Model.CardProcessingConfigCommonPaymentTypes;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CardProcessingConfigCommonProcessors {
    @SerializedName(value="batchGroup")
    private String batchGroup = null;
    @SerializedName(value="businessApplicationId")
    private String businessApplicationId = null;
    @SerializedName(value="merchantVerificationValue")
    private String merchantVerificationValue = null;
    @SerializedName(value="abaNumber")
    private String abaNumber = null;
    @SerializedName(value="acquirer")
    private CardProcessingConfigCommonAcquirer acquirer = null;
    @SerializedName(value="merchantId")
    private String merchantId = null;
    @SerializedName(value="terminalId")
    private String terminalId = null;
    @SerializedName(value="paymentTypes")
    private Map<String, CardProcessingConfigCommonPaymentTypes> paymentTypes = null;
    @SerializedName(value="currencies")
    private Map<String, CardProcessingConfigCommonCurrencies1> currencies = null;
    @SerializedName(value="sicCode")
    private String sicCode = null;
    @SerializedName(value="allowMultipleBills")
    private Boolean allowMultipleBills = null;
    @SerializedName(value="allowMerchantDescriptorOverride")
    private Boolean allowMerchantDescriptorOverride = null;
    @SerializedName(value="enhancedData")
    private String enhancedData = null;
    @SerializedName(value="fireSafetyIndicator")
    private Boolean fireSafetyIndicator = null;
    @SerializedName(value="quasiCash")
    private Boolean quasiCash = null;
    @SerializedName(value="acquirerMerchantId")
    private String acquirerMerchantId = null;
    @SerializedName(value="avsFormat")
    private String avsFormat = null;
    @SerializedName(value="enableLongTransRefNo")
    private Boolean enableLongTransRefNo = null;
    @SerializedName(value="enableLevel2")
    private Boolean enableLevel2 = null;
    @SerializedName(value="enableMultipleTransactionAdviceAddendum")
    private Boolean enableMultipleTransactionAdviceAddendum = null;
    @SerializedName(value="amexTransactionAdviceAddendum1")
    private String amexTransactionAdviceAddendum1 = null;
    @SerializedName(value="enableMultiLineItems")
    private Boolean enableMultiLineItems = null;
    @SerializedName(value="enableTransactionReferenceNumber")
    private Boolean enableTransactionReferenceNumber = null;
    @SerializedName(value="enableAutoAuthReversalAfterVoid")
    private Boolean enableAutoAuthReversalAfterVoid = null;
    @SerializedName(value="enableExpresspayPanTranslation")
    private Boolean enableExpresspayPanTranslation = null;
    @SerializedName(value="enableCreditAuth")
    private Boolean enableCreditAuth = null;
    @SerializedName(value="industryCode")
    private IndustryCodeEnum industryCode = null;
    @SerializedName(value="sendAmexLevel2Data")
    private Boolean sendAmexLevel2Data = null;
    @SerializedName(value="softDescriptorType")
    private String softDescriptorType = null;
    @SerializedName(value="vitalNumber")
    private String vitalNumber = null;
    @SerializedName(value="bankNumber")
    private String bankNumber = null;
    @SerializedName(value="chainNumber")
    private String chainNumber = null;
    @SerializedName(value="merchantBinNumber")
    private String merchantBinNumber = null;
    @SerializedName(value="merchantLocationNumber")
    private String merchantLocationNumber = null;
    @SerializedName(value="storeID")
    private String storeID = null;
    @SerializedName(value="travelAgencyCode")
    private String travelAgencyCode = null;
    @SerializedName(value="travelAgencyName")
    private String travelAgencyName = null;
    @SerializedName(value="settlementCurrency")
    private String settlementCurrency = null;
    @SerializedName(value="enableLeastCostRouting")
    private Boolean enableLeastCostRouting = null;
    @SerializedName(value="enableCVVResponseIndicator")
    private Boolean enableCVVResponseIndicator = null;
    @SerializedName(value="enableMultiCurrencyProcessing")
    private String enableMultiCurrencyProcessing = null;
    @SerializedName(value="enablePosNetworkSwitching")
    private Boolean enablePosNetworkSwitching = null;
    @SerializedName(value="enableDynamicCurrencyConversion")
    private Boolean enableDynamicCurrencyConversion = null;
    @SerializedName(value="merchantTier")
    private String merchantTier = null;

    public CardProcessingConfigCommonProcessors batchGroup(String batchGroup) {
        this.batchGroup = batchGroup;
        return this;
    }

    @ApiModelProperty(value="Determines the batching group that separates merchants for special batching times. Batching groups can separate merchant batches by the following criteria:  * Timezone * Merchant deadlines * Large merchants (top 10) * Merchants with Service-Level Agreements  Applicable for Chase Paymentech Salem (chasepaymentechsalem), Streamline (streamline2), Six (six), Barclays (barclays2), Paymentech Tampa (paymentechtampa), CMCIC (cmcic), FDC Nashville (smartfdc), RUPAY, American Express Direct (amexdirect), GPN (gpn), VPC, GPX (gpx), CB2A, Barclays HISO (barclayshiso), TSYS (tsys) and FDI Global (fdiglobal) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td></tr> </table> ")
    public String getBatchGroup() {
        return this.batchGroup;
    }

    public void setBatchGroup(String batchGroup) {
        this.batchGroup = batchGroup;
    }

    public CardProcessingConfigCommonProcessors businessApplicationId(String businessApplicationId) {
        this.businessApplicationId = businessApplicationId;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of money transfer used in the transaction. Applicable for VPC and GPX (gpx) processors.")
    public String getBusinessApplicationId() {
        return this.businessApplicationId;
    }

    public void setBusinessApplicationId(String businessApplicationId) {
        this.businessApplicationId = businessApplicationId;
    }

    public CardProcessingConfigCommonProcessors merchantVerificationValue(String merchantVerificationValue) {
        this.merchantVerificationValue = merchantVerificationValue;
        return this;
    }

    @ApiModelProperty(value="Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant. Applicable for GPX (gpx) and VPC processors.")
    public String getMerchantVerificationValue() {
        return this.merchantVerificationValue;
    }

    public void setMerchantVerificationValue(String merchantVerificationValue) {
        this.merchantVerificationValue = merchantVerificationValue;
    }

    public CardProcessingConfigCommonProcessors abaNumber(String abaNumber) {
        this.abaNumber = abaNumber;
        return this;
    }

    @ApiModelProperty(value="Routing Number to identify banks within the United States. Applicable for GPX (gpx) processors.")
    public String getAbaNumber() {
        return this.abaNumber;
    }

    public void setAbaNumber(String abaNumber) {
        this.abaNumber = abaNumber;
    }

    public CardProcessingConfigCommonProcessors acquirer(CardProcessingConfigCommonAcquirer acquirer) {
        this.acquirer = acquirer;
        return this;
    }

    @ApiModelProperty(value="")
    public CardProcessingConfigCommonAcquirer getAcquirer() {
        return this.acquirer;
    }

    public void setAcquirer(CardProcessingConfigCommonAcquirer acquirer) {
        this.acquirer = acquirer;
    }

    public CardProcessingConfigCommonProcessors merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(required=true, value="Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>15</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>11</td><td>^[0-9a-zA-Z]+$</td></tr> </table> ")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public CardProcessingConfigCommonProcessors terminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    @ApiModelProperty(value="The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cnp, hybrid</td><td>Yes</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays HISO</td><td>cp</td><td>No</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> </table> ")
    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public CardProcessingConfigCommonProcessors paymentTypes(Map<String, CardProcessingConfigCommonPaymentTypes> paymentTypes) {
        this.paymentTypes = paymentTypes;
        return this;
    }

    public CardProcessingConfigCommonProcessors putPaymentTypesItem(String key, CardProcessingConfigCommonPaymentTypes paymentTypesItem) {
        if (this.paymentTypes == null) {
            this.paymentTypes = new HashMap<String, CardProcessingConfigCommonPaymentTypes>();
        }
        this.paymentTypes.put(key, paymentTypesItem);
        return this;
    }

    @ApiModelProperty(value="Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB ")
    public Map<String, CardProcessingConfigCommonPaymentTypes> getPaymentTypes() {
        return this.paymentTypes;
    }

    public void setPaymentTypes(Map<String, CardProcessingConfigCommonPaymentTypes> paymentTypes) {
        this.paymentTypes = paymentTypes;
    }

    public CardProcessingConfigCommonProcessors currencies(Map<String, CardProcessingConfigCommonCurrencies1> currencies) {
        this.currencies = currencies;
        return this;
    }

    public CardProcessingConfigCommonProcessors putCurrenciesItem(String key, CardProcessingConfigCommonCurrencies1 currenciesItem) {
        if (this.currencies == null) {
            this.currencies = new HashMap<String, CardProcessingConfigCommonCurrencies1>();
        }
        this.currencies.put(key, currenciesItem);
        return this;
    }

    @ApiModelProperty(value="Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)")
    public Map<String, CardProcessingConfigCommonCurrencies1> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(Map<String, CardProcessingConfigCommonCurrencies1> currencies) {
        this.currencies = currencies;
    }

    public CardProcessingConfigCommonProcessors sicCode(String sicCode) {
        this.sicCode = sicCode;
        return this;
    }

    @ApiModelProperty(value="The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.")
    public String getSicCode() {
        return this.sicCode;
    }

    public void setSicCode(String sicCode) {
        this.sicCode = sicCode;
    }

    public CardProcessingConfigCommonProcessors allowMultipleBills(Boolean allowMultipleBills) {
        this.allowMultipleBills = allowMultipleBills;
        return this;
    }

    @ApiModelProperty(value="Allows multiple captures for a single authorization transaction. Applicable for Paymentech Tampa (paymentechtampa), VPC, American Express Direct (amexdirect) and GPX (gpx) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, hybrid</td><td>Yes</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cnp</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean isAllowMultipleBills() {
        return this.allowMultipleBills;
    }

    public void setAllowMultipleBills(Boolean allowMultipleBills) {
        this.allowMultipleBills = allowMultipleBills;
    }

    public CardProcessingConfigCommonProcessors allowMerchantDescriptorOverride(Boolean allowMerchantDescriptorOverride) {
        this.allowMerchantDescriptorOverride = allowMerchantDescriptorOverride;
        return this;
    }

    @ApiModelProperty(value="Enables partner to enable/disable merchant descriptors values. Applicable for VPC, EFTPOS and CUP processors.")
    public Boolean isAllowMerchantDescriptorOverride() {
        return this.allowMerchantDescriptorOverride;
    }

    public void setAllowMerchantDescriptorOverride(Boolean allowMerchantDescriptorOverride) {
        this.allowMerchantDescriptorOverride = allowMerchantDescriptorOverride;
    }

    public CardProcessingConfigCommonProcessors enhancedData(String enhancedData) {
        this.enhancedData = enhancedData;
        return this;
    }

    @ApiModelProperty(value="To enable airline transactions. Applicable for TSYS (tsys), VPC, Elavon Americas (elavonamericas), FDI Global (fdiglobal), GPX (gpx), Barclays (barclays2) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td></tr> </table> ")
    public String getEnhancedData() {
        return this.enhancedData;
    }

    public void setEnhancedData(String enhancedData) {
        this.enhancedData = enhancedData;
    }

    public CardProcessingConfigCommonProcessors fireSafetyIndicator(Boolean fireSafetyIndicator) {
        this.fireSafetyIndicator = fireSafetyIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the merchant is compliant with Hotel and Motel Fire Safety Act of 1990. Applicable for GPX (gpx) and VPC processors.")
    public Boolean isFireSafetyIndicator() {
        return this.fireSafetyIndicator;
    }

    public void setFireSafetyIndicator(Boolean fireSafetyIndicator) {
        this.fireSafetyIndicator = fireSafetyIndicator;
    }

    public CardProcessingConfigCommonProcessors quasiCash(Boolean quasiCash) {
        this.quasiCash = quasiCash;
        return this;
    }

    @ApiModelProperty(value="To enable quasi-cash transactions. A quasi-cash transaction is a cash-like transaction for the sale of items that are directly convertible to cash, such as:- Casino gaming chips, Money orders, Wire transfers.  Applicable for GPX (gpx), TSYS (tsys), Barclays (barclays2) and VPC processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean isQuasiCash() {
        return this.quasiCash;
    }

    public void setQuasiCash(Boolean quasiCash) {
        this.quasiCash = quasiCash;
    }

    public CardProcessingConfigCommonProcessors acquirerMerchantId(String acquirerMerchantId) {
        this.acquirerMerchantId = acquirerMerchantId;
        return this;
    }

    @ApiModelProperty(value="Identifier assigned by the acquirer. Applicable for RUPAY, VPC and Six (six) processors.")
    public String getAcquirerMerchantId() {
        return this.acquirerMerchantId;
    }

    public void setAcquirerMerchantId(String acquirerMerchantId) {
        this.acquirerMerchantId = acquirerMerchantId;
    }

    public CardProcessingConfigCommonProcessors avsFormat(String avsFormat) {
        this.avsFormat = avsFormat;
        return this;
    }

    @ApiModelProperty(value="Enables Enhanced AVS/Automated Address Verification Plus (AAV+).  Valid values: \"basic\" - Standard address verification system.   When a processor supports AVS for a transaction's card type, the issuing bank uses AVS to confirm that the customer has provided the correct billing address.   When a customer provides incorrect information, the transaction might be fraudulent. \"basic + name\" - Enhanced address verification system.   Consists of the standard AVS functionality plus verification of some additional fields.   The additional fields that are verified for Enhanced AVS are:   - customer_firstname   - customer_lastname \"basic + name + shipto\" - Automated address verification plus.   Consists of the Enhanced AVS functionality plus verification of some additional fields.   AAV+ intended for merchants who deliver physical goods to a different address than the billing address.   AAV+ verifies the additional fields only when the standard and Enhanced AVS tests pass first.   For information about Enhanced AVS - The additional fields that are verified for AAV+ are:   - ship_to_firstname   - ship_to_lastname   - ship_to_address1   - ship_to_country   - ship_to_zip   - ship_to_phone   - customer_phone(American Express Direct only)  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>basic</td></tr> </table> ")
    public String getAvsFormat() {
        return this.avsFormat;
    }

    public void setAvsFormat(String avsFormat) {
        this.avsFormat = avsFormat;
    }

    public CardProcessingConfigCommonProcessors enableLongTransRefNo(Boolean enableLongTransRefNo) {
        this.enableLongTransRefNo = enableLongTransRefNo;
        return this;
    }

    @ApiModelProperty(value="Amex Direct specific merchant config value which determines what length (either 9 or Unique 12-char reference number) of reference number will be CYBS generated if the merchant does not pass in a trans_ref_no. Can be any combination of alpha, numeric and special characters, and/or binary data in hexadecimal.  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean isEnableLongTransRefNo() {
        return this.enableLongTransRefNo;
    }

    public void setEnableLongTransRefNo(Boolean enableLongTransRefNo) {
        this.enableLongTransRefNo = enableLongTransRefNo;
    }

    public CardProcessingConfigCommonProcessors enableLevel2(Boolean enableLevel2) {
        this.enableLevel2 = enableLevel2;
        return this;
    }

    @ApiModelProperty(value="Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean isEnableLevel2() {
        return this.enableLevel2;
    }

    public void setEnableLevel2(Boolean enableLevel2) {
        this.enableLevel2 = enableLevel2;
    }

    public CardProcessingConfigCommonProcessors enableMultipleTransactionAdviceAddendum(Boolean enableMultipleTransactionAdviceAddendum) {
        this.enableMultipleTransactionAdviceAddendum = enableMultipleTransactionAdviceAddendum;
        return this;
    }

    @ApiModelProperty(value="This flag related to multiple transaction advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean isEnableMultipleTransactionAdviceAddendum() {
        return this.enableMultipleTransactionAdviceAddendum;
    }

    public void setEnableMultipleTransactionAdviceAddendum(Boolean enableMultipleTransactionAdviceAddendum) {
        this.enableMultipleTransactionAdviceAddendum = enableMultipleTransactionAdviceAddendum;
    }

    public CardProcessingConfigCommonProcessors amexTransactionAdviceAddendum1(String amexTransactionAdviceAddendum1) {
        this.amexTransactionAdviceAddendum1 = amexTransactionAdviceAddendum1;
        return this;
    }

    @ApiModelProperty(value="Advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for TSYS (tsys), FDI Global (fdiglobal) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>40</td><td>^[0-9a-zA-Z&#92;-\\s.]+$</td></tr> </table> ")
    public String getAmexTransactionAdviceAddendum1() {
        return this.amexTransactionAdviceAddendum1;
    }

    public void setAmexTransactionAdviceAddendum1(String amexTransactionAdviceAddendum1) {
        this.amexTransactionAdviceAddendum1 = amexTransactionAdviceAddendum1;
    }

    public CardProcessingConfigCommonProcessors enableMultiLineItems(Boolean enableMultiLineItems) {
        this.enableMultiLineItems = enableMultiLineItems;
        return this;
    }

    @ApiModelProperty(value="This flag is related to offer/line item details to be included instead of sending one line item, and a grand total. Example, offer0, offer 1...offer n. Applicable for American Express Direct (amexdirect) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean isEnableMultiLineItems() {
        return this.enableMultiLineItems;
    }

    public void setEnableMultiLineItems(Boolean enableMultiLineItems) {
        this.enableMultiLineItems = enableMultiLineItems;
    }

    public CardProcessingConfigCommonProcessors enableTransactionReferenceNumber(Boolean enableTransactionReferenceNumber) {
        this.enableTransactionReferenceNumber = enableTransactionReferenceNumber;
        return this;
    }

    @ApiModelProperty(value="To enable merchant to send in transaction reference number (unique reconciliation ID). Applicable for VPC, Vero (vero), FDI Global (fdiglobal), Six (six), CB2A, CUP, VPC, Chase Paymentech Salem (chasepaymentechsalem), Fiserv (fiserv), Elavon Americas (elavonamericas) and EFTPOS processors.")
    public Boolean isEnableTransactionReferenceNumber() {
        return this.enableTransactionReferenceNumber;
    }

    public void setEnableTransactionReferenceNumber(Boolean enableTransactionReferenceNumber) {
        this.enableTransactionReferenceNumber = enableTransactionReferenceNumber;
    }

    public CardProcessingConfigCommonProcessors enableAutoAuthReversalAfterVoid(Boolean enableAutoAuthReversalAfterVoid) {
        this.enableAutoAuthReversalAfterVoid = enableAutoAuthReversalAfterVoid;
        return this;
    }

    @ApiModelProperty(value="Enables to meet the Visa mandate requirements to reverse unused authorizations, benefitting the customer by releasing the hold on unused credit card funds. Applicable for CB2A, Elavon Americas (elavonamericas), Six (six), VPC and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean isEnableAutoAuthReversalAfterVoid() {
        return this.enableAutoAuthReversalAfterVoid;
    }

    public void setEnableAutoAuthReversalAfterVoid(Boolean enableAutoAuthReversalAfterVoid) {
        this.enableAutoAuthReversalAfterVoid = enableAutoAuthReversalAfterVoid;
    }

    public CardProcessingConfigCommonProcessors enableExpresspayPanTranslation(Boolean enableExpresspayPanTranslation) {
        this.enableExpresspayPanTranslation = enableExpresspayPanTranslation;
        return this;
    }

    @ApiModelProperty(value="When this is enabled, authorization responses from American Express expresspay transactions include the Primary Account Number (PAN) and expiration date of the card. Applicable for American Express Direct (amexdirect) processor.")
    public Boolean isEnableExpresspayPanTranslation() {
        return this.enableExpresspayPanTranslation;
    }

    public void setEnableExpresspayPanTranslation(Boolean enableExpresspayPanTranslation) {
        this.enableExpresspayPanTranslation = enableExpresspayPanTranslation;
    }

    public CardProcessingConfigCommonProcessors enableCreditAuth(Boolean enableCreditAuth) {
        this.enableCreditAuth = enableCreditAuth;
        return this;
    }

    @ApiModelProperty(value="Authorizes a credit. Reduces refund chargebacks and prevents customers from seeing the online update for credits which are otherwise offline settlements.")
    public Boolean isEnableCreditAuth() {
        return this.enableCreditAuth;
    }

    public void setEnableCreditAuth(Boolean enableCreditAuth) {
        this.enableCreditAuth = enableCreditAuth;
    }

    public CardProcessingConfigCommonProcessors industryCode(IndustryCodeEnum industryCode) {
        this.industryCode = industryCode;
        return this;
    }

    @ApiModelProperty(value="Field used to identify the industry type of the merchant submitting the authorization request.  Valid values: `0` \u2013 unknown or unsure `A` \u2013 auto rental (EMV supported) `B` \u2013 bank/financial institution (EMV supported) `D` \u2013 direct marketing `F` \u2013 food/restaurant (EMV supported) `G` \u2013 grocery store/super market (EMV supported) `H` \u2013 hotel (EMV supported) `L` \u2013 limited amount terminal (EMV supported) `O` \u2013 oil company/automated fueling system (EMV supported) `P` \u2013 passenger transport (EMV supported) `R` \u2013 retail (EMV supported) Applicable for TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors. ")
    public IndustryCodeEnum getIndustryCode() {
        return this.industryCode;
    }

    public void setIndustryCode(IndustryCodeEnum industryCode) {
        this.industryCode = industryCode;
    }

    public CardProcessingConfigCommonProcessors sendAmexLevel2Data(Boolean sendAmexLevel2Data) {
        this.sendAmexLevel2Data = sendAmexLevel2Data;
        return this;
    }

    @ApiModelProperty(value="Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for TSYS (tsys) processor.")
    public Boolean isSendAmexLevel2Data() {
        return this.sendAmexLevel2Data;
    }

    public void setSendAmexLevel2Data(Boolean sendAmexLevel2Data) {
        this.sendAmexLevel2Data = sendAmexLevel2Data;
    }

    public CardProcessingConfigCommonProcessors softDescriptorType(String softDescriptorType) {
        this.softDescriptorType = softDescriptorType;
        return this;
    }

    @ApiModelProperty(value="A soft descriptor is a text, rendered on a cardholder's statement, describing a particular product or service, purchased by the cardholder. Descriptors are intended to help the cardholder identify the products or services purchased. Valid values: `1` - trans_ref_no `2` - merchant_descriptor `3` - trans_ref_no and merchant_descriptor Applicable for TSYS (tsys) processor. ")
    public String getSoftDescriptorType() {
        return this.softDescriptorType;
    }

    public void setSoftDescriptorType(String softDescriptorType) {
        this.softDescriptorType = softDescriptorType;
    }

    public CardProcessingConfigCommonProcessors vitalNumber(String vitalNumber) {
        this.vitalNumber = vitalNumber;
        return this;
    }

    @ApiModelProperty(value="V-number provided by TSYS info. The leading `V` must be replaced by a `7`. For example, replace `V1234567` with `71234567`. Applicable for TSYS (tsys) processor.")
    public String getVitalNumber() {
        return this.vitalNumber;
    }

    public void setVitalNumber(String vitalNumber) {
        this.vitalNumber = vitalNumber;
    }

    public CardProcessingConfigCommonProcessors bankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
        return this;
    }

    @ApiModelProperty(value="6 digit agent bank number provided by acquirer. Applicable for TSYS (tsys) processor.")
    public String getBankNumber() {
        return this.bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public CardProcessingConfigCommonProcessors chainNumber(String chainNumber) {
        this.chainNumber = chainNumber;
        return this;
    }

    @ApiModelProperty(value="6 digit chain number provided by acquirer. Applicable for TSYS (tsys) processor.")
    public String getChainNumber() {
        return this.chainNumber;
    }

    public void setChainNumber(String chainNumber) {
        this.chainNumber = chainNumber;
    }

    public CardProcessingConfigCommonProcessors merchantBinNumber(String merchantBinNumber) {
        this.merchantBinNumber = merchantBinNumber;
        return this;
    }

    @ApiModelProperty(value="6 digits acquirer bank identification number. Applicable for TSYS (tsys) processor.")
    public String getMerchantBinNumber() {
        return this.merchantBinNumber;
    }

    public void setMerchantBinNumber(String merchantBinNumber) {
        this.merchantBinNumber = merchantBinNumber;
    }

    public CardProcessingConfigCommonProcessors merchantLocationNumber(String merchantLocationNumber) {
        this.merchantLocationNumber = merchantLocationNumber;
        return this;
    }

    @ApiModelProperty(value="5 digit merchant location number. Unless otherwise specified by merchant's bank or processor, this field should default to 00001. Applicable for TSYS (tsys) processor.")
    public String getMerchantLocationNumber() {
        return this.merchantLocationNumber;
    }

    public void setMerchantLocationNumber(String merchantLocationNumber) {
        this.merchantLocationNumber = merchantLocationNumber;
    }

    public CardProcessingConfigCommonProcessors storeID(String storeID) {
        this.storeID = storeID;
        return this;
    }

    @ApiModelProperty(value="4 digits number used to identify a specific merchant store location within the member systems. Applicable for TSYS (tsys) processor.")
    public String getStoreID() {
        return this.storeID;
    }

    public void setStoreID(String storeID) {
        this.storeID = storeID;
    }

    public CardProcessingConfigCommonProcessors travelAgencyCode(String travelAgencyCode) {
        this.travelAgencyCode = travelAgencyCode;
        return this;
    }

    @ApiModelProperty(value="Contains travel agency code if airline ticket was issued by a travel agency. Applicable for TSYS (tsys) processor.")
    public String getTravelAgencyCode() {
        return this.travelAgencyCode;
    }

    public void setTravelAgencyCode(String travelAgencyCode) {
        this.travelAgencyCode = travelAgencyCode;
    }

    public CardProcessingConfigCommonProcessors travelAgencyName(String travelAgencyName) {
        this.travelAgencyName = travelAgencyName;
        return this;
    }

    @ApiModelProperty(value="Contains travel agency name if airline ticket was issued by travel agency. Applicable for TSYS (tsys) processor.")
    public String getTravelAgencyName() {
        return this.travelAgencyName;
    }

    public void setTravelAgencyName(String travelAgencyName) {
        this.travelAgencyName = travelAgencyName;
    }

    public CardProcessingConfigCommonProcessors settlementCurrency(String settlementCurrency) {
        this.settlementCurrency = settlementCurrency;
        return this;
    }

    @ApiModelProperty(value="This field is used to indicate Merchant's settlement currency. [ISO 4217 ALPHA-3 Standard Currency Codes] Applicable for TSYS (tsys) and Streamline (streamline2) processors.")
    public String getSettlementCurrency() {
        return this.settlementCurrency;
    }

    public void setSettlementCurrency(String settlementCurrency) {
        this.settlementCurrency = settlementCurrency;
    }

    public CardProcessingConfigCommonProcessors enableLeastCostRouting(Boolean enableLeastCostRouting) {
        this.enableLeastCostRouting = enableLeastCostRouting;
        return this;
    }

    @ApiModelProperty(value="Indicates whether Least Cost Routing is enabled. Applicable for EFTPOS and CUP processors.")
    public Boolean isEnableLeastCostRouting() {
        return this.enableLeastCostRouting;
    }

    public void setEnableLeastCostRouting(Boolean enableLeastCostRouting) {
        this.enableLeastCostRouting = enableLeastCostRouting;
    }

    public CardProcessingConfigCommonProcessors enableCVVResponseIndicator(Boolean enableCVVResponseIndicator) {
        this.enableCVVResponseIndicator = enableCVVResponseIndicator;
        return this;
    }

    @ApiModelProperty(value="This field denotes EFTPOS Merchant's choice of receiving CVV Processing Response in return. Applicable for EFTPOS processors.")
    public Boolean isEnableCVVResponseIndicator() {
        return this.enableCVVResponseIndicator;
    }

    public void setEnableCVVResponseIndicator(Boolean enableCVVResponseIndicator) {
        this.enableCVVResponseIndicator = enableCVVResponseIndicator;
    }

    public CardProcessingConfigCommonProcessors enableMultiCurrencyProcessing(String enableMultiCurrencyProcessing) {
        this.enableMultiCurrencyProcessing = enableMultiCurrencyProcessing;
        return this;
    }

    @ApiModelProperty(value="Applicable for Barclays (barclays2) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>Yes</td></tr> </table> ")
    public String getEnableMultiCurrencyProcessing() {
        return this.enableMultiCurrencyProcessing;
    }

    public void setEnableMultiCurrencyProcessing(String enableMultiCurrencyProcessing) {
        this.enableMultiCurrencyProcessing = enableMultiCurrencyProcessing;
    }

    public CardProcessingConfigCommonProcessors enablePosNetworkSwitching(Boolean enablePosNetworkSwitching) {
        this.enablePosNetworkSwitching = enablePosNetworkSwitching;
        return this;
    }

    @ApiModelProperty(value="'POS Network Switching' or 'Alternate Routing' means merchant can process PIN Debit transactions without a PIN. Set the value to 'Yes' if it is supported. Applicable for FDI Global (fdiglobal) processor.")
    public Boolean isEnablePosNetworkSwitching() {
        return this.enablePosNetworkSwitching;
    }

    public void setEnablePosNetworkSwitching(Boolean enablePosNetworkSwitching) {
        this.enablePosNetworkSwitching = enablePosNetworkSwitching;
    }

    public CardProcessingConfigCommonProcessors enableDynamicCurrencyConversion(Boolean enableDynamicCurrencyConversion) {
        this.enableDynamicCurrencyConversion = enableDynamicCurrencyConversion;
        return this;
    }

    @ApiModelProperty(value="Enable dynamic currency conversion for a merchant.")
    public Boolean isEnableDynamicCurrencyConversion() {
        return this.enableDynamicCurrencyConversion;
    }

    public void setEnableDynamicCurrencyConversion(Boolean enableDynamicCurrencyConversion) {
        this.enableDynamicCurrencyConversion = enableDynamicCurrencyConversion;
    }

    public CardProcessingConfigCommonProcessors merchantTier(String merchantTier) {
        this.merchantTier = merchantTier;
        return this;
    }

    @ApiModelProperty(value="Merchant Tier defines the type of merchant, the numeric Merchant Tier value is allocated by EFTPOS. Applicable for EFTPOS processors.")
    public String getMerchantTier() {
        return this.merchantTier;
    }

    public void setMerchantTier(String merchantTier) {
        this.merchantTier = merchantTier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardProcessingConfigCommonProcessors cardProcessingConfigCommonProcessors = (CardProcessingConfigCommonProcessors)o;
        return Objects.equals(this.batchGroup, cardProcessingConfigCommonProcessors.batchGroup) && Objects.equals(this.businessApplicationId, cardProcessingConfigCommonProcessors.businessApplicationId) && Objects.equals(this.merchantVerificationValue, cardProcessingConfigCommonProcessors.merchantVerificationValue) && Objects.equals(this.abaNumber, cardProcessingConfigCommonProcessors.abaNumber) && Objects.equals(this.acquirer, cardProcessingConfigCommonProcessors.acquirer) && Objects.equals(this.merchantId, cardProcessingConfigCommonProcessors.merchantId) && Objects.equals(this.terminalId, cardProcessingConfigCommonProcessors.terminalId) && Objects.equals(this.paymentTypes, cardProcessingConfigCommonProcessors.paymentTypes) && Objects.equals(this.currencies, cardProcessingConfigCommonProcessors.currencies) && Objects.equals(this.sicCode, cardProcessingConfigCommonProcessors.sicCode) && Objects.equals(this.allowMultipleBills, cardProcessingConfigCommonProcessors.allowMultipleBills) && Objects.equals(this.allowMerchantDescriptorOverride, cardProcessingConfigCommonProcessors.allowMerchantDescriptorOverride) && Objects.equals(this.enhancedData, cardProcessingConfigCommonProcessors.enhancedData) && Objects.equals(this.fireSafetyIndicator, cardProcessingConfigCommonProcessors.fireSafetyIndicator) && Objects.equals(this.quasiCash, cardProcessingConfigCommonProcessors.quasiCash) && Objects.equals(this.acquirerMerchantId, cardProcessingConfigCommonProcessors.acquirerMerchantId) && Objects.equals(this.avsFormat, cardProcessingConfigCommonProcessors.avsFormat) && Objects.equals(this.enableLongTransRefNo, cardProcessingConfigCommonProcessors.enableLongTransRefNo) && Objects.equals(this.enableLevel2, cardProcessingConfigCommonProcessors.enableLevel2) && Objects.equals(this.enableMultipleTransactionAdviceAddendum, cardProcessingConfigCommonProcessors.enableMultipleTransactionAdviceAddendum) && Objects.equals(this.amexTransactionAdviceAddendum1, cardProcessingConfigCommonProcessors.amexTransactionAdviceAddendum1) && Objects.equals(this.enableMultiLineItems, cardProcessingConfigCommonProcessors.enableMultiLineItems) && Objects.equals(this.enableTransactionReferenceNumber, cardProcessingConfigCommonProcessors.enableTransactionReferenceNumber) && Objects.equals(this.enableAutoAuthReversalAfterVoid, cardProcessingConfigCommonProcessors.enableAutoAuthReversalAfterVoid) && Objects.equals(this.enableExpresspayPanTranslation, cardProcessingConfigCommonProcessors.enableExpresspayPanTranslation) && Objects.equals(this.enableCreditAuth, cardProcessingConfigCommonProcessors.enableCreditAuth) && Objects.equals((Object)this.industryCode, (Object)cardProcessingConfigCommonProcessors.industryCode) && Objects.equals(this.sendAmexLevel2Data, cardProcessingConfigCommonProcessors.sendAmexLevel2Data) && Objects.equals(this.softDescriptorType, cardProcessingConfigCommonProcessors.softDescriptorType) && Objects.equals(this.vitalNumber, cardProcessingConfigCommonProcessors.vitalNumber) && Objects.equals(this.bankNumber, cardProcessingConfigCommonProcessors.bankNumber) && Objects.equals(this.chainNumber, cardProcessingConfigCommonProcessors.chainNumber) && Objects.equals(this.merchantBinNumber, cardProcessingConfigCommonProcessors.merchantBinNumber) && Objects.equals(this.merchantLocationNumber, cardProcessingConfigCommonProcessors.merchantLocationNumber) && Objects.equals(this.storeID, cardProcessingConfigCommonProcessors.storeID) && Objects.equals(this.travelAgencyCode, cardProcessingConfigCommonProcessors.travelAgencyCode) && Objects.equals(this.travelAgencyName, cardProcessingConfigCommonProcessors.travelAgencyName) && Objects.equals(this.settlementCurrency, cardProcessingConfigCommonProcessors.settlementCurrency) && Objects.equals(this.enableLeastCostRouting, cardProcessingConfigCommonProcessors.enableLeastCostRouting) && Objects.equals(this.enableCVVResponseIndicator, cardProcessingConfigCommonProcessors.enableCVVResponseIndicator) && Objects.equals(this.enableMultiCurrencyProcessing, cardProcessingConfigCommonProcessors.enableMultiCurrencyProcessing) && Objects.equals(this.enablePosNetworkSwitching, cardProcessingConfigCommonProcessors.enablePosNetworkSwitching) && Objects.equals(this.enableDynamicCurrencyConversion, cardProcessingConfigCommonProcessors.enableDynamicCurrencyConversion) && Objects.equals(this.merchantTier, cardProcessingConfigCommonProcessors.merchantTier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.batchGroup, this.businessApplicationId, this.merchantVerificationValue, this.abaNumber, this.acquirer, this.merchantId, this.terminalId, this.paymentTypes, this.currencies, this.sicCode, this.allowMultipleBills, this.allowMerchantDescriptorOverride, this.enhancedData, this.fireSafetyIndicator, this.quasiCash, this.acquirerMerchantId, this.avsFormat, this.enableLongTransRefNo, this.enableLevel2, this.enableMultipleTransactionAdviceAddendum, this.amexTransactionAdviceAddendum1, this.enableMultiLineItems, this.enableTransactionReferenceNumber, this.enableAutoAuthReversalAfterVoid, this.enableExpresspayPanTranslation, this.enableCreditAuth, this.industryCode, this.sendAmexLevel2Data, this.softDescriptorType, this.vitalNumber, this.bankNumber, this.chainNumber, this.merchantBinNumber, this.merchantLocationNumber, this.storeID, this.travelAgencyCode, this.travelAgencyName, this.settlementCurrency, this.enableLeastCostRouting, this.enableCVVResponseIndicator, this.enableMultiCurrencyProcessing, this.enablePosNetworkSwitching, this.enableDynamicCurrencyConversion, this.merchantTier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardProcessingConfigCommonProcessors {\n");
        sb.append("    batchGroup: ").append(this.toIndentedString(this.batchGroup)).append("\n");
        sb.append("    businessApplicationId: ").append(this.toIndentedString(this.businessApplicationId)).append("\n");
        sb.append("    merchantVerificationValue: ").append(this.toIndentedString(this.merchantVerificationValue)).append("\n");
        sb.append("    abaNumber: ").append(this.toIndentedString(this.abaNumber)).append("\n");
        sb.append("    acquirer: ").append(this.toIndentedString(this.acquirer)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    terminalId: ").append(this.toIndentedString(this.terminalId)).append("\n");
        sb.append("    paymentTypes: ").append(this.toIndentedString(this.paymentTypes)).append("\n");
        sb.append("    currencies: ").append(this.toIndentedString(this.currencies)).append("\n");
        sb.append("    sicCode: ").append(this.toIndentedString(this.sicCode)).append("\n");
        sb.append("    allowMultipleBills: ").append(this.toIndentedString(this.allowMultipleBills)).append("\n");
        sb.append("    allowMerchantDescriptorOverride: ").append(this.toIndentedString(this.allowMerchantDescriptorOverride)).append("\n");
        sb.append("    enhancedData: ").append(this.toIndentedString(this.enhancedData)).append("\n");
        sb.append("    fireSafetyIndicator: ").append(this.toIndentedString(this.fireSafetyIndicator)).append("\n");
        sb.append("    quasiCash: ").append(this.toIndentedString(this.quasiCash)).append("\n");
        sb.append("    acquirerMerchantId: ").append(this.toIndentedString(this.acquirerMerchantId)).append("\n");
        sb.append("    avsFormat: ").append(this.toIndentedString(this.avsFormat)).append("\n");
        sb.append("    enableLongTransRefNo: ").append(this.toIndentedString(this.enableLongTransRefNo)).append("\n");
        sb.append("    enableLevel2: ").append(this.toIndentedString(this.enableLevel2)).append("\n");
        sb.append("    enableMultipleTransactionAdviceAddendum: ").append(this.toIndentedString(this.enableMultipleTransactionAdviceAddendum)).append("\n");
        sb.append("    amexTransactionAdviceAddendum1: ").append(this.toIndentedString(this.amexTransactionAdviceAddendum1)).append("\n");
        sb.append("    enableMultiLineItems: ").append(this.toIndentedString(this.enableMultiLineItems)).append("\n");
        sb.append("    enableTransactionReferenceNumber: ").append(this.toIndentedString(this.enableTransactionReferenceNumber)).append("\n");
        sb.append("    enableAutoAuthReversalAfterVoid: ").append(this.toIndentedString(this.enableAutoAuthReversalAfterVoid)).append("\n");
        sb.append("    enableExpresspayPanTranslation: ").append(this.toIndentedString(this.enableExpresspayPanTranslation)).append("\n");
        sb.append("    enableCreditAuth: ").append(this.toIndentedString(this.enableCreditAuth)).append("\n");
        sb.append("    industryCode: ").append(this.toIndentedString((Object)this.industryCode)).append("\n");
        sb.append("    sendAmexLevel2Data: ").append(this.toIndentedString(this.sendAmexLevel2Data)).append("\n");
        sb.append("    softDescriptorType: ").append(this.toIndentedString(this.softDescriptorType)).append("\n");
        sb.append("    vitalNumber: ").append(this.toIndentedString(this.vitalNumber)).append("\n");
        sb.append("    bankNumber: ").append(this.toIndentedString(this.bankNumber)).append("\n");
        sb.append("    chainNumber: ").append(this.toIndentedString(this.chainNumber)).append("\n");
        sb.append("    merchantBinNumber: ").append(this.toIndentedString(this.merchantBinNumber)).append("\n");
        sb.append("    merchantLocationNumber: ").append(this.toIndentedString(this.merchantLocationNumber)).append("\n");
        sb.append("    storeID: ").append(this.toIndentedString(this.storeID)).append("\n");
        sb.append("    travelAgencyCode: ").append(this.toIndentedString(this.travelAgencyCode)).append("\n");
        sb.append("    travelAgencyName: ").append(this.toIndentedString(this.travelAgencyName)).append("\n");
        sb.append("    settlementCurrency: ").append(this.toIndentedString(this.settlementCurrency)).append("\n");
        sb.append("    enableLeastCostRouting: ").append(this.toIndentedString(this.enableLeastCostRouting)).append("\n");
        sb.append("    enableCVVResponseIndicator: ").append(this.toIndentedString(this.enableCVVResponseIndicator)).append("\n");
        sb.append("    enableMultiCurrencyProcessing: ").append(this.toIndentedString(this.enableMultiCurrencyProcessing)).append("\n");
        sb.append("    enablePosNetworkSwitching: ").append(this.toIndentedString(this.enablePosNetworkSwitching)).append("\n");
        sb.append("    enableDynamicCurrencyConversion: ").append(this.toIndentedString(this.enableDynamicCurrencyConversion)).append("\n");
        sb.append("    merchantTier: ").append(this.toIndentedString(this.merchantTier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IndustryCodeEnum {
        _0("0"),
        A("A"),
        B("B"),
        D("D"),
        F("F"),
        G("G"),
        H("H"),
        L("L"),
        O("O"),
        P("P"),
        R("R");

        private String value;

        private IndustryCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IndustryCodeEnum fromValue(String text) {
            for (IndustryCodeEnum b : IndustryCodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<IndustryCodeEnum> {
            public void write(JsonWriter jsonWriter, IndustryCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IndustryCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IndustryCodeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

