/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.UpdatePasswordKeysRequest;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class KeyManagementPasswordApi {
    private static Logger logger = LogManager.getLogger(KeyManagementPasswordApi.class);
    private ApiClient apiClient;

    public KeyManagementPasswordApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagementPasswordApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call updatePasswordCall(String keyId, UpdatePasswordKeysRequest updatePasswordKeysRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(updatePasswordKeysRequest, UpdatePasswordKeysRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/kms/v2/keys-password/{keyId}".replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatePasswordValidateBeforeCall(String keyId, UpdatePasswordKeysRequest updatePasswordKeysRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyId == null) {
            logger.error("Missing the required parameter 'keyId' when calling updatePassword(Async)");
            throw new ApiException("Missing the required parameter 'keyId' when calling updatePassword(Async)");
        }
        if (updatePasswordKeysRequest == null) {
            logger.error("Missing the required parameter 'updatePasswordKeysRequest' when calling updatePassword(Async)");
            throw new ApiException("Missing the required parameter 'updatePasswordKeysRequest' when calling updatePassword(Async)");
        }
        Call call = this.updatePasswordCall(keyId, updatePasswordKeysRequest, progressListener, progressRequestListener);
        return call;
    }

    public Object updatePassword(String keyId, UpdatePasswordKeysRequest updatePasswordKeysRequest) throws ApiException {
        logger.info("CALL TO METHOD 'updatePassword' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Object> resp = this.updatePasswordWithHttpInfo(keyId, updatePasswordKeysRequest);
        logger.info("CALL TO METHOD 'updatePassword' ENDED");
        return resp.getData();
    }

    public ApiResponse<Object> updatePasswordWithHttpInfo(String keyId, UpdatePasswordKeysRequest updatePasswordKeysRequest) throws ApiException {
        Call call = this.updatePasswordValidateBeforeCall(keyId, updatePasswordKeysRequest, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatePasswordAsync(String keyId, UpdatePasswordKeysRequest updatePasswordKeysRequest, final ApiCallback<Object> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatePasswordValidateBeforeCall(keyId, updatePasswordKeysRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

