/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.Body;
import Model.TssV2GetEmvTags200Response;
import Model.TssV2PostEmvTags200Response;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class EmvTagDetailsApi {
    private static Logger logger = LogManager.getLogger(EmvTagDetailsApi.class);
    private ApiClient apiClient;

    public EmvTagDetailsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmvTagDetailsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getEmvTagsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/tss/v2/transactions/emvTagDetails";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEmvTagsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getEmvTagsCall(progressListener, progressRequestListener);
        return call;
    }

    public TssV2GetEmvTags200Response getEmvTags() throws ApiException {
        logger.info("CALL TO METHOD 'getEmvTags' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TssV2GetEmvTags200Response> resp = this.getEmvTagsWithHttpInfo();
        logger.info("CALL TO METHOD 'getEmvTags' ENDED");
        return resp.getData();
    }

    public ApiResponse<TssV2GetEmvTags200Response> getEmvTagsWithHttpInfo() throws ApiException {
        Call call = this.getEmvTagsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TssV2GetEmvTags200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEmvTagsAsync(final ApiCallback<TssV2GetEmvTags200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEmvTagsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TssV2GetEmvTags200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call parseEmvTagsCall(Body body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(body, Body.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/tss/v2/transactions/emvTagDetails";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call parseEmvTagsValidateBeforeCall(Body body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            logger.error("Missing the required parameter 'body' when calling parseEmvTags(Async)");
            throw new ApiException("Missing the required parameter 'body' when calling parseEmvTags(Async)");
        }
        Call call = this.parseEmvTagsCall(body, progressListener, progressRequestListener);
        return call;
    }

    public TssV2PostEmvTags200Response parseEmvTags(Body body) throws ApiException {
        logger.info("CALL TO METHOD 'parseEmvTags' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TssV2PostEmvTags200Response> resp = this.parseEmvTagsWithHttpInfo(body);
        logger.info("CALL TO METHOD 'parseEmvTags' ENDED");
        return resp.getData();
    }

    public ApiResponse<TssV2PostEmvTags200Response> parseEmvTagsWithHttpInfo(Body body) throws ApiException {
        Call call = this.parseEmvTagsValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<TssV2PostEmvTags200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call parseEmvTagsAsync(Body body, final ApiCallback<TssV2PostEmvTags200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.parseEmvTagsValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TssV2PostEmvTags200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

