/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.LocalDate;
import utilities.tracking.SdkTracker;

public class ReportDownloadsApi {
    private static Logger logger = LogManager.getLogger(ReportDownloadsApi.class);
    private ApiClient apiClient;

    public ReportDownloadsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReportDownloadsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call downloadReportCall(LocalDate reportDate, String reportName, String organizationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/reporting/v3/report-downloads";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        if (reportDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reportDate", reportDate));
        }
        if (reportName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reportName", reportName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xml", "text/csv"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadReportValidateBeforeCall(LocalDate reportDate, String reportName, String organizationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (reportDate == null) {
            logger.error("Missing the required parameter 'reportDate' when calling downloadReport(Async)");
            throw new ApiException("Missing the required parameter 'reportDate' when calling downloadReport(Async)");
        }
        if (reportName == null) {
            logger.error("Missing the required parameter 'reportName' when calling downloadReport(Async)");
            throw new ApiException("Missing the required parameter 'reportName' when calling downloadReport(Async)");
        }
        Call call = this.downloadReportCall(reportDate, reportName, organizationId, progressListener, progressRequestListener);
        return call;
    }

    public void downloadReport(LocalDate reportDate, String reportName, String organizationId) throws ApiException {
        logger.info("CALL TO METHOD 'downloadReport' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.downloadReportWithHttpInfo(reportDate, reportName, organizationId);
    }

    public ApiResponse<InputStream> downloadReportWithHttpInfo(LocalDate reportDate, String reportName, String organizationId) throws ApiException {
        Call call = this.downloadReportValidateBeforeCall(reportDate, reportName, organizationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call downloadReportAsync(LocalDate reportDate, String reportName, String organizationId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadReportValidateBeforeCall(reportDate, reportName, organizationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

