/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import Model.PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr;
import Model.PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation
 */

public class PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation {
  @SerializedName("accessToken")
  private String accessToken = null;

  @SerializedName("acsRenderingType")
  private String acsRenderingType = null;

  @SerializedName("acsTransactionId")
  private String acsTransactionId = null;

  @SerializedName("acsUrl")
  private String acsUrl = null;

  @SerializedName("authenticationPath")
  private String authenticationPath = null;

  @SerializedName("authorizationPayload")
  private String authorizationPayload = null;

  @SerializedName("authenticationTransactionId")
  private String authenticationTransactionId = null;

  @SerializedName("cardholderMessage")
  private String cardholderMessage = null;

  @SerializedName("cavv")
  private String cavv = null;

  @SerializedName("cavvAlgorithm")
  private String cavvAlgorithm = null;

  @SerializedName("challengeCancelCode")
  private String challengeCancelCode = null;

  @SerializedName("challengeRequired")
  private String challengeRequired = null;

  @SerializedName("decoupledAuthenticationIndicator")
  private String decoupledAuthenticationIndicator = null;

  @SerializedName("directoryServerErrorCode")
  private String directoryServerErrorCode = null;

  @SerializedName("directoryServerErrorDescription")
  private String directoryServerErrorDescription = null;

  @SerializedName("ecommerceIndicator")
  private String ecommerceIndicator = null;

  @SerializedName("eci")
  private String eci = null;

  @SerializedName("eciRaw")
  private String eciRaw = null;

  @SerializedName("effectiveAuthenticationType")
  private String effectiveAuthenticationType = null;

  @SerializedName("ivr")
  private PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr ivr = null;

  @SerializedName("strongAuthentication")
  private PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication strongAuthentication = null;

  @SerializedName("networkScore")
  private String networkScore = null;

  @SerializedName("pareq")
  private String pareq = null;

  @SerializedName("paresStatus")
  private String paresStatus = null;

  @SerializedName("proofXml")
  private String proofXml = null;

  @SerializedName("proxyPan")
  private String proxyPan = null;

  @SerializedName("sdkTransactionId")
  private String sdkTransactionId = null;

  @SerializedName("signedParesStatusReason")
  private String signedParesStatusReason = null;

  @SerializedName("specificationVersion")
  private String specificationVersion = null;

  @SerializedName("stepUpUrl")
  private String stepUpUrl = null;

  @SerializedName("threeDSServerTransactionId")
  private String threeDSServerTransactionId = null;

  @SerializedName("ucafAuthenticationData")
  private String ucafAuthenticationData = null;

  @SerializedName("ucafCollectionIndicator")
  private String ucafCollectionIndicator = null;

  @SerializedName("veresEnrolled")
  private String veresEnrolled = null;

  @SerializedName("whiteListStatusSource")
  private String whiteListStatusSource = null;

  @SerializedName("xid")
  private String xid = null;

  @SerializedName("directoryServerTransactionId")
  private String directoryServerTransactionId = null;

  @SerializedName("authenticationResult")
  private String authenticationResult = null;

  @SerializedName("authenticationStatusMsg")
  private String authenticationStatusMsg = null;

  @SerializedName("indicator")
  private String indicator = null;

  @SerializedName("interactionCounter")
  private String interactionCounter = null;

  @SerializedName("whiteListStatus")
  private String whiteListStatus = null;

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation accessToken(String accessToken) {
    this.accessToken = accessToken;
    return this;
  }

   /**
   * JSON Web Token (JWT) used to authenticate the consumer with the authentication provider, such as, CardinalCommerce or Rupay. Note - Max Length of this field is 2048 characters. 
   * @return accessToken
  **/
  @ApiModelProperty(value = "JSON Web Token (JWT) used to authenticate the consumer with the authentication provider, such as, CardinalCommerce or Rupay. Note - Max Length of this field is 2048 characters. ")
  public String getAccessToken() {
    return accessToken;
  }

  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation acsRenderingType(String acsRenderingType) {
    this.acsRenderingType = acsRenderingType;
    return this;
  }

   /**
   * Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 
   * @return acsRenderingType
  **/
  @ApiModelProperty(value = "Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. ")
  public String getAcsRenderingType() {
    return acsRenderingType;
  }

  public void setAcsRenderingType(String acsRenderingType) {
    this.acsRenderingType = acsRenderingType;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation acsTransactionId(String acsTransactionId) {
    this.acsTransactionId = acsTransactionId;
    return this;
  }

   /**
   * Unique transaction identifier assigned by the ACS to identify a single transaction. 
   * @return acsTransactionId
  **/
  @ApiModelProperty(value = "Unique transaction identifier assigned by the ACS to identify a single transaction. ")
  public String getAcsTransactionId() {
    return acsTransactionId;
  }

  public void setAcsTransactionId(String acsTransactionId) {
    this.acsTransactionId = acsTransactionId;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation acsUrl(String acsUrl) {
    this.acsUrl = acsUrl;
    return this;
  }

   /**
   * URL for the card-issuing bank’s authentication form that you receive when the card is enrolled. The value can be very large. 
   * @return acsUrl
  **/
  @ApiModelProperty(value = "URL for the card-issuing bank’s authentication form that you receive when the card is enrolled. The value can be very large. ")
  public String getAcsUrl() {
    return acsUrl;
  }

  public void setAcsUrl(String acsUrl) {
    this.acsUrl = acsUrl;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation authenticationPath(String authenticationPath) {
    this.authenticationPath = authenticationPath;
    return this;
  }

   /**
   * Indicates what displays to the customer during the authentication process. This field can contain one of these values: - &#x60;ADS&#x60;: (Card not enrolled) customer prompted to activate the card during the checkout process. - &#x60;ATTEMPTS&#x60;: (Attempts processing) Processing briefly displays before the checkout process is completed. - &#x60;ENROLLED&#x60;: (Card enrolled) the card issuer’s authentication window displays. - &#x60;UNKNOWN&#x60;: Card enrollment status cannot be determined. - &#x60;NOREDIRECT&#x60;: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - &#x60;RIBA&#x60;: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - &#x60;RIBA_PASS&#x60;: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see &#x60;pa_enroll_authentication_path&#x60; field description and \&quot;Rules-Based Payer Authentication\&quot; in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 
   * @return authenticationPath
  **/
  @ApiModelProperty(value = "Indicates what displays to the customer during the authentication process. This field can contain one of these values: - `ADS`: (Card not enrolled) customer prompted to activate the card during the checkout process. - `ATTEMPTS`: (Attempts processing) Processing briefly displays before the checkout process is completed. - `ENROLLED`: (Card enrolled) the card issuer’s authentication window displays. - `UNKNOWN`: Card enrollment status cannot be determined. - `NOREDIRECT`: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - `RIBA`: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - `RIBA_PASS`: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see `pa_enroll_authentication_path` field description and \"Rules-Based Payer Authentication\" in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) ")
  public String getAuthenticationPath() {
    return authenticationPath;
  }

  public void setAuthenticationPath(String authenticationPath) {
    this.authenticationPath = authenticationPath;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation authorizationPayload(String authorizationPayload) {
    this.authorizationPayload = authorizationPayload;
    return this;
  }

   /**
   * The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow 
   * @return authorizationPayload
  **/
  @ApiModelProperty(value = "The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow ")
  public String getAuthorizationPayload() {
    return authorizationPayload;
  }

  public void setAuthorizationPayload(String authorizationPayload) {
    this.authorizationPayload = authorizationPayload;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation authenticationTransactionId(String authenticationTransactionId) {
    this.authenticationTransactionId = authenticationTransactionId;
    return this;
  }

   /**
   * Payer authentication transaction identifier is used to link the check enrollment and validate authentication messages. For Rupay, this field should be passed as request only for Resend OTP use case. 
   * @return authenticationTransactionId
  **/
  @ApiModelProperty(value = "Payer authentication transaction identifier is used to link the check enrollment and validate authentication messages. For Rupay, this field should be passed as request only for Resend OTP use case. ")
  public String getAuthenticationTransactionId() {
    return authenticationTransactionId;
  }

  public void setAuthenticationTransactionId(String authenticationTransactionId) {
    this.authenticationTransactionId = authenticationTransactionId;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation cardholderMessage(String cardholderMessage) {
    this.cardholderMessage = cardholderMessage;
    return this;
  }

   /**
   * Text provided by the ACS/Issuer to Cardholder during a Frictionless or Decoupled transaction.The Issuer can provide information to Cardholder. For example, “Additional authentication is needed for this transaction, please contact (Issuer Name) at xxx-xxx-xxxx.”. The Issuing Bank can optionally support this value. 
   * @return cardholderMessage
  **/
  @ApiModelProperty(value = "Text provided by the ACS/Issuer to Cardholder during a Frictionless or Decoupled transaction.The Issuer can provide information to Cardholder. For example, “Additional authentication is needed for this transaction, please contact (Issuer Name) at xxx-xxx-xxxx.”. The Issuing Bank can optionally support this value. ")
  public String getCardholderMessage() {
    return cardholderMessage;
  }

  public void setCardholderMessage(String cardholderMessage) {
    this.cardholderMessage = cardholderMessage;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation cavv(String cavv) {
    this.cavv = cavv;
    return this;
  }

   /**
   * Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 
   * @return cavv
  **/
  @ApiModelProperty(value = "Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. ")
  public String getCavv() {
    return cavv;
  }

  public void setCavv(String cavv) {
    this.cavv = cavv;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation cavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
    return this;
  }

   /**
   * Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the &#x60;cavv_algorithm&#x60; request field of the authorization service. This field contains one of these values: - &#x60;2&#x60;: Visa, American Express, JCB, Diners Club, and Discover - &#x60;3&#x60;: Mastercard 
   * @return cavvAlgorithm
  **/
  @ApiModelProperty(value = "Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard ")
  public String getCavvAlgorithm() {
    return cavvAlgorithm;
  }

  public void setCavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation challengeCancelCode(String challengeCancelCode) {
    this.challengeCancelCode = challengeCancelCode;
    return this;
  }

   /**
   * An indicator as to why the transaction was canceled. Possible Values:  - &#x60;01&#x60;: Cardholder selected Cancel. - &#x60;02&#x60;: Reserved for future EMVCo use (values invalid until defined by EMVCo). - &#x60;03&#x60;: Transaction Timed Out—Decoupled Authentication - &#x60;04&#x60;: Transaction timed out at ACS—other timeouts - &#x60;05&#x60;: Transaction Timed out at ACS - First CReq not received by ACS - &#x60;06&#x60;: Transaction Error - &#x60;07&#x60;: Unknown - &#x60;08&#x60;: Transaction Timed Out at SDK 
   * @return challengeCancelCode
  **/
  @ApiModelProperty(value = "An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK ")
  public String getChallengeCancelCode() {
    return challengeCancelCode;
  }

  public void setChallengeCancelCode(String challengeCancelCode) {
    this.challengeCancelCode = challengeCancelCode;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation challengeRequired(String challengeRequired) {
    this.challengeRequired = challengeRequired;
    return this;
  }

   /**
   * Indicates whether a challenge is required in order to complete authentication. **Note** Regional mandates might determine that a challenge is required.  Possible values: - &#x60;Y&#x60;: Challenge required - &#x60;N&#x60;: Challenge not required **Note**  Used by the Hybrid integration. 
   * @return challengeRequired
  **/
  @ApiModelProperty(value = "Indicates whether a challenge is required in order to complete authentication. **Note** Regional mandates might determine that a challenge is required.  Possible values: - `Y`: Challenge required - `N`: Challenge not required **Note**  Used by the Hybrid integration. ")
  public String getChallengeRequired() {
    return challengeRequired;
  }

  public void setChallengeRequired(String challengeRequired) {
    this.challengeRequired = challengeRequired;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation decoupledAuthenticationIndicator(String decoupledAuthenticationIndicator) {
    this.decoupledAuthenticationIndicator = decoupledAuthenticationIndicator;
    return this;
  }

   /**
   * Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 
   * @return decoupledAuthenticationIndicator
  **/
  @ApiModelProperty(value = "Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N ")
  public String getDecoupledAuthenticationIndicator() {
    return decoupledAuthenticationIndicator;
  }

  public void setDecoupledAuthenticationIndicator(String decoupledAuthenticationIndicator) {
    this.decoupledAuthenticationIndicator = decoupledAuthenticationIndicator;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation directoryServerErrorCode(String directoryServerErrorCode) {
    this.directoryServerErrorCode = directoryServerErrorCode;
    return this;
  }

   /**
   * The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. 
   * @return directoryServerErrorCode
  **/
  @ApiModelProperty(value = "The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. ")
  public String getDirectoryServerErrorCode() {
    return directoryServerErrorCode;
  }

  public void setDirectoryServerErrorCode(String directoryServerErrorCode) {
    this.directoryServerErrorCode = directoryServerErrorCode;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation directoryServerErrorDescription(String directoryServerErrorDescription) {
    this.directoryServerErrorDescription = directoryServerErrorDescription;
    return this;
  }

   /**
   * Directory server text and additional detail about the error for this transaction. 
   * @return directoryServerErrorDescription
  **/
  @ApiModelProperty(value = "Directory server text and additional detail about the error for this transaction. ")
  public String getDirectoryServerErrorDescription() {
    return directoryServerErrorDescription;
  }

  public void setDirectoryServerErrorDescription(String directoryServerErrorDescription) {
    this.directoryServerErrorDescription = directoryServerErrorDescription;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation ecommerceIndicator(String ecommerceIndicator) {
    this.ecommerceIndicator = ecommerceIndicator;
    return this;
  }

   /**
   * Commerce indicator for cards not enrolled. This field contains one of these values: - &#x60;internet&#x60;: Card not enrolled, or card type not supported by payer authentication. No liability shift. - &#x60;js_attempted&#x60;: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - &#x60;js_failure&#x60;: J/Secure directory service is not available. No liability shift. - &#x60;spa&#x60;: Mastercard card not enrolled in the SecureCode program. No liability shift. - &#x60;vbv_attempted&#x60;: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - &#x60;vbv_failure&#x60;: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa’s directory service is not available. No liability shift. 
   * @return ecommerceIndicator
  **/
  @ApiModelProperty(value = "Commerce indicator for cards not enrolled. This field contains one of these values: - `internet`: Card not enrolled, or card type not supported by payer authentication. No liability shift. - `js_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `js_failure`: J/Secure directory service is not available. No liability shift. - `spa`: Mastercard card not enrolled in the SecureCode program. No liability shift. - `vbv_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `vbv_failure`: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa’s directory service is not available. No liability shift. ")
  public String getEcommerceIndicator() {
    return ecommerceIndicator;
  }

  public void setEcommerceIndicator(String ecommerceIndicator) {
    this.ecommerceIndicator = ecommerceIndicator;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation eci(String eci) {
    this.eci = eci;
    return this;
  }

   /**
   * Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \&quot;Interpreting the Reply,\&quot; page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - &#x60;06&#x60;: The card can be enrolled. Liability shift. - &#x60;07&#x60;: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - &#x60;05&#x60;: Successful authentication - &#x60;06&#x60;: Authentication attempted - &#x60;07&#x60;: Failed authentication (No response from the merchant because of a problem.) 
   * @return eci
  **/
  @ApiModelProperty(value = "Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) ")
  public String getEci() {
    return eci;
  }

  public void setEci(String eci) {
    this.eci = eci;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation eciRaw(String eciRaw) {
    this.eciRaw = eciRaw;
    return this;
  }

   /**
   * ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of &#x60;eci&#x60; or &#x60;ucafCollectionIndicator&#x60;.  This field can contain one of these values: - &#x60;01&#x60;: Authentication attempted (Mastercard) - &#x60;02&#x60;: Successful authentication (Mastercard) - &#x60;05&#x60;: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - &#x60;06&#x60;: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 
   * @return eciRaw
  **/
  @ApiModelProperty(value = "ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) ")
  public String getEciRaw() {
    return eciRaw;
  }

  public void setEciRaw(String eciRaw) {
    this.eciRaw = eciRaw;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation effectiveAuthenticationType(String effectiveAuthenticationType) {
    this.effectiveAuthenticationType = effectiveAuthenticationType;
    return this;
  }

   /**
   * This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 
   * @return effectiveAuthenticationType
  **/
  @ApiModelProperty(value = "This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). ")
  public String getEffectiveAuthenticationType() {
    return effectiveAuthenticationType;
  }

  public void setEffectiveAuthenticationType(String effectiveAuthenticationType) {
    this.effectiveAuthenticationType = effectiveAuthenticationType;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation ivr(PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr ivr) {
    this.ivr = ivr;
    return this;
  }

   /**
   * Get ivr
   * @return ivr
  **/
  @ApiModelProperty(value = "")
  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr getIvr() {
    return ivr;
  }

  public void setIvr(PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr ivr) {
    this.ivr = ivr;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation strongAuthentication(PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication strongAuthentication) {
    this.strongAuthentication = strongAuthentication;
    return this;
  }

   /**
   * Get strongAuthentication
   * @return strongAuthentication
  **/
  @ApiModelProperty(value = "")
  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication getStrongAuthentication() {
    return strongAuthentication;
  }

  public void setStrongAuthentication(PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication strongAuthentication) {
    this.strongAuthentication = strongAuthentication;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation networkScore(String networkScore) {
    this.networkScore = networkScore;
    return this;
  }

   /**
   * The global score calculated by the CB scoring platform and returned to merchants. 
   * @return networkScore
  **/
  @ApiModelProperty(value = "The global score calculated by the CB scoring platform and returned to merchants. ")
  public String getNetworkScore() {
    return networkScore;
  }

  public void setNetworkScore(String networkScore) {
    this.networkScore = networkScore;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation pareq(String pareq) {
    this.pareq = pareq;
    return this;
  }

   /**
   * Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. 
   * @return pareq
  **/
  @ApiModelProperty(value = "Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. ")
  public String getPareq() {
    return pareq;
  }

  public void setPareq(String pareq) {
    this.pareq = pareq;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation paresStatus(String paresStatus) {
    this.paresStatus = paresStatus;
    return this;
  }

   /**
   * Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - &#x60;A&#x60;: Proof of authentication attempt was generated. - &#x60;N&#x60;: Customer failed or canceled authentication. Transaction denied. - &#x60;U&#x60;: Authentication not completed regardless of the reason. - &#x60;Y&#x60;: Customer was successfully authenticated. 
   * @return paresStatus
  **/
  @ApiModelProperty(value = "Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `N`: Customer failed or canceled authentication. Transaction denied. - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. ")
  public String getParesStatus() {
    return paresStatus;
  }

  public void setParesStatus(String paresStatus) {
    this.paresStatus = paresStatus;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation proofXml(String proofXml) {
    this.proofXml = proofXml;
    return this;
  }

   /**
   * Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the &#x60;pa_enroll_proofxml&#x60; field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. 
   * @return proofXml
  **/
  @ApiModelProperty(value = "Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the `pa_enroll_proofxml` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. ")
  public String getProofXml() {
    return proofXml;
  }

  public void setProofXml(String proofXml) {
    this.proofXml = proofXml;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation proxyPan(String proxyPan) {
    this.proxyPan = proxyPan;
    return this;
  }

   /**
   * Encrypted version of the card number used in the payer authentication request message. 
   * @return proxyPan
  **/
  @ApiModelProperty(value = "Encrypted version of the card number used in the payer authentication request message. ")
  public String getProxyPan() {
    return proxyPan;
  }

  public void setProxyPan(String proxyPan) {
    this.proxyPan = proxyPan;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation sdkTransactionId(String sdkTransactionId) {
    this.sdkTransactionId = sdkTransactionId;
    return this;
  }

   /**
   * SDK unique transaction identifier that is generated on each new transaction. 
   * @return sdkTransactionId
  **/
  @ApiModelProperty(value = "SDK unique transaction identifier that is generated on each new transaction. ")
  public String getSdkTransactionId() {
    return sdkTransactionId;
  }

  public void setSdkTransactionId(String sdkTransactionId) {
    this.sdkTransactionId = sdkTransactionId;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation signedParesStatusReason(String signedParesStatusReason) {
    this.signedParesStatusReason = signedParesStatusReason;
    return this;
  }

   /**
   * Provides additional information as to why the PAResStatus has a specific value. 
   * @return signedParesStatusReason
  **/
  @ApiModelProperty(value = "Provides additional information as to why the PAResStatus has a specific value. ")
  public String getSignedParesStatusReason() {
    return signedParesStatusReason;
  }

  public void setSignedParesStatusReason(String signedParesStatusReason) {
    this.signedParesStatusReason = signedParesStatusReason;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation specificationVersion(String specificationVersion) {
    this.specificationVersion = specificationVersion;
    return this;
  }

   /**
   * This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 
   * @return specificationVersion
  **/
  @ApiModelProperty(value = "This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. ")
  public String getSpecificationVersion() {
    return specificationVersion;
  }

  public void setSpecificationVersion(String specificationVersion) {
    this.specificationVersion = specificationVersion;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation stepUpUrl(String stepUpUrl) {
    this.stepUpUrl = stepUpUrl;
    return this;
  }

   /**
   * The fully qualified URL that the merchant uses to post a form to the cardholder in order to complete the Consumer Authentication transaction for the Cardinal Cruise API integration. 
   * @return stepUpUrl
  **/
  @ApiModelProperty(value = "The fully qualified URL that the merchant uses to post a form to the cardholder in order to complete the Consumer Authentication transaction for the Cardinal Cruise API integration. ")
  public String getStepUpUrl() {
    return stepUpUrl;
  }

  public void setStepUpUrl(String stepUpUrl) {
    this.stepUpUrl = stepUpUrl;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation threeDSServerTransactionId(String threeDSServerTransactionId) {
    this.threeDSServerTransactionId = threeDSServerTransactionId;
    return this;
  }

   /**
   * Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 
   * @return threeDSServerTransactionId
  **/
  @ApiModelProperty(value = "Unique transaction identifier assigned by the 3DS Server to identify a single transaction. ")
  public String getThreeDSServerTransactionId() {
    return threeDSServerTransactionId;
  }

  public void setThreeDSServerTransactionId(String threeDSServerTransactionId) {
    this.threeDSServerTransactionId = threeDSServerTransactionId;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation ucafAuthenticationData(String ucafAuthenticationData) {
    this.ucafAuthenticationData = ucafAuthenticationData;
    return this;
  }

   /**
   * AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 
   * @return ucafAuthenticationData
  **/
  @ApiModelProperty(value = "AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. ")
  public String getUcafAuthenticationData() {
    return ucafAuthenticationData;
  }

  public void setUcafAuthenticationData(String ucafAuthenticationData) {
    this.ucafAuthenticationData = ucafAuthenticationData;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation ucafCollectionIndicator(String ucafCollectionIndicator) {
    this.ucafCollectionIndicator = ucafCollectionIndicator;
    return this;
  }

   /**
   * For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - &#x60;0&#x60;: Authentication data not collected, and customer authentication was not completed. - &#x60;1&#x60;: Authentication data not collected because customer authentication was not completed. - &#x60;2&#x60;: Authentication data collected because customer completed authentication. 
   * @return ucafCollectionIndicator
  **/
  @ApiModelProperty(value = "For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. ")
  public String getUcafCollectionIndicator() {
    return ucafCollectionIndicator;
  }

  public void setUcafCollectionIndicator(String ucafCollectionIndicator) {
    this.ucafCollectionIndicator = ucafCollectionIndicator;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation veresEnrolled(String veresEnrolled) {
    this.veresEnrolled = veresEnrolled;
    return this;
  }

   /**
   * Result of the enrollment check. This field can contain one of these values: - &#x60;Y&#x60;: Card enrolled or can be enrolled; you must authenticate. Liability shift. - &#x60;N&#x60;: Card not enrolled; proceed with authorization. Liability shift. - &#x60;U&#x60;: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - &#x60;B&#x60;: Indicates that authentication was bypassed.  For details, see &#x60;pa_enroll_veres_enrolled&#x60; field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 
   * @return veresEnrolled
  **/
  @ApiModelProperty(value = "Result of the enrollment check. This field can contain one of these values: - `Y`: Card enrolled or can be enrolled; you must authenticate. Liability shift. - `N`: Card not enrolled; proceed with authorization. Liability shift. - `U`: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - `B`: Indicates that authentication was bypassed.  For details, see `pa_enroll_veres_enrolled` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) ")
  public String getVeresEnrolled() {
    return veresEnrolled;
  }

  public void setVeresEnrolled(String veresEnrolled) {
    this.veresEnrolled = veresEnrolled;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation whiteListStatusSource(String whiteListStatusSource) {
    this.whiteListStatusSource = whiteListStatusSource;
    return this;
  }

   /**
   * This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 
   * @return whiteListStatusSource
  **/
  @ApiModelProperty(value = "This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS ")
  public String getWhiteListStatusSource() {
    return whiteListStatusSource;
  }

  public void setWhiteListStatusSource(String whiteListStatusSource) {
    this.whiteListStatusSource = whiteListStatusSource;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation xid(String xid) {
    this.xid = xid;
    return this;
  }

   /**
   * Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**&#x60;&#x3D;spa&#x60;) 
   * @return xid
  **/
  @ApiModelProperty(value = "Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) ")
  public String getXid() {
    return xid;
  }

  public void setXid(String xid) {
    this.xid = xid;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation directoryServerTransactionId(String directoryServerTransactionId) {
    this.directoryServerTransactionId = directoryServerTransactionId;
    return this;
  }

   /**
   * The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 
   * @return directoryServerTransactionId
  **/
  @ApiModelProperty(value = "The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID ")
  public String getDirectoryServerTransactionId() {
    return directoryServerTransactionId;
  }

  public void setDirectoryServerTransactionId(String directoryServerTransactionId) {
    this.directoryServerTransactionId = directoryServerTransactionId;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation authenticationResult(String authenticationResult) {
    this.authenticationResult = authenticationResult;
    return this;
  }

   /**
   * Raw authentication data that comes from the cardissuing bank. Primary authentication field that indicates if authentication was successful and if liability shift occurred. You should examine first the result of this field. This field contains one of these values: - &#x60;-1&#x60;: Invalid PARes. - &#x60;0&#x60;: Successful validation. - &#x60;1&#x60;: Cardholder is not participating, but the attempt to authenticate was recorded. - &#x60;6&#x60;: Issuer unable to perform authentication. - &#x60;9&#x60;: Cardholder did not complete authentication. 
   * @return authenticationResult
  **/
  @ApiModelProperty(value = "Raw authentication data that comes from the cardissuing bank. Primary authentication field that indicates if authentication was successful and if liability shift occurred. You should examine first the result of this field. This field contains one of these values: - `-1`: Invalid PARes. - `0`: Successful validation. - `1`: Cardholder is not participating, but the attempt to authenticate was recorded. - `6`: Issuer unable to perform authentication. - `9`: Cardholder did not complete authentication. ")
  public String getAuthenticationResult() {
    return authenticationResult;
  }

  public void setAuthenticationResult(String authenticationResult) {
    this.authenticationResult = authenticationResult;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation authenticationStatusMsg(String authenticationStatusMsg) {
    this.authenticationStatusMsg = authenticationStatusMsg;
    return this;
  }

   /**
   * Message that explains the authenticationResult reply field. 
   * @return authenticationStatusMsg
  **/
  @ApiModelProperty(value = "Message that explains the authenticationResult reply field. ")
  public String getAuthenticationStatusMsg() {
    return authenticationStatusMsg;
  }

  public void setAuthenticationStatusMsg(String authenticationStatusMsg) {
    this.authenticationStatusMsg = authenticationStatusMsg;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation indicator(String indicator) {
    this.indicator = indicator;
    return this;
  }

   /**
   * Indicator used to differentiate Internet transactions from other types. The authentication failed if this field is not returned. For Visa, if your payment processor is Streamline, Barclays, AIBMS, or FDC Germany, you receive the value vbv_failure instead of internet when eci is 07. The value of this field is passed automatically to the authorization service if you request the services together. This field contains one of these values: - &#x60;aesk&#x60;: American Express SafeKey authentication verified successfully. - &#x60;aesk_attempted&#x60;: Card not enrolled in American Express SafeKey, but the attempt to authenticate was recorded. - &#x60;dipb&#x60;: Discover ProtectBuy authentication verified successfully. - &#x60;dipb_attempted&#x60;: Card not enrolled in Discover ProtectBuy, but the attempt to authenticate was recorded. - &#x60;internet&#x60;: Authentication was not verified successfully. - &#x60;js&#x60;: J/Secure authentication verified successfully. - &#x60;js_attempted&#x60;: Card not enrolled in J/Secure, but the attempt to authenticate was recorded. - &#x60;moto&#x60;: Mail or telephone order. - &#x60;pb_attempted&#x60;: Card not enrolled in Diners Club ProtectBuy, but the attempt to authenticate was recorded. - &#x60;recurring&#x60;: Recurring transaction. - &#x60;spa&#x60;: Mastercard Identity Check authentication verified successfully. - &#x60;spa_failure&#x60;: Mastercard Identity Check failed authentication. - &#x60;vbv&#x60;: Visa Secure authentication verified successfully. - &#x60;vbv_attempted&#x60;: Card not enrolled in Visa Secure, but the attempt to authenticate was recorded. - &#x60;vbv_failure&#x60;: Visa Secure authentication unavailable. 
   * @return indicator
  **/
  @ApiModelProperty(value = "Indicator used to differentiate Internet transactions from other types. The authentication failed if this field is not returned. For Visa, if your payment processor is Streamline, Barclays, AIBMS, or FDC Germany, you receive the value vbv_failure instead of internet when eci is 07. The value of this field is passed automatically to the authorization service if you request the services together. This field contains one of these values: - `aesk`: American Express SafeKey authentication verified successfully. - `aesk_attempted`: Card not enrolled in American Express SafeKey, but the attempt to authenticate was recorded. - `dipb`: Discover ProtectBuy authentication verified successfully. - `dipb_attempted`: Card not enrolled in Discover ProtectBuy, but the attempt to authenticate was recorded. - `internet`: Authentication was not verified successfully. - `js`: J/Secure authentication verified successfully. - `js_attempted`: Card not enrolled in J/Secure, but the attempt to authenticate was recorded. - `moto`: Mail or telephone order. - `pb_attempted`: Card not enrolled in Diners Club ProtectBuy, but the attempt to authenticate was recorded. - `recurring`: Recurring transaction. - `spa`: Mastercard Identity Check authentication verified successfully. - `spa_failure`: Mastercard Identity Check failed authentication. - `vbv`: Visa Secure authentication verified successfully. - `vbv_attempted`: Card not enrolled in Visa Secure, but the attempt to authenticate was recorded. - `vbv_failure`: Visa Secure authentication unavailable. ")
  public String getIndicator() {
    return indicator;
  }

  public void setIndicator(String indicator) {
    this.indicator = indicator;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation interactionCounter(String interactionCounter) {
    this.interactionCounter = interactionCounter;
    return this;
  }

   /**
   * Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. 
   * @return interactionCounter
  **/
  @ApiModelProperty(value = "Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. ")
  public String getInteractionCounter() {
    return interactionCounter;
  }

  public void setInteractionCounter(String interactionCounter) {
    this.interactionCounter = interactionCounter;
  }

  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation whiteListStatus(String whiteListStatus) {
    this.whiteListStatus = whiteListStatus;
    return this;
  }

   /**
   * Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 
   * @return whiteListStatus
  **/
  @ApiModelProperty(value = "Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder ")
  public String getWhiteListStatus() {
    return whiteListStatus;
  }

  public void setWhiteListStatus(String whiteListStatus) {
    this.whiteListStatus = whiteListStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation = (PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation) o;
    return Objects.equals(this.accessToken, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.accessToken) &&
        Objects.equals(this.acsRenderingType, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.acsRenderingType) &&
        Objects.equals(this.acsTransactionId, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.acsTransactionId) &&
        Objects.equals(this.acsUrl, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.acsUrl) &&
        Objects.equals(this.authenticationPath, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.authenticationPath) &&
        Objects.equals(this.authorizationPayload, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.authorizationPayload) &&
        Objects.equals(this.authenticationTransactionId, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.authenticationTransactionId) &&
        Objects.equals(this.cardholderMessage, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.cardholderMessage) &&
        Objects.equals(this.cavv, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.cavv) &&
        Objects.equals(this.cavvAlgorithm, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.cavvAlgorithm) &&
        Objects.equals(this.challengeCancelCode, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.challengeCancelCode) &&
        Objects.equals(this.challengeRequired, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.challengeRequired) &&
        Objects.equals(this.decoupledAuthenticationIndicator, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.decoupledAuthenticationIndicator) &&
        Objects.equals(this.directoryServerErrorCode, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.directoryServerErrorCode) &&
        Objects.equals(this.directoryServerErrorDescription, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.directoryServerErrorDescription) &&
        Objects.equals(this.ecommerceIndicator, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.ecommerceIndicator) &&
        Objects.equals(this.eci, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.eci) &&
        Objects.equals(this.eciRaw, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.eciRaw) &&
        Objects.equals(this.effectiveAuthenticationType, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.effectiveAuthenticationType) &&
        Objects.equals(this.ivr, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.ivr) &&
        Objects.equals(this.strongAuthentication, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.strongAuthentication) &&
        Objects.equals(this.networkScore, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.networkScore) &&
        Objects.equals(this.pareq, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.pareq) &&
        Objects.equals(this.paresStatus, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.paresStatus) &&
        Objects.equals(this.proofXml, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.proofXml) &&
        Objects.equals(this.proxyPan, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.proxyPan) &&
        Objects.equals(this.sdkTransactionId, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.sdkTransactionId) &&
        Objects.equals(this.signedParesStatusReason, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.signedParesStatusReason) &&
        Objects.equals(this.specificationVersion, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.specificationVersion) &&
        Objects.equals(this.stepUpUrl, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.stepUpUrl) &&
        Objects.equals(this.threeDSServerTransactionId, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.threeDSServerTransactionId) &&
        Objects.equals(this.ucafAuthenticationData, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.ucafAuthenticationData) &&
        Objects.equals(this.ucafCollectionIndicator, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.ucafCollectionIndicator) &&
        Objects.equals(this.veresEnrolled, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.veresEnrolled) &&
        Objects.equals(this.whiteListStatusSource, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.whiteListStatusSource) &&
        Objects.equals(this.xid, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.xid) &&
        Objects.equals(this.directoryServerTransactionId, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.directoryServerTransactionId) &&
        Objects.equals(this.authenticationResult, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.authenticationResult) &&
        Objects.equals(this.authenticationStatusMsg, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.authenticationStatusMsg) &&
        Objects.equals(this.indicator, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.indicator) &&
        Objects.equals(this.interactionCounter, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.interactionCounter) &&
        Objects.equals(this.whiteListStatus, ptsV2PaymentsPost201ResponseConsumerAuthenticationInformation.whiteListStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessToken, acsRenderingType, acsTransactionId, acsUrl, authenticationPath, authorizationPayload, authenticationTransactionId, cardholderMessage, cavv, cavvAlgorithm, challengeCancelCode, challengeRequired, decoupledAuthenticationIndicator, directoryServerErrorCode, directoryServerErrorDescription, ecommerceIndicator, eci, eciRaw, effectiveAuthenticationType, ivr, strongAuthentication, networkScore, pareq, paresStatus, proofXml, proxyPan, sdkTransactionId, signedParesStatusReason, specificationVersion, stepUpUrl, threeDSServerTransactionId, ucafAuthenticationData, ucafCollectionIndicator, veresEnrolled, whiteListStatusSource, xid, directoryServerTransactionId, authenticationResult, authenticationStatusMsg, indicator, interactionCounter, whiteListStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation {\n");
    
    sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
    sb.append("    acsRenderingType: ").append(toIndentedString(acsRenderingType)).append("\n");
    sb.append("    acsTransactionId: ").append(toIndentedString(acsTransactionId)).append("\n");
    sb.append("    acsUrl: ").append(toIndentedString(acsUrl)).append("\n");
    sb.append("    authenticationPath: ").append(toIndentedString(authenticationPath)).append("\n");
    sb.append("    authorizationPayload: ").append(toIndentedString(authorizationPayload)).append("\n");
    sb.append("    authenticationTransactionId: ").append(toIndentedString(authenticationTransactionId)).append("\n");
    sb.append("    cardholderMessage: ").append(toIndentedString(cardholderMessage)).append("\n");
    sb.append("    cavv: ").append(toIndentedString(cavv)).append("\n");
    sb.append("    cavvAlgorithm: ").append(toIndentedString(cavvAlgorithm)).append("\n");
    sb.append("    challengeCancelCode: ").append(toIndentedString(challengeCancelCode)).append("\n");
    sb.append("    challengeRequired: ").append(toIndentedString(challengeRequired)).append("\n");
    sb.append("    decoupledAuthenticationIndicator: ").append(toIndentedString(decoupledAuthenticationIndicator)).append("\n");
    sb.append("    directoryServerErrorCode: ").append(toIndentedString(directoryServerErrorCode)).append("\n");
    sb.append("    directoryServerErrorDescription: ").append(toIndentedString(directoryServerErrorDescription)).append("\n");
    sb.append("    ecommerceIndicator: ").append(toIndentedString(ecommerceIndicator)).append("\n");
    sb.append("    eci: ").append(toIndentedString(eci)).append("\n");
    sb.append("    eciRaw: ").append(toIndentedString(eciRaw)).append("\n");
    sb.append("    effectiveAuthenticationType: ").append(toIndentedString(effectiveAuthenticationType)).append("\n");
    sb.append("    ivr: ").append(toIndentedString(ivr)).append("\n");
    sb.append("    strongAuthentication: ").append(toIndentedString(strongAuthentication)).append("\n");
    sb.append("    networkScore: ").append(toIndentedString(networkScore)).append("\n");
    sb.append("    pareq: ").append(toIndentedString(pareq)).append("\n");
    sb.append("    paresStatus: ").append(toIndentedString(paresStatus)).append("\n");
    sb.append("    proofXml: ").append(toIndentedString(proofXml)).append("\n");
    sb.append("    proxyPan: ").append(toIndentedString(proxyPan)).append("\n");
    sb.append("    sdkTransactionId: ").append(toIndentedString(sdkTransactionId)).append("\n");
    sb.append("    signedParesStatusReason: ").append(toIndentedString(signedParesStatusReason)).append("\n");
    sb.append("    specificationVersion: ").append(toIndentedString(specificationVersion)).append("\n");
    sb.append("    stepUpUrl: ").append(toIndentedString(stepUpUrl)).append("\n");
    sb.append("    threeDSServerTransactionId: ").append(toIndentedString(threeDSServerTransactionId)).append("\n");
    sb.append("    ucafAuthenticationData: ").append(toIndentedString(ucafAuthenticationData)).append("\n");
    sb.append("    ucafCollectionIndicator: ").append(toIndentedString(ucafCollectionIndicator)).append("\n");
    sb.append("    veresEnrolled: ").append(toIndentedString(veresEnrolled)).append("\n");
    sb.append("    whiteListStatusSource: ").append(toIndentedString(whiteListStatusSource)).append("\n");
    sb.append("    xid: ").append(toIndentedString(xid)).append("\n");
    sb.append("    directoryServerTransactionId: ").append(toIndentedString(directoryServerTransactionId)).append("\n");
    sb.append("    authenticationResult: ").append(toIndentedString(authenticationResult)).append("\n");
    sb.append("    authenticationStatusMsg: ").append(toIndentedString(authenticationStatusMsg)).append("\n");
    sb.append("    indicator: ").append(toIndentedString(indicator)).append("\n");
    sb.append("    interactionCounter: ").append(toIndentedString(interactionCounter)).append("\n");
    sb.append("    whiteListStatus: ").append(toIndentedString(whiteListStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

