/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.InlineResponse2001;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import utilities.tracking.SdkTracker;

public class KeyManagementApi {
    private static Logger logger = LogManager.getLogger(KeyManagementApi.class);
    private ApiClient apiClient;

    public KeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call searchKeysCall(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/kms/v2/keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        }
        if (organizationIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "organizationIds", organizationIds));
        }
        if (keyIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "keyIds", keyIds));
        }
        if (keyTypes != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "keyTypes", keyTypes));
        }
        if (expirationStartDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "expirationStartDate", expirationStartDate));
        }
        if (expirationEndDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "expirationEndDate", expirationEndDate));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchKeysValidateBeforeCall(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.searchKeysCall(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2001 searchKeys(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate) throws ApiException {
        logger.info("CALL TO METHOD 'searchKeys' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse2001> resp = this.searchKeysWithHttpInfo(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate);
        logger.info("CALL TO METHOD 'searchKeys' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2001> searchKeysWithHttpInfo(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate) throws ApiException {
        Call call = this.searchKeysValidateBeforeCall(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchKeysAsync(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate, final ApiCallback<InlineResponse2001> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchKeysValidateBeforeCall(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

