/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreateSharedSecretKeysRequest;
import Model.DeleteBulkSymmetricKeysRequest;
import Model.KmsV2KeysSymDeletesPost200Response;
import Model.KmsV2KeysSymGet200Response;
import Model.KmsV2KeysSymPost201Response;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SymmetricKeyManagementApi {
    private static Logger logger = LogManager.getLogger(SymmetricKeyManagementApi.class);
    private ApiClient apiClient;

    public SymmetricKeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SymmetricKeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createV2SharedSecretKeysCall(CreateSharedSecretKeysRequest createSharedSecretKeysRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateSharedSecretKeysRequest localVarPostBody = createSharedSecretKeysRequest;
        String localVarPath = "/kms/v2/keys-sym";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createV2SharedSecretKeysValidateBeforeCall(CreateSharedSecretKeysRequest createSharedSecretKeysRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createSharedSecretKeysRequest == null) {
            logger.error("Missing the required parameter 'createSharedSecretKeysRequest' when calling createV2SharedSecretKeys(Async)");
            throw new ApiException("Missing the required parameter 'createSharedSecretKeysRequest' when calling createV2SharedSecretKeys(Async)");
        }
        Call call = this.createV2SharedSecretKeysCall(createSharedSecretKeysRequest, progressListener, progressRequestListener);
        return call;
    }

    public KmsV2KeysSymPost201Response createV2SharedSecretKeys(CreateSharedSecretKeysRequest createSharedSecretKeysRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createV2SharedSecretKeys' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<KmsV2KeysSymPost201Response> resp = this.createV2SharedSecretKeysWithHttpInfo(createSharedSecretKeysRequest);
        logger.info("CALL TO METHOD 'createV2SharedSecretKeys' ENDED");
        return resp.getData();
    }

    public ApiResponse<KmsV2KeysSymPost201Response> createV2SharedSecretKeysWithHttpInfo(CreateSharedSecretKeysRequest createSharedSecretKeysRequest) throws ApiException {
        Call call = this.createV2SharedSecretKeysValidateBeforeCall(createSharedSecretKeysRequest, null, null);
        Type localVarReturnType = new TypeToken<KmsV2KeysSymPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createV2SharedSecretKeysAsync(CreateSharedSecretKeysRequest createSharedSecretKeysRequest, final ApiCallback<KmsV2KeysSymPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createV2SharedSecretKeysValidateBeforeCall(createSharedSecretKeysRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KmsV2KeysSymPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteBulkSymmetricKeysCall(DeleteBulkSymmetricKeysRequest deleteBulkSymmetricKeysRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeleteBulkSymmetricKeysRequest localVarPostBody = deleteBulkSymmetricKeysRequest;
        String localVarPath = "/kms/v2/keys-sym/deletes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteBulkSymmetricKeysValidateBeforeCall(DeleteBulkSymmetricKeysRequest deleteBulkSymmetricKeysRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deleteBulkSymmetricKeysRequest == null) {
            logger.error("Missing the required parameter 'deleteBulkSymmetricKeysRequest' when calling deleteBulkSymmetricKeys(Async)");
            throw new ApiException("Missing the required parameter 'deleteBulkSymmetricKeysRequest' when calling deleteBulkSymmetricKeys(Async)");
        }
        Call call = this.deleteBulkSymmetricKeysCall(deleteBulkSymmetricKeysRequest, progressListener, progressRequestListener);
        return call;
    }

    public KmsV2KeysSymDeletesPost200Response deleteBulkSymmetricKeys(DeleteBulkSymmetricKeysRequest deleteBulkSymmetricKeysRequest) throws ApiException {
        logger.info("CALL TO METHOD 'deleteBulkSymmetricKeys' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<KmsV2KeysSymDeletesPost200Response> resp = this.deleteBulkSymmetricKeysWithHttpInfo(deleteBulkSymmetricKeysRequest);
        logger.info("CALL TO METHOD 'deleteBulkSymmetricKeys' ENDED");
        return resp.getData();
    }

    public ApiResponse<KmsV2KeysSymDeletesPost200Response> deleteBulkSymmetricKeysWithHttpInfo(DeleteBulkSymmetricKeysRequest deleteBulkSymmetricKeysRequest) throws ApiException {
        Call call = this.deleteBulkSymmetricKeysValidateBeforeCall(deleteBulkSymmetricKeysRequest, null, null);
        Type localVarReturnType = new TypeToken<KmsV2KeysSymDeletesPost200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteBulkSymmetricKeysAsync(DeleteBulkSymmetricKeysRequest deleteBulkSymmetricKeysRequest, final ApiCallback<KmsV2KeysSymDeletesPost200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteBulkSymmetricKeysValidateBeforeCall(deleteBulkSymmetricKeysRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KmsV2KeysSymDeletesPost200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getKeyDetailsCall(String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/kms/v2/keys-sym/{keyId}".replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getKeyDetailsValidateBeforeCall(String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyId == null) {
            logger.error("Missing the required parameter 'keyId' when calling getKeyDetails(Async)");
            throw new ApiException("Missing the required parameter 'keyId' when calling getKeyDetails(Async)");
        }
        Call call = this.getKeyDetailsCall(keyId, progressListener, progressRequestListener);
        return call;
    }

    public KmsV2KeysSymGet200Response getKeyDetails(String keyId) throws ApiException {
        logger.info("CALL TO METHOD 'getKeyDetails' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<KmsV2KeysSymGet200Response> resp = this.getKeyDetailsWithHttpInfo(keyId);
        logger.info("CALL TO METHOD 'getKeyDetails' ENDED");
        return resp.getData();
    }

    public ApiResponse<KmsV2KeysSymGet200Response> getKeyDetailsWithHttpInfo(String keyId) throws ApiException {
        Call call = this.getKeyDetailsValidateBeforeCall(keyId, null, null);
        Type localVarReturnType = new TypeToken<KmsV2KeysSymGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getKeyDetailsAsync(String keyId, final ApiCallback<KmsV2KeysSymGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getKeyDetailsValidateBeforeCall(keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KmsV2KeysSymGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

