/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreateInvoiceRequest;
import Model.InvoicingV2InvoicesAllGet200Response;
import Model.InvoicingV2InvoicesGet200Response;
import Model.InvoicingV2InvoicesPost201Response;
import Model.UpdateInvoiceRequest;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InvoicesApi {
    private static Logger logger = LogManager.getLogger(InvoicesApi.class);
    private ApiClient apiClient;

    public InvoicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InvoicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createInvoiceCall(CreateInvoiceRequest createInvoiceRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateInvoiceRequest localVarPostBody = createInvoiceRequest;
        String localVarPath = "/invoicing/v2/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createInvoiceValidateBeforeCall(CreateInvoiceRequest createInvoiceRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createInvoiceRequest == null) {
            logger.error("Missing the required parameter 'createInvoiceRequest' when calling createInvoice(Async)");
            throw new ApiException("Missing the required parameter 'createInvoiceRequest' when calling createInvoice(Async)");
        }
        Call call = this.createInvoiceCall(createInvoiceRequest, progressListener, progressRequestListener);
        return call;
    }

    public InvoicingV2InvoicesPost201Response createInvoice(CreateInvoiceRequest createInvoiceRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createInvoice' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InvoicingV2InvoicesPost201Response> resp = this.createInvoiceWithHttpInfo(createInvoiceRequest);
        logger.info("CALL TO METHOD 'createInvoice' ENDED");
        return resp.getData();
    }

    public ApiResponse<InvoicingV2InvoicesPost201Response> createInvoiceWithHttpInfo(CreateInvoiceRequest createInvoiceRequest) throws ApiException {
        Call call = this.createInvoiceValidateBeforeCall(createInvoiceRequest, null, null);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createInvoiceAsync(CreateInvoiceRequest createInvoiceRequest, final ApiCallback<InvoicingV2InvoicesPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createInvoiceValidateBeforeCall(createInvoiceRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllInvoicesCall(Integer offset, Integer limit, String status, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/invoicing/v2/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllInvoicesValidateBeforeCall(Integer offset, Integer limit, String status, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (offset == null) {
            logger.error("Missing the required parameter 'offset' when calling getAllInvoices(Async)");
            throw new ApiException("Missing the required parameter 'offset' when calling getAllInvoices(Async)");
        }
        if (limit == null) {
            logger.error("Missing the required parameter 'limit' when calling getAllInvoices(Async)");
            throw new ApiException("Missing the required parameter 'limit' when calling getAllInvoices(Async)");
        }
        Call call = this.getAllInvoicesCall(offset, limit, status, progressListener, progressRequestListener);
        return call;
    }

    public InvoicingV2InvoicesAllGet200Response getAllInvoices(Integer offset, Integer limit, String status) throws ApiException {
        logger.info("CALL TO METHOD 'getAllInvoices' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InvoicingV2InvoicesAllGet200Response> resp = this.getAllInvoicesWithHttpInfo(offset, limit, status);
        logger.info("CALL TO METHOD 'getAllInvoices' ENDED");
        return resp.getData();
    }

    public ApiResponse<InvoicingV2InvoicesAllGet200Response> getAllInvoicesWithHttpInfo(Integer offset, Integer limit, String status) throws ApiException {
        Call call = this.getAllInvoicesValidateBeforeCall(offset, limit, status, null, null);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesAllGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllInvoicesAsync(Integer offset, Integer limit, String status, final ApiCallback<InvoicingV2InvoicesAllGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllInvoicesValidateBeforeCall(offset, limit, status, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesAllGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getInvoiceCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/invoicing/v2/invoices/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getInvoiceValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling getInvoice(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling getInvoice(Async)");
        }
        Call call = this.getInvoiceCall(id, progressListener, progressRequestListener);
        return call;
    }

    public InvoicingV2InvoicesGet200Response getInvoice(String id) throws ApiException {
        logger.info("CALL TO METHOD 'getInvoice' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InvoicingV2InvoicesGet200Response> resp = this.getInvoiceWithHttpInfo(id);
        logger.info("CALL TO METHOD 'getInvoice' ENDED");
        return resp.getData();
    }

    public ApiResponse<InvoicingV2InvoicesGet200Response> getInvoiceWithHttpInfo(String id) throws ApiException {
        Call call = this.getInvoiceValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getInvoiceAsync(String id, final ApiCallback<InvoicingV2InvoicesGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getInvoiceValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call performCancelActionCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/invoicing/v2/invoices/{id}/cancelation".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call performCancelActionValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling performCancelAction(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling performCancelAction(Async)");
        }
        Call call = this.performCancelActionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public InvoicingV2InvoicesPost201Response performCancelAction(String id) throws ApiException {
        logger.info("CALL TO METHOD 'performCancelAction' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InvoicingV2InvoicesPost201Response> resp = this.performCancelActionWithHttpInfo(id);
        logger.info("CALL TO METHOD 'performCancelAction' ENDED");
        return resp.getData();
    }

    public ApiResponse<InvoicingV2InvoicesPost201Response> performCancelActionWithHttpInfo(String id) throws ApiException {
        Call call = this.performCancelActionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call performCancelActionAsync(String id, final ApiCallback<InvoicingV2InvoicesPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.performCancelActionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call performSendActionCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/invoicing/v2/invoices/{id}/delivery".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call performSendActionValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling performSendAction(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling performSendAction(Async)");
        }
        Call call = this.performSendActionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public InvoicingV2InvoicesPost201Response performSendAction(String id) throws ApiException {
        logger.info("CALL TO METHOD 'performSendAction' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InvoicingV2InvoicesPost201Response> resp = this.performSendActionWithHttpInfo(id);
        logger.info("CALL TO METHOD 'performSendAction' ENDED");
        return resp.getData();
    }

    public ApiResponse<InvoicingV2InvoicesPost201Response> performSendActionWithHttpInfo(String id) throws ApiException {
        Call call = this.performSendActionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call performSendActionAsync(String id, final ApiCallback<InvoicingV2InvoicesPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.performSendActionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateInvoiceCall(String id, UpdateInvoiceRequest updateInvoiceRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateInvoiceRequest localVarPostBody = updateInvoiceRequest;
        String localVarPath = "/invoicing/v2/invoices/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateInvoiceValidateBeforeCall(String id, UpdateInvoiceRequest updateInvoiceRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling updateInvoice(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling updateInvoice(Async)");
        }
        if (updateInvoiceRequest == null) {
            logger.error("Missing the required parameter 'updateInvoiceRequest' when calling updateInvoice(Async)");
            throw new ApiException("Missing the required parameter 'updateInvoiceRequest' when calling updateInvoice(Async)");
        }
        Call call = this.updateInvoiceCall(id, updateInvoiceRequest, progressListener, progressRequestListener);
        return call;
    }

    public InvoicingV2InvoicesPost201Response updateInvoice(String id, UpdateInvoiceRequest updateInvoiceRequest) throws ApiException {
        logger.info("CALL TO METHOD 'updateInvoice' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InvoicingV2InvoicesPost201Response> resp = this.updateInvoiceWithHttpInfo(id, updateInvoiceRequest);
        logger.info("CALL TO METHOD 'updateInvoice' ENDED");
        return resp.getData();
    }

    public ApiResponse<InvoicingV2InvoicesPost201Response> updateInvoiceWithHttpInfo(String id, UpdateInvoiceRequest updateInvoiceRequest) throws ApiException {
        Call call = this.updateInvoiceValidateBeforeCall(id, updateInvoiceRequest, null, null);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateInvoiceAsync(String id, UpdateInvoiceRequest updateInvoiceRequest, final ApiCallback<InvoicingV2InvoicesPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateInvoiceValidateBeforeCall(id, updateInvoiceRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InvoicingV2InvoicesPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

