/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.jwt;

import com.cybersource.authsdk.cache.Cache;
import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.core.TokenGenerator;
import com.cybersource.authsdk.jwt.KeyCertificateGenerator;
import com.cybersource.authsdk.jwtsecurity.JWTCryptoProcessorImpl;
import com.cybersource.authsdk.log.Log4j;
import com.cybersource.authsdk.util.GlobalLabelParameters;
import com.cybersource.authsdk.util.Utility;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class JwtSignatureToken
implements TokenGenerator {
    private MerchantConfig merchantConfig;
    private String requestBody;
    private String jwtMethod;
    private Logger logger;
    private Cache cache;
    private RSAPrivateKey rsaPrivateKey = null;
    private X509Certificate x509Certificate = null;
    private String signature;

    public JwtSignatureToken(MerchantConfig merchantConfig, String requestBody) {
        this.merchantConfig = merchantConfig;
        this.requestBody = requestBody;
        this.jwtMethod = merchantConfig.getRequestType();
        this.logger = Log4j.getInstance(merchantConfig);
        this.cache = new Cache(this.merchantConfig);
    }

    @Override
    public String getToken() {
        try {
            this.signature = this.generateSignature();
        }
        catch (Exception e) {
            this.signature = null;
        }
        return this.signature;
    }

    public String generateSignature() throws Exception {
        block16: {
            try {
                if (this.merchantConfig != null && this.merchantConfig.getKeyType() != null) {
                    if (Cache.isCache) {
                        this.rsaPrivateKey = KeyCertificateGenerator.initializePrivateKey(this.merchantConfig);
                        this.x509Certificate = KeyCertificateGenerator.initializeCertificate(this.merchantConfig);
                        Utility.log(this.logger, " Empty Cache :: Adding Data", "", Level.INFO);
                        this.setUpCache();
                        Cache.isCache = false;
                    } else {
                        boolean lastModified = this.cache.isLastModifiedTimeP12();
                        if (lastModified) {
                            Utility.log(this.logger, " Data present in Cache :: Extracting Data", "", Level.INFO);
                            this.cache.retriveP12DataFromCache();
                            this.rsaPrivateKey = this.cache.getRsaPrivateKey();
                            this.x509Certificate = this.cache.getX509Certificate();
                        } else {
                            Utility.log(this.logger, " New Data present:: Inserting Data in Cache", "", Level.INFO);
                            this.rsaPrivateKey = KeyCertificateGenerator.initializePrivateKey(this.merchantConfig);
                            this.x509Certificate = KeyCertificateGenerator.initializeCertificate(this.merchantConfig);
                            this.setUpCache();
                        }
                    }
                    String encryptedSigMessage = "";
                    if (this.requestBody != null && !this.requestBody.isEmpty()) {
                        MessageDigest jwtBody = MessageDigest.getInstance(GlobalLabelParameters.SHA_256);
                        byte[] jwtClaimSetBody = jwtBody.digest(this.requestBody.getBytes());
                        encryptedSigMessage = Base64.getEncoder().encodeToString(jwtClaimSetBody);
                    }
                    String claimSet = null;
                    String method = this.jwtMethod;
                    if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("DELETE")) {
                        claimSet = "{\n            \"iat\":\"" + ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT) + "\"\n} \n\n";
                    } else if (method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT")) {
                        claimSet = "{\n            \"digest\":\"" + encryptedSigMessage + "\",\n            \"digestAlgorithm\":\"SHA-256\",\n            \"iat\":\"" + ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT) + "\"\n} \n\n";
                    }
                    HashMap<String, Object> customHeaders = new HashMap<String, Object>();
                    if (this.merchantConfig.getMerchantID() != null) {
                        customHeaders.put(JWTCryptoProcessorImpl.MERCHANT_ID, this.merchantConfig.getMerchantID());
                    }
                    if (this.merchantConfig.getMerchantID() != null) {
                        customHeaders.put("v-c-partner-id", this.merchantConfig.getMerchantID());
                    }
                    String authType = this.merchantConfig.getAuthenticationType().trim();
                    JWTCryptoProcessorImpl jwtCryptoProcessor = new JWTCryptoProcessorImpl();
                    if ("JWT".equalsIgnoreCase(authType)) {
                        this.signature = jwtCryptoProcessor.sign(claimSet, this.rsaPrivateKey, this.x509Certificate, customHeaders);
                    } else {
                        if (!"JWE".equalsIgnoreCase(authType)) {
                            throw new ConfigException("merchant config field is invalid: authType");
                        }
                        X509Certificate x509Cert = KeyCertificateGenerator.initializeRecipientCertificate(this.merchantConfig);
                        this.signature = jwtCryptoProcessor.signAndEncrypt(claimSet, this.rsaPrivateKey, this.x509Certificate, x509Cert, customHeaders);
                    }
                    break block16;
                }
                throw new ConfigException("merchant config fields missing: keyType, key type");
            }
            catch (Exception e) {
                Utility.log(this.logger, "JWT Signature production failed.", "", Level.FATAL);
                Utility.log(this.logger, e);
                this.signature = null;
            }
        }
        return this.signature;
    }

    private void setUpCache() throws ConfigException {
        this.cache.setX509Certificate(this.x509Certificate);
        this.cache.setRsaPrivateKey(this.rsaPrivateKey);
        this.cache.setP12FileDetailsInCache();
    }
}

