/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.http;

import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.payloaddigest.PayloadDigest;
import com.cybersource.authsdk.util.PropertiesUtil;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureGenerator {
    private MerchantConfig merchantConfig;
    private String signatureParameterBase64Encoded;
    private String httpMethod;
    private String merchantSecertKey;
    private String merchantId;

    public SignatureGenerator(MerchantConfig merchantConfig) throws InvalidKeyException, NoSuchAlgorithmException {
        this.merchantConfig = merchantConfig;
        this.httpMethod = merchantConfig.getRequestType();
        this.merchantSecertKey = merchantConfig.getMerchantSecretKey();
        this.merchantId = merchantConfig.getMerchantID();
    }

    public String signatureGeneration() throws NoSuchAlgorithmException, InvalidKeyException {
        StringBuilder signatureString = new StringBuilder();
        signatureString.append('\n');
        signatureString.append("Host".toLowerCase());
        signatureString.append(": ");
        signatureString.append(this.merchantConfig.getRequestHost());
        signatureString.append('\n');
        signatureString.append("Date".toLowerCase());
        signatureString.append(": ");
        signatureString.append(PropertiesUtil.date);
        signatureString.append('\n');
        signatureString.append("(request-target)");
        signatureString.append(": ");
        String requestTarget = null;
        if (this.httpMethod.equalsIgnoreCase("GET")) {
            requestTarget = this.getRequestTarget("GET");
        } else if (this.httpMethod.equalsIgnoreCase("POST")) {
            requestTarget = this.getRequestTarget("POST");
        } else if (this.httpMethod.equalsIgnoreCase("PUT")) {
            requestTarget = this.getRequestTarget("PUT");
        } else if (this.httpMethod.equalsIgnoreCase("DELETE")) {
            requestTarget = this.getRequestTarget("DELETE");
        }
        signatureString.append(requestTarget);
        signatureString.append('\n');
        if (this.httpMethod.equalsIgnoreCase("POST") || this.httpMethod.equalsIgnoreCase("PUT")) {
            signatureString.append("Digest".toLowerCase());
            signatureString.append(": ");
            signatureString.append(new PayloadDigest(this.merchantConfig).getDigest());
            signatureString.append('\n');
        }
        signatureString.append("v-c-merchant-id");
        signatureString.append(": ");
        signatureString.append(this.merchantId);
        signatureString.delete(0, 1);
        String signatureStr = signatureString.toString();
        SecretKeySpec secretKey = new SecretKeySpec(Base64.getDecoder().decode(this.merchantSecertKey), "HmacSHA256");
        Mac aKeyId = Mac.getInstance("HmacSHA256");
        aKeyId.init(secretKey);
        aKeyId.update(signatureStr.getBytes());
        byte[] aHeaders = aKeyId.doFinal();
        this.signatureParameterBase64Encoded = Base64.getEncoder().encodeToString(aHeaders);
        secretKey = null;
        return this.signatureParameterBase64Encoded;
    }

    public String getRequestTarget(String requestType) {
        String requestTarget;
        switch (requestType) {
            case "POST": {
                requestTarget = "POST".toLowerCase() + " " + this.merchantConfig.getRequestTarget();
                break;
            }
            case "GET": {
                requestTarget = "GET".toLowerCase() + " " + this.merchantConfig.getRequestTarget();
                break;
            }
            case "PUT": {
                requestTarget = "PUT".toLowerCase() + " " + this.merchantConfig.getRequestTarget();
                break;
            }
            case "DELETE": {
                requestTarget = "DELETE".toLowerCase() + " " + this.merchantConfig.getRequestTarget();
                break;
            }
            case "PATCH": {
                requestTarget = "PATCH".toLowerCase() + " " + this.merchantConfig.getRequestTarget();
                break;
            }
            default: {
                requestTarget = null;
            }
        }
        return requestTarget;
    }
}

