/*
 * Decompiled with CFR 0.152.
 */
package com.cxense.cxensesdk;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\f\u001a\u00020\u0003*\u00020\u0005H\u0002R\u001b\u0010\u0007\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/cxense/cxensesdk/UserAgentProvider;", "", "sdkVersion", "", "context", "Landroid/content/Context;", "(Ljava/lang/String;Landroid/content/Context;)V", "userAgent", "getUserAgent", "()Ljava/lang/String;", "userAgent$delegate", "Lkotlin/Lazy;", "getDefaultUserAgent", "Companion", "sdk_release"})
public final class UserAgentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy userAgent$delegate;
    @NotNull
    private static final String WEBVIEW_SUFFIX = "CxenseSDK";

    public UserAgentProvider(@NotNull String sdkVersion, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.userAgent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(sdkVersion, this, context){
            final /* synthetic */ String $sdkVersion;
            final /* synthetic */ UserAgentProvider this$0;
            final /* synthetic */ Context $context;
            {
                this.$sdkVersion = $sdkVersion;
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "cx-sdk/" + this.$sdkVersion + ' ' + UserAgentProvider.access$getDefaultUserAgent(this.this$0, this.$context);
            }
        }));
    }

    @NotNull
    public final String getUserAgent() {
        Lazy lazy = this.userAgent$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final String getDefaultUserAgent(Context $this$getDefaultUserAgent) {
        try {
            if (Build.VERSION.SDK_INT >= 28 && !Intrinsics.areEqual((Object)$this$getDefaultUserAgent.getPackageName(), (Object)Application.getProcessName())) {
                WebView.setDataDirectorySuffix((String)WEBVIEW_SUFFIX);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                String string = WebSettings.getDefaultUserAgent((Context)$this$getDefaultUserAgent);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultUserAgent(this)");
                return string;
            }
            String string = new WebView($this$getDefaultUserAgent).getSettings().getUserAgentString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"WebView(this).settings.userAgentString");
            return string;
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e);
            String string = System.getProperty("http.agent");
            return string == null ? "" : string;
        }
    }

    public static final /* synthetic */ String access$getDefaultUserAgent(UserAgentProvider $this, Context $receiver) {
        return $this.getDefaultUserAgent($receiver);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cxense/cxensesdk/UserAgentProvider$Companion;", "", "()V", "WEBVIEW_SUFFIX", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

