/*
 * Decompiled with CFR 0.152.
 */
package com.cxense.cxensesdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.cxense.cxensesdk.CxenseConfiguration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0014*\u00020\u0016H\u0003R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/cxense/cxensesdk/DeviceInfoProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "applicationName", "", "getApplicationName", "()Ljava/lang/String;", "applicationName$delegate", "Lkotlin/Lazy;", "applicationVersion", "getApplicationVersion", "applicationVersion$delegate", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "displayMetrics$delegate", "getCurrentNetworkStatus", "Lcom/cxense/cxensesdk/CxenseConfiguration$NetworkStatus;", "toNetworkStatus", "Landroid/net/NetworkCapabilities;", "Companion", "sdk_release"})
public final class DeviceInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy displayMetrics$delegate;
    @NotNull
    private final Lazy applicationVersion$delegate;
    @NotNull
    private final Lazy applicationName$delegate;
    @NotNull
    private static final Integer[] MOBILE_NETWORK_TYPES;

    public DeviceInfoProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.displayMetrics$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DisplayMetrics>(this){
            final /* synthetic */ DeviceInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DisplayMetrics invoke() {
                return DeviceInfoProvider.access$getContext$p(this.this$0).getResources().getDisplayMetrics();
            }
        }));
        this.applicationVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string;
                try {
                    string = DeviceInfoProvider.access$getContext$p((DeviceInfoProvider)this.this$0).getPackageManager().getPackageInfo((String)DeviceInfoProvider.access$getContext$p((DeviceInfoProvider)this.this$0).getPackageName(), (int)0).versionName;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Timber.Forest.e((Throwable)e, "Problems during application version search", new Object[0]);
                    string = null;
                }
                return string;
            }
        }));
        this.applicationName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ((Object)DeviceInfoProvider.access$getContext$p(this.this$0).getPackageManager().getApplicationLabel(DeviceInfoProvider.access$getContext$p(this.this$0).getApplicationInfo())).toString();
            }
        }));
    }

    @NotNull
    public final DisplayMetrics getDisplayMetrics() {
        Lazy lazy = this.displayMetrics$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-displayMetrics>(...)");
        return (DisplayMetrics)object;
    }

    @Nullable
    public final String getApplicationVersion() {
        Lazy lazy = this.applicationVersion$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getApplicationName() {
        Lazy lazy = this.applicationName$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @RequiresApi(value=21)
    private final CxenseConfiguration.NetworkStatus toNetworkStatus(NetworkCapabilities $this$toNetworkStatus) {
        return $this$toNetworkStatus.hasTransport(1) || $this$toNetworkStatus.hasTransport(3) ? CxenseConfiguration.NetworkStatus.WIFI : ($this$toNetworkStatus.hasTransport(0) ? CxenseConfiguration.NetworkStatus.MOBILE : ($this$toNetworkStatus.hasCapability(12) ? CxenseConfiguration.NetworkStatus.GPRS : CxenseConfiguration.NetworkStatus.NONE));
    }

    @NotNull
    public final CxenseConfiguration.NetworkStatus getCurrentNetworkStatus() {
        CxenseConfiguration.NetworkStatus networkStatus;
        ConnectivityManager connectivityManager;
        ConnectivityManager connectivityManager2 = (ConnectivityManager)ContextCompat.getSystemService((Context)this.context, ConnectivityManager.class);
        if (connectivityManager2 == null) {
            return CxenseConfiguration.NetworkStatus.NONE;
        }
        ConnectivityManager manager = connectivityManager = connectivityManager2;
        if (Build.VERSION.SDK_INT >= 29) {
            connectivityManager = manager.getNetworkCapabilities(manager.getActiveNetwork());
            return connectivityManager == null ? CxenseConfiguration.NetworkStatus.NONE : this.toNetworkStatus((NetworkCapabilities)connectivityManager);
        }
        NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
        if (activeNetworkInfo == null || !activeNetworkInfo.isConnected()) {
            networkStatus = CxenseConfiguration.NetworkStatus.NONE;
        } else if (activeNetworkInfo.getType() == 1) {
            networkStatus = CxenseConfiguration.NetworkStatus.WIFI;
        } else {
            TelephonyManager telephonyManager = (TelephonyManager)ContextCompat.getSystemService((Context)this.context, TelephonyManager.class);
            networkStatus = telephonyManager == null ? CxenseConfiguration.NetworkStatus.NONE : (ArraysKt.contains((Object[])MOBILE_NETWORK_TYPES, (Object)telephonyManager.getNetworkType()) ? CxenseConfiguration.NetworkStatus.MOBILE : CxenseConfiguration.NetworkStatus.GPRS);
        }
        return networkStatus;
    }

    @NotNull
    public static final Integer[] getMOBILE_NETWORK_TYPES() {
        return Companion.getMOBILE_NETWORK_TYPES();
    }

    public static final /* synthetic */ Context access$getContext$p(DeviceInfoProvider $this) {
        return $this.context;
    }

    static {
        Integer[] integerArray = new Integer[]{8, 10, 15, 9, 13};
        MOBILE_NETWORK_TYPES = integerArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\t\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/cxense/cxensesdk/DeviceInfoProvider$Companion;", "", "()V", "MOBILE_NETWORK_TYPES", "", "", "getMOBILE_NETWORK_TYPES$annotations", "getMOBILE_NETWORK_TYPES", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Integer[] getMOBILE_NETWORK_TYPES() {
            return MOBILE_NETWORK_TYPES;
        }

        @JvmStatic
        public static /* synthetic */ void getMOBILE_NETWORK_TYPES$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

