/*
 * Decompiled with CFR 0.152.
 */
package com.cxense.cxensesdk;

import com.cxense.cxensesdk.AuthInterceptor;
import com.cxense.cxensesdk.Authorized;
import com.cxense.cxensesdk.BaseException;
import com.cxense.cxensesdk.CredentialsProvider;
import com.cxense.cxensesdk.CxenseConfiguration;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Invocation;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/cxense/cxensesdk/AuthInterceptor;", "Lokhttp3/Interceptor;", "cxenseConfiguration", "Lcom/cxense/cxensesdk/CxenseConfiguration;", "(Lcom/cxense/cxensesdk/CxenseConfiguration;)V", "dateString", "", "getDateString$sdk_release", "()Ljava/lang/String;", "createToken", "username", "secret", "createToken$sdk_release", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "addAuth", "Lokhttp3/Request;", "Companion", "sdk_release"})
public final class AuthInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CxenseConfiguration cxenseConfiguration;
    @NotNull
    public static final String AUTH_HEADER = "X-cXense-Authentication";
    @NotNull
    private static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    @NotNull
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    @NotNull
    private static final String ALGORITHM = "HmacSHA256";

    public AuthInterceptor(@NotNull CxenseConfiguration cxenseConfiguration2) {
        Intrinsics.checkNotNullParameter((Object)cxenseConfiguration2, (String)"cxenseConfiguration");
        this.cxenseConfiguration = cxenseConfiguration2;
    }

    @NotNull
    public final String getDateString$sdk_release() {
        String string = DATE_FORMAT.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DATE_FORMAT.format(Date())");
        return string;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"chain.request()");
        Response response = chain.proceed(this.addAuth(request));
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(chain.request().addAuth())");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final Request addAuth(Request $this$addAuth) {
        try {
            Request request;
            Invocation invocation = (Invocation)$this$addAuth.tag(Invocation.class);
            if (invocation == null) {
                request = $this$addAuth;
            } else {
                Method method = invocation.method();
                if (method == null) {
                    request = $this$addAuth;
                } else {
                    Authorized authorized = method.getAnnotation(Authorized.class);
                    if (authorized == null) {
                        request = $this$addAuth;
                    } else {
                        void $this$addAuth_u24lambda_u2d1_u24lambda_u2d0;
                        Authorized authorized2 = authorized;
                        boolean bl = false;
                        boolean bl2 = false;
                        Authorized it = authorized2;
                        boolean bl3 = false;
                        CredentialsProvider credentialsProvider2 = this.cxenseConfiguration.getCredentialsProvider();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        CredentialsProvider credentialsProvider3 = credentialsProvider2;
                        String string = AUTH_HEADER;
                        Request.Builder builder = $this$addAuth.newBuilder();
                        boolean bl6 = false;
                        String string2 = this.createToken$sdk_release($this$addAuth_u24lambda_u2d1_u24lambda_u2d0.getUsername(), $this$addAuth_u24lambda_u2d1_u24lambda_u2d0.getApiKey());
                        Request request2 = builder.header(string, string2).build();
                        request = request2 == null ? $this$addAuth : request2;
                    }
                }
            }
            return request;
        }
        catch (Exception e) {
            throw new BaseException("Failed to create authenticationToken!", e);
        }
    }

    @NotNull
    public final String createToken$sdk_release(@NotNull String username, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        String date = this.getDateString$sdk_release();
        Object object = Mac.getInstance(ALGORITHM);
        boolean bl = false;
        boolean bl2 = false;
        Mac $this$createToken_u24lambda_u2d2 = object;
        boolean bl3 = false;
        String string = secret;
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$createToken_u24lambda_u2d2.init(new SecretKeySpec(byArray, ALGORITHM));
        string = date;
        charset = Charsets.UTF_8;
        bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        $this$createToken_u24lambda_u2d2.update(byArray2);
        byte[] byArray3 = ((Mac)object).doFinal();
        object = "username=" + username + " date=" + date + " hmac-sha256-hex=";
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"doFinal()");
        return ArraysKt.joinToString$default((byte[])byArray3, (CharSequence)"", (CharSequence)((CharSequence)object), null, (int)0, null, (Function1)createToken.2.INSTANCE, (int)28, null);
    }

    @NotNull
    public static final DateFormat getDATE_FORMAT() {
        return Companion.getDATE_FORMAT();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/cxense/cxensesdk/AuthInterceptor$Companion;", "", "()V", "ALGORITHM", "", "AUTH_HEADER", "DATE_FORMAT", "Ljava/text/DateFormat;", "getDATE_FORMAT$annotations", "getDATE_FORMAT", "()Ljava/text/DateFormat;", "ISO_8601", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateFormat getDATE_FORMAT() {
            return DATE_FORMAT;
        }

        @JvmStatic
        public static /* synthetic */ void getDATE_FORMAT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

