/*
 * Decompiled with CFR 0.152.
 */
package com.cxense.cxensesdk;

import com.cxense.cxensesdk.BadRequestException;
import com.cxense.cxensesdk.BaseException;
import com.cxense.cxensesdk.ForbiddenException;
import com.cxense.cxensesdk.NotAuthorizedException;
import com.cxense.cxensesdk.model.ApiError;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Response;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/cxense/cxensesdk/ApiErrorParser;", "", "converter", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "Lcom/cxense/cxensesdk/model/ApiError;", "(Lretrofit2/Converter;)V", "parseError", "Lcom/cxense/cxensesdk/BaseException;", "response", "Lretrofit2/Response;", "sdk_release"})
public final class ApiErrorParser {
    @NotNull
    private final Converter<ResponseBody, ApiError> converter;

    public ApiErrorParser(@NotNull Converter<ResponseBody, ApiError> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.converter = converter;
    }

    @Nullable
    public final BaseException parseError(@NotNull Response<?> response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        if (response.isSuccessful()) {
            return null;
        }
        try {
            BaseException baseException;
            ApiError apiError;
            Object object = response.errorBody();
            if (object == null) {
                apiError = null;
            } else {
                ApiError apiError2;
                ResponseBody responseBody = object;
                boolean bl = false;
                boolean bl2 = false;
                ResponseBody it = responseBody;
                boolean bl3 = false;
                try {
                    apiError2 = (ApiError)this.converter.convert((Object)it);
                }
                catch (IOException e) {
                    apiError2 = null;
                }
                apiError = apiError2;
            }
            ApiError apiError3 = apiError;
            ApiError apiError4 = apiError3 == null ? new ApiError(null, 1, null) : apiError3;
            object = apiError4.getError();
            String message = object == null ? "" : object;
            int n = response.code();
            switch (n) {
                case 400: {
                    baseException = new BadRequestException(message);
                    break;
                }
                case 401: {
                    baseException = new NotAuthorizedException(message);
                    break;
                }
                case 403: {
                    baseException = new ForbiddenException(message);
                    break;
                }
                default: {
                    baseException = new BaseException(message);
                }
            }
            return baseException;
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e);
            return new BaseException(e);
        }
    }
}

