/*
 * Decompiled with CFR 0.152.
 */
package com.cxense.cxensesdk;

import com.cxense.cxensesdk.ApiErrorParser;
import com.cxense.cxensesdk.BaseException;
import com.cxense.cxensesdk.LoadCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/cxense/cxensesdk/ApiCallback;", "T", "", "Lretrofit2/Callback;", "callback", "Lcom/cxense/cxensesdk/LoadCallback;", "errorParser", "Lcom/cxense/cxensesdk/ApiErrorParser;", "(Lcom/cxense/cxensesdk/LoadCallback;Lcom/cxense/cxensesdk/ApiErrorParser;)V", "onFailure", "", "call", "Lretrofit2/Call;", "t", "", "onResponse", "response", "Lretrofit2/Response;", "sdk_release"})
public final class ApiCallback<T>
implements Callback<T> {
    @NotNull
    private final LoadCallback<T> callback;
    @NotNull
    private final ApiErrorParser errorParser;

    public ApiCallback(@NotNull LoadCallback<? super T> callback, @NotNull ApiErrorParser errorParser2) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)errorParser2, (String)"errorParser");
        this.callback = callback;
        this.errorParser = errorParser2;
    }

    public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.callback.onError(t);
    }

    public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        Object body = response.body();
        if (response.isSuccessful() && body != null) {
            this.callback.onSuccess(body);
        } else {
            BaseException baseException = this.errorParser.parseError(response);
            BaseException e = baseException == null ? new BaseException("Response body is null") : baseException;
            this.callback.onError(e);
        }
    }
}

