package com.lenovo.httplibcode.request.example;

import android.util.Log;

import com.google.gson.Gson;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import okhttp3.ResponseBody;
import rx.Subscriber;


/**
 * Created by cx on 2017/9/20.
 *
 * request of https，response is html
 *
 */

public abstract class SubscriberNHttps<T> extends Subscriber<ResponseBody> {

    public static Gson gson = new Gson();

    @Override
    public void onCompleted() {

    }

    @Override
    public void onError(Throwable e) {
        onError(e.getMessage());
    }

    @Override
    public void onNext(ResponseBody jsonObject) {

        try {
            if(jsonObject.contentType().subtype().equals("json")){

                Log.e("http https", jsonObject.string());

            }else{
                byte[] bytes = jsonObject.bytes();

                String myResponse = new String(bytes);

                Log.e("http https", myResponse);

                onResult(myResponse);

            }

        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    @SuppressWarnings("unchecked")
    private Class<T> getGenericClass() {
        Type type = getClass().getGenericSuperclass();
        Type[] arguments = ((ParameterizedType) type).getActualTypeArguments();
        return (Class<T>) arguments[0];
    }

    public abstract void onResult(String response);

    public abstract void onError(String errMsg);
}
