package com.lenovo.httplibcode.Demo.ui;

import android.widget.TextView;


import com.lenovo.http_core.R;
import com.lenovo.http_core.R2;
import com.lenovo.httplibcode.Demo.contract.RequestContract;
import com.lenovo.httplibcode.Demo.presenter.RequestPresenter;
import com.lenovo.httplibcode.common.base.BaseActivity;

import butterknife.BindView;

/**
 * Created by cx on 2017/9/18.
 */

public class RequestTestActivity extends BaseActivity implements RequestContract.View {

    @BindView(R2.id.text)
    TextView text;

    private RequestContract.Presenter presenter;

    @Override
    protected int bindLayout() {
        return R.layout.activity_requesttest;
    }

    @Override
    protected void setWidget() {

        presenter = new RequestPresenter(this);

        presenter.start();
    }

    @Override
    public void setPresenter(RequestContract.Presenter presenter) {

        this.presenter = presenter;

    }

    @Override
    public String getId() {

        return "1";

    }

    @Override
    public void showData(String result) {

        text.setText(result);

    }
}
