package com.lenovo.httplibcode.Demo.model;

import com.google.gson.JsonObject;
import com.lenovo.httplibcode.common.callback.OnRequestCallback;
import com.lenovo.httplibcode.request.ServiceGenerator;
import com.lenovo.httplibcode.request.example.SubscriberNHttps;
import com.lenovo.httplibcode.request.norxjava.CallBackN;
import com.lenovo.httplibcode.request.rxjava.ObservableN;
import com.lenovo.httplibcode.request.rxjava.SubscriberN;

import okhttp3.ResponseBody;

/**
 * Created by cx on 2017/9/18.
 * two style: have rxjava and no rxjava
 */

public class RequestModel implements IRequestModel {

    @Override
    public void getUploadRecordData(String id, final OnRequestCallback<Bean> callback) {

        /**
         * rxjava
         */
        ServiceGenerator.getApiService().getReportRecordwithRxjava(id).compose(ObservableN.<JsonObject> applySchedulers()).subscribe(new SubscriberN<Bean>(){

            @Override
            public void onResult(Bean response) {
                callback.onSuccess(response);
            }

            @Override
            public void onError(String errMsg) {
                callback.onFailure(errMsg);
            }
        });

        /**
         * no rxjava
         */
        ServiceGenerator.getApiService().getReportRecord(id).enqueue(new CallBackN<Bean>() {

            @Override
            public void onResult(Bean response) {
                callback.onSuccess(response);
            }

            @Override
            public void onError(String errMsg) {
                callback.onFailure(errMsg);
            }
        });
    }

    @Override
    public void getHttpsInfo(String id,final OnRequestCallback<String> callback) {

        ServiceGenerator.getApiService().testHttps(id).compose(ObservableN.<ResponseBody> applySchedulers()).subscribe(new SubscriberNHttps<String>(){

                    @Override
                    public void onResult(String response) {
                        callback.onSuccess(response);
                    }

                    @Override
                    public void onError(String errMsg) {
                        callback.onFailure(errMsg);
                    }
        });

    }

}
