/*
 * Decompiled with CFR 0.152.
 */
package com.cw.rdf.core.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/cw/rdf/core/http/HttpCookieJar;", "Lokhttp3/CookieJar;", "()V", "cookieCache", "", "", "Lokhttp3/Cookie;", "loadForRequest", "", "url", "Lokhttp3/HttpUrl;", "saveFromResponse", "", "cookies", "core_release"})
public final class HttpCookieJar
implements CookieJar {
    private Map<String, Cookie> cookieCache = new HashMap();

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(cookies, (String)"cookies");
        for (Cookie cookie : cookies) {
            String string2 = cookie.name();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cookie.name()");
            this.cookieCache.put(string2, cookie);
        }
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookieCache.values()) {
            if (!cookie.matches(url)) continue;
            cookies.add(cookie);
        }
        return cookies;
    }
}

