/*
 * Decompiled with CFR 0.152.
 */
package com.culiu.mhvp.integrated.ptr.pulltorefresh.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.culiu.mhvp.integrated.ptr.R;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.ILoadingLayout;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.PullToRefreshBase;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.Utils;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.ViewCompat;

@SuppressLint(value={"ViewConstructor"})
public abstract class LoadingLayout
extends FrameLayout
implements ILoadingLayout {
    public static float SCALE_REFRESHING = 1.0f;
    static final String LOG_TAG = "PullToRefresh-LoadingLayout";
    static final Interpolator ANIMATION_INTERPOLATOR = new LinearInterpolator();
    private LinearLayout mInnerLayout;
    protected final ImageView mHeaderImage;
    protected final ProgressBar mHeaderProgress;
    private boolean mUseIntrinsicAnimation;
    private final TextView mHeaderText;
    private final TextView mSubHeaderText;
    protected final PullToRefreshBase.Mode mMode;
    protected final PullToRefreshBase.Orientation mScrollDirection;
    private CharSequence mPullLabel;
    private CharSequence mRefreshingLabel;
    private CharSequence mReleaseLabel;
    private TextView mTipsTextView;

    public LoadingLayout(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.Orientation scrollDirection, TypedArray attrs, int layoutId) {
        super(context);
        ColorStateList colors;
        TypedValue styleID;
        Drawable background;
        this.mMode = mode;
        this.mScrollDirection = scrollDirection;
        switch (scrollDirection) {
            case HORIZONTAL: {
                break;
            }
            default: {
                LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)this);
            }
        }
        this.mInnerLayout = (LinearLayout)this.findViewById(R.id.fl_inner);
        this.mHeaderText = (TextView)this.mInnerLayout.findViewById(R.id.pull_to_refresh_text);
        this.mHeaderProgress = (ProgressBar)this.mInnerLayout.findViewById(R.id.pull_to_refresh_progress);
        this.mSubHeaderText = (TextView)this.mInnerLayout.findViewById(R.id.pull_to_refresh_sub_text);
        this.mHeaderImage = (ImageView)this.mInnerLayout.findViewById(R.id.pull_to_refresh_image);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mInnerLayout.getLayoutParams();
        switch (mode) {
            case PULL_FROM_END: {
                lp.gravity = scrollDirection == PullToRefreshBase.Orientation.VERTICAL ? 48 : 3;
                this.mPullLabel = context.getString(R.string.pull_to_refresh_pull_up_label);
                this.mRefreshingLabel = context.getString(R.string.pull_to_refresh_refreshing_label);
                this.mReleaseLabel = context.getString(R.string.pull_to_refresh_release_label);
                break;
            }
            default: {
                lp.gravity = scrollDirection == PullToRefreshBase.Orientation.VERTICAL ? 80 : 5;
                this.mPullLabel = context.getString(R.string.pull_to_refresh_pull_down_label);
                this.mRefreshingLabel = context.getString(R.string.pull_to_refresh_refreshing_label);
                this.mReleaseLabel = context.getString(R.string.pull_to_refresh_release_label);
            }
        }
        if (attrs.hasValue(R.styleable.PullToRefresh_ptrHeaderBackground) && null != (background = attrs.getDrawable(R.styleable.PullToRefresh_ptrHeaderBackground))) {
            ViewCompat.setBackground((View)this, background);
        }
        if (attrs.hasValue(R.styleable.PullToRefresh_ptrHeaderTextAppearance)) {
            styleID = new TypedValue();
            attrs.getValue(R.styleable.PullToRefresh_ptrHeaderTextAppearance, styleID);
            this.setTextAppearance(styleID.data);
        }
        if (attrs.hasValue(R.styleable.PullToRefresh_ptrSubHeaderTextAppearance)) {
            styleID = new TypedValue();
            attrs.getValue(R.styleable.PullToRefresh_ptrSubHeaderTextAppearance, styleID);
            this.setSubTextAppearance(styleID.data);
        }
        if (attrs.hasValue(R.styleable.PullToRefresh_ptrHeaderTextColor) && null != (colors = attrs.getColorStateList(R.styleable.PullToRefresh_ptrHeaderTextColor))) {
            this.setTextColor(colors);
        }
        if (attrs.hasValue(R.styleable.PullToRefresh_ptrHeaderSubTextColor) && null != (colors = attrs.getColorStateList(R.styleable.PullToRefresh_ptrHeaderSubTextColor))) {
            this.setSubTextColor(colors);
        }
        Drawable imageDrawable = null;
        if (attrs.hasValue(R.styleable.PullToRefresh_ptrDrawable)) {
            imageDrawable = attrs.getDrawable(R.styleable.PullToRefresh_ptrDrawable);
        }
        switch (mode) {
            default: {
                if (attrs.hasValue(R.styleable.PullToRefresh_ptrDrawableStart)) {
                    imageDrawable = attrs.getDrawable(R.styleable.PullToRefresh_ptrDrawableStart);
                    break;
                }
                if (!attrs.hasValue(R.styleable.PullToRefresh_ptrDrawableTop)) break;
                Utils.warnDeprecation("ptrDrawableTop", "ptrDrawableStart");
                imageDrawable = attrs.getDrawable(R.styleable.PullToRefresh_ptrDrawableTop);
                break;
            }
            case PULL_FROM_END: {
                if (attrs.hasValue(R.styleable.PullToRefresh_ptrDrawableEnd)) {
                    imageDrawable = attrs.getDrawable(R.styleable.PullToRefresh_ptrDrawableEnd);
                    break;
                }
                if (!attrs.hasValue(R.styleable.PullToRefresh_ptrDrawableBottom)) break;
                Utils.warnDeprecation("ptrDrawableBottom", "ptrDrawableEnd");
                imageDrawable = attrs.getDrawable(R.styleable.PullToRefresh_ptrDrawableBottom);
            }
        }
        if (null == imageDrawable) {
            imageDrawable = context.getResources().getDrawable(this.getDefaultDrawableResId());
        }
        this.setLoadingDrawable(imageDrawable);
        this.reset();
    }

    public void setTipsText(String text) {
        if (this.mTipsTextView != null) {
            this.mTipsTextView.setText((CharSequence)text);
        }
    }

    public final void setHeight(int height) {
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        lp.height = height;
        this.requestLayout();
    }

    public final void setWidth(int width) {
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        lp.width = width;
        this.requestLayout();
    }

    public final int getContentSize() {
        if (this.mScrollDirection != null) {
            switch (this.mScrollDirection) {
                case HORIZONTAL: {
                    return this.mInnerLayout.getWidth();
                }
            }
            return this.mInnerLayout.getHeight();
        }
        return this.mInnerLayout.getHeight();
    }

    public final void hideAllViews() {
        if (0 == this.mHeaderText.getVisibility()) {
            this.mHeaderText.setVisibility(4);
        }
        if (0 == this.mHeaderProgress.getVisibility()) {
            this.mHeaderProgress.setVisibility(4);
        }
        if (0 == this.mHeaderImage.getVisibility()) {
            this.mHeaderImage.setVisibility(4);
        }
        if (0 == this.mSubHeaderText.getVisibility()) {
            this.mSubHeaderText.setVisibility(4);
        }
        if (this.mTipsTextView != null && 0 == this.mTipsTextView.getVisibility()) {
            this.mTipsTextView.setVisibility(4);
        }
    }

    public final void onPull(float scaleOfLayout) {
        if (!this.mUseIntrinsicAnimation) {
            this.onPullImpl(scaleOfLayout);
        }
    }

    public final void pullToRefresh() {
        if (null != this.mHeaderText) {
            this.mHeaderText.setText(this.mPullLabel);
        }
        this.pullToRefreshImpl();
    }

    public final void refreshing() {
        if (null != this.mHeaderText) {
            this.mHeaderText.setText(this.mRefreshingLabel);
        }
        if (this.mUseIntrinsicAnimation) {
            ((AnimationDrawable)this.mHeaderImage.getDrawable()).start();
        } else {
            this.refreshingImpl();
        }
        if (null != this.mSubHeaderText) {
            this.mSubHeaderText.setVisibility(8);
        }
    }

    public final void releaseToRefresh() {
        if (null != this.mHeaderText) {
            this.mHeaderText.setText(this.mReleaseLabel);
        }
        this.releaseToRefreshImpl();
    }

    public final void reset() {
        if (null != this.mHeaderText) {
            this.mHeaderText.setText(this.mPullLabel);
        }
        this.mHeaderImage.setVisibility(0);
        if (this.mUseIntrinsicAnimation) {
            ((AnimationDrawable)this.mHeaderImage.getDrawable()).stop();
        } else {
            this.resetImpl();
        }
        if (null != this.mSubHeaderText) {
            if (TextUtils.isEmpty((CharSequence)this.mSubHeaderText.getText())) {
                this.mSubHeaderText.setVisibility(8);
            } else {
                this.mSubHeaderText.setVisibility(0);
            }
        }
        if (null != this.mTipsTextView) {
            this.mTipsTextView.setVisibility(0);
        }
    }

    @Override
    public void setLastUpdatedLabel(CharSequence label) {
        this.setSubHeaderText(label);
    }

    @Override
    public final void setLoadingDrawable(Drawable imageDrawable) {
        this.mHeaderImage.setImageDrawable(imageDrawable);
        this.mUseIntrinsicAnimation = imageDrawable instanceof AnimationDrawable;
        this.onLoadingDrawableSet(imageDrawable);
    }

    @Override
    public void setPullLabel(CharSequence pullLabel) {
        this.mPullLabel = pullLabel;
    }

    @Override
    public void setRefreshingLabel(CharSequence refreshingLabel) {
        this.mRefreshingLabel = refreshingLabel;
    }

    @Override
    public void setReleaseLabel(CharSequence releaseLabel) {
        this.mReleaseLabel = releaseLabel;
    }

    @Override
    public void setTextTypeface(Typeface tf) {
        this.mHeaderText.setTypeface(tf);
    }

    public final void showInvisibleViews() {
        if (4 == this.mHeaderText.getVisibility()) {
            this.mHeaderText.setVisibility(0);
        }
        if (4 == this.mHeaderProgress.getVisibility()) {
            this.mHeaderProgress.setVisibility(0);
        }
        if (4 == this.mHeaderImage.getVisibility()) {
            this.mHeaderImage.setVisibility(0);
        }
        if (4 == this.mSubHeaderText.getVisibility()) {
            this.mSubHeaderText.setVisibility(0);
        }
    }

    protected abstract int getDefaultDrawableResId();

    protected abstract void onLoadingDrawableSet(Drawable var1);

    protected abstract void onPullImpl(float var1);

    protected abstract void pullToRefreshImpl();

    protected abstract void refreshingImpl();

    protected abstract void releaseToRefreshImpl();

    protected abstract void resetImpl();

    private void setSubHeaderText(CharSequence label) {
        if (null != this.mSubHeaderText) {
            if (TextUtils.isEmpty((CharSequence)label)) {
                this.mSubHeaderText.setVisibility(8);
            } else {
                this.mSubHeaderText.setText(label);
                if (8 == this.mSubHeaderText.getVisibility()) {
                    this.mSubHeaderText.setVisibility(0);
                }
            }
        }
    }

    private void setSubTextAppearance(int value) {
        if (null != this.mSubHeaderText) {
            this.mSubHeaderText.setTextAppearance(this.getContext(), value);
        }
    }

    private void setSubTextColor(ColorStateList color) {
        if (null != this.mSubHeaderText) {
            this.mSubHeaderText.setTextColor(color);
        }
    }

    private void setTextAppearance(int value) {
        if (null != this.mHeaderText) {
            this.mHeaderText.setTextAppearance(this.getContext(), value);
        }
        if (null != this.mSubHeaderText) {
            this.mSubHeaderText.setTextAppearance(this.getContext(), value);
        }
    }

    private void setTextColor(ColorStateList color) {
        if (null != this.mHeaderText) {
            this.mHeaderText.setTextColor(color);
        }
        if (null != this.mSubHeaderText) {
            this.mSubHeaderText.setTextColor(color);
        }
    }

    public static float getScaleRefreshing() {
        return SCALE_REFRESHING;
    }

    public static void setScaleRefreshing(float scaleRefreshing) {
        SCALE_REFRESHING = scaleRefreshing;
    }
}

