/*
 * Decompiled with CFR 0.152.
 */
package com.culiu.mhvp.integrated.ptr.pulltorefresh;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.culiu.mhvp.integrated.ptr.R;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.PullToRefreshBase;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.EmptyViewMethodAccessor;

public abstract class PullToRefreshAdapterViewBase<T extends AbsListView>
extends PullToRefreshBase<T>
implements AbsListView.OnScrollListener {
    private boolean mLastItemVisible;
    private AbsListView.OnScrollListener mOnScrollListener;
    private PullToRefreshBase.OnLastItemVisibleListener mOnLastItemVisibleListener;
    private View mEmptyView;
    private boolean mShowIndicator;
    private boolean mScrollEmptyView = true;
    private PullToRefreshBase.OnBackWardPositionVisibleListener mOnBackWardPositionVisibleListener;
    private int mPreviousItem = 0;
    private boolean canInvoke = true;

    private static FrameLayout.LayoutParams convertEmptyViewLayoutParams(ViewGroup.LayoutParams lp) {
        FrameLayout.LayoutParams newLp = null;
        if (null != lp) {
            newLp = new FrameLayout.LayoutParams(lp);
            newLp.gravity = lp instanceof LinearLayout.LayoutParams ? ((LinearLayout.LayoutParams)lp).gravity : 17;
        }
        return newLp;
    }

    public PullToRefreshAdapterViewBase(Context context) {
        super(context);
        ((AbsListView)this.mRefreshableView).setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public PullToRefreshAdapterViewBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        ((AbsListView)this.mRefreshableView).setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public PullToRefreshAdapterViewBase(Context context, PullToRefreshBase.Mode mode) {
        super(context, mode);
        ((AbsListView)this.mRefreshableView).setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public PullToRefreshAdapterViewBase(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.AnimationStyle animStyle) {
        super(context, mode, animStyle);
        ((AbsListView)this.mRefreshableView).setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public boolean getShowIndicator() {
        return this.mShowIndicator;
    }

    public final void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (null != this.mOnLastItemVisibleListener) {
            this.mLastItemVisible = totalItemCount > 0 && firstVisibleItem + visibleItemCount >= totalItemCount - 1;
        }
        int lastItem = firstVisibleItem + visibleItemCount;
        if (null != this.mOnBackWardPositionVisibleListener) {
            if (lastItem < totalItemCount - this.mBackWardPosition) {
                this.canInvoke = true;
            }
            if (lastItem > this.mPreviousItem && lastItem >= totalItemCount - this.mBackWardPosition && this.canInvoke) {
                this.mOnBackWardPositionVisibleListener.onBackWardPositionVisible();
                this.canInvoke = false;
            }
        }
        if (this.getShowIndicatorInternal()) {
            this.updateIndicatorViewsVisibility();
        }
        if (null != this.mOnScrollListener) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        this.mPreviousItem = lastItem;
    }

    public final void onScrollStateChanged(AbsListView view, int state) {
        if (state == 0 && null != this.mOnLastItemVisibleListener && this.mLastItemVisible) {
            this.mOnLastItemVisibleListener.onLastItemVisible();
        }
        if (null != this.mOnScrollListener) {
            this.mOnScrollListener.onScrollStateChanged(view, state);
        }
        this.canInvoke = true;
    }

    public void setAdapter(ListAdapter adapter) {
        ((AdapterView)this.mRefreshableView).setAdapter((Adapter)adapter);
    }

    public final void setEmptyView(View newEmptyView) {
        FrameLayout refreshableViewWrapper = this.getRefreshableViewWrapper();
        if (null != newEmptyView) {
            FrameLayout.LayoutParams lp;
            newEmptyView.setClickable(true);
            ViewParent newEmptyViewParent = newEmptyView.getParent();
            if (null != newEmptyViewParent && newEmptyViewParent instanceof ViewGroup) {
                ((ViewGroup)newEmptyViewParent).removeView(newEmptyView);
            }
            if (null != (lp = PullToRefreshAdapterViewBase.convertEmptyViewLayoutParams(newEmptyView.getLayoutParams()))) {
                refreshableViewWrapper.addView(newEmptyView, (ViewGroup.LayoutParams)lp);
            } else {
                refreshableViewWrapper.addView(newEmptyView);
            }
        }
        if (this.mRefreshableView instanceof EmptyViewMethodAccessor) {
            ((EmptyViewMethodAccessor)this.mRefreshableView).setEmptyViewInternal(newEmptyView);
        } else {
            ((AbsListView)this.mRefreshableView).setEmptyView(newEmptyView);
        }
        this.mEmptyView = newEmptyView;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        ((AbsListView)this.mRefreshableView).setOnItemClickListener(listener);
    }

    public final void setOnLastItemVisibleListener(PullToRefreshBase.OnLastItemVisibleListener listener) {
        this.mOnLastItemVisibleListener = listener;
    }

    public final void setOnBackWardPositionVisibleListener(PullToRefreshBase.OnBackWardPositionVisibleListener listener) {
        this.mOnBackWardPositionVisibleListener = listener;
    }

    public final void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public final void setScrollEmptyView(boolean doScroll) {
        this.mScrollEmptyView = doScroll;
    }

    public void setShowIndicator(boolean showIndicator) {
        this.mShowIndicator = showIndicator;
        if (this.getShowIndicatorInternal()) {
            this.addIndicatorViews();
        } else {
            this.removeIndicatorViews();
        }
    }

    @Override
    protected void onPullToRefresh() {
        super.onPullToRefresh();
        if (this.getShowIndicatorInternal()) {
            switch (this.getCurrentMode()) {
                case PULL_FROM_END: {
                    break;
                }
                case PULL_FROM_START: {
                    break;
                }
            }
        }
    }

    @Override
    protected void onRefreshing(boolean doScroll) {
        super.onRefreshing(doScroll);
        if (this.getShowIndicatorInternal()) {
            this.updateIndicatorViewsVisibility();
        }
    }

    @Override
    protected void onReleaseToRefresh() {
        super.onReleaseToRefresh();
        if (this.getShowIndicatorInternal()) {
            switch (this.getCurrentMode()) {
                case PULL_FROM_END: {
                    break;
                }
                case PULL_FROM_START: {
                    break;
                }
            }
        }
    }

    @Override
    protected void onReset() {
        super.onReset();
        if (this.getShowIndicatorInternal()) {
            this.updateIndicatorViewsVisibility();
        }
    }

    @Override
    protected void handleStyledAttributes(TypedArray a) {
        this.mShowIndicator = a.getBoolean(R.styleable.PullToRefresh_ptrShowIndicator, !this.isPullToRefreshOverScrollEnabled());
    }

    @Override
    protected boolean isReadyForPullStart() {
        return this.isFirstItemVisible() && this.isHeaderViewAtTop();
    }

    private boolean isHeaderViewAtTop() {
        if (this.mRefreshableView instanceof ListView) {
            View view;
            if (((AbsListView)this.mRefreshableView).getFirstVisiblePosition() > 1) {
                return false;
            }
            ListView listView = (ListView)this.mRefreshableView;
            if (listView != null && listView.getChildCount() > 0 && (view = listView.getChildAt(0)) != null) {
                return view.getTop() == 0;
            }
        }
        return true;
    }

    @Override
    protected boolean isReadyForPullEnd() {
        return this.isLastItemVisible();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (null != this.mEmptyView && !this.mScrollEmptyView) {
            this.mEmptyView.scrollTo(-l, -t);
        }
    }

    @Override
    protected void updateUIForMode() {
        super.updateUIForMode();
        if (this.getShowIndicatorInternal()) {
            this.addIndicatorViews();
        } else {
            this.removeIndicatorViews();
        }
    }

    private void addIndicatorViews() {
    }

    private boolean getShowIndicatorInternal() {
        return this.mShowIndicator && this.isPullToRefreshEnabled();
    }

    private boolean isFirstItemVisible() {
        View firstVisibleChild;
        Adapter adapter = ((AbsListView)this.mRefreshableView).getAdapter();
        if (null == adapter || adapter.isEmpty()) {
            return true;
        }
        if (((AbsListView)this.mRefreshableView).getFirstVisiblePosition() <= 1 && (firstVisibleChild = ((AbsListView)this.mRefreshableView).getChildAt(0)) != null) {
            return firstVisibleChild.getTop() >= ((AbsListView)this.mRefreshableView).getTop();
        }
        return false;
    }

    private boolean isLastItemVisible() {
        int childIndex;
        View lastVisibleChild;
        Adapter adapter = ((AbsListView)this.mRefreshableView).getAdapter();
        if (null == adapter || adapter.isEmpty()) {
            return true;
        }
        int lastItemPosition = ((AbsListView)this.mRefreshableView).getCount() - 1;
        int lastVisiblePosition = ((AbsListView)this.mRefreshableView).getLastVisiblePosition();
        if (lastVisiblePosition >= lastItemPosition - 1 && (lastVisibleChild = ((AbsListView)this.mRefreshableView).getChildAt(childIndex = lastVisiblePosition - ((AbsListView)this.mRefreshableView).getFirstVisiblePosition())) != null) {
            return lastVisibleChild.getBottom() <= ((AbsListView)this.mRefreshableView).getBottom();
        }
        return false;
    }

    private void removeIndicatorViews() {
    }

    private void updateIndicatorViewsVisibility() {
    }
}

