/*
 * Decompiled with CFR 0.152.
 */
package com.culiu.mhvp.integrated.ptr;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.culiu.mhvp.core.InnerListView;
import com.culiu.mhvp.integrated.ptr.R;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.LoadingLayoutProxy;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.OverscrollHelper;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.PullToRefreshAdapterViewBase;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.PullToRefreshBase;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.EmptyViewMethodAccessor;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.LoadingLayout;

public class PullToRefreshInnerListView
extends PullToRefreshAdapterViewBase<InnerListView> {
    private static final String TAG = "sz[PTRInnerLV]";
    private LoadingLayout mHeaderLoadingView;
    private LoadingLayout mFooterLoadingView;
    private FrameLayout mLvFooterLoadingFrame;
    private boolean mListViewExtrasEnabled;
    InnerListView lv;
    private OnScrollChangeListener onScrollChangeListener;

    public PullToRefreshInnerListView(Context context) {
        super(context);
    }

    public PullToRefreshInnerListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PullToRefreshInnerListView(Context context, PullToRefreshBase.Mode mode) {
        super(context, mode);
    }

    public PullToRefreshInnerListView(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.AnimationStyle style) {
        super(context, mode, style);
    }

    @Override
    public final PullToRefreshBase.Orientation getPullToRefreshScrollDirection() {
        return PullToRefreshBase.Orientation.VERTICAL;
    }

    @Override
    protected void onRefreshing(boolean doScroll) {
        LoadingLayout oppositeListViewLoadingView;
        ListAdapter adapter = ((InnerListView)this.mRefreshableView).getAdapter();
        if (!this.mListViewExtrasEnabled || !this.getShowViewWhileRefreshing() || null == adapter || adapter.isEmpty()) {
            super.onRefreshing(doScroll);
            return;
        }
        super.onRefreshing(false);
        switch (this.getCurrentMode()) {
            case MANUAL_REFRESH_ONLY: 
            case PULL_FROM_END: {
                LoadingLayout origLoadingView = this.getFooterLayout();
                LoadingLayout listViewLoadingView = this.mFooterLoadingView;
                oppositeListViewLoadingView = this.mHeaderLoadingView;
                int selection = ((InnerListView)this.mRefreshableView).getCount() - 1;
                int scrollToY = this.getScrollY() - this.getFooterSize();
                this.smoothScrollTo(this.getFooterSize());
                break;
            }
            default: {
                LoadingLayout origLoadingView = this.getHeaderLayout();
                LoadingLayout listViewLoadingView = this.mHeaderLoadingView;
                oppositeListViewLoadingView = this.mFooterLoadingView;
                boolean selection = false;
                int scrollToY = (int)((float)this.getScrollY() + (float)this.getHeaderSize() * LoadingLayout.SCALE_REFRESHING);
                this.smoothScrollTo((int)((float)(-this.getHeaderSize()) * LoadingLayout.SCALE_REFRESHING));
            }
        }
        oppositeListViewLoadingView.setVisibility(8);
    }

    @Override
    protected void onReset() {
        boolean scrollLvToEdge;
        int scrollToHeight;
        int selection;
        LoadingLayout listViewLoadingLayout;
        LoadingLayout originalLoadingLayout;
        if (!this.mListViewExtrasEnabled) {
            super.onReset();
            return;
        }
        switch (this.getCurrentMode()) {
            case MANUAL_REFRESH_ONLY: 
            case PULL_FROM_END: {
                originalLoadingLayout = this.getFooterLayout();
                listViewLoadingLayout = this.mFooterLoadingView;
                selection = ((InnerListView)this.mRefreshableView).getCount() - 1;
                scrollToHeight = this.getFooterSize();
                scrollLvToEdge = Math.abs(((InnerListView)this.mRefreshableView).getLastVisiblePosition() - selection) <= 1;
                break;
            }
            default: {
                originalLoadingLayout = this.getHeaderLayout();
                listViewLoadingLayout = this.mHeaderLoadingView;
                scrollToHeight = -this.getHeaderSize();
                selection = 0;
                boolean bl = scrollLvToEdge = Math.abs(((InnerListView)this.mRefreshableView).getFirstVisiblePosition() - selection) <= 1;
            }
        }
        if (listViewLoadingLayout.getVisibility() == 0) {
            originalLoadingLayout.showInvisibleViews();
            listViewLoadingLayout.setVisibility(8);
            if (scrollLvToEdge && this.getState() != PullToRefreshBase.State.MANUAL_REFRESHING) {
                ((InnerListView)this.mRefreshableView).setSelection(selection);
                this.setHeaderScroll(scrollToHeight);
            }
        }
        super.onReset();
    }

    @Override
    protected LoadingLayoutProxy createLoadingLayoutProxy(boolean includeStart, boolean includeEnd) {
        LoadingLayoutProxy proxy = super.createLoadingLayoutProxy(includeStart, includeEnd);
        if (this.mListViewExtrasEnabled) {
            PullToRefreshBase.Mode mode = this.getMode();
            if (includeStart && mode.showHeaderLoadingLayout()) {
                proxy.addLayout(this.mHeaderLoadingView);
            }
            if (includeEnd && mode.showFooterLoadingLayout()) {
                proxy.addLayout(this.mFooterLoadingView);
            }
        }
        return proxy;
    }

    protected InnerListView createListView(Context context, AttributeSet attrs) {
        InternalListView lv = Build.VERSION.SDK_INT >= 9 ? new InternalListViewSDK9(context, attrs) : new InternalListView(context, attrs);
        return lv;
    }

    @Override
    protected InnerListView createRefreshableView(Context context, AttributeSet attrs) {
        this.lv = this.createListView(context, attrs);
        this.lv.setId(16908298);
        this.lv.setReceiveView((View)this);
        return this.lv;
    }

    @Override
    protected void handleStyledAttributes(TypedArray a) {
        super.handleStyledAttributes(a);
        this.mListViewExtrasEnabled = a.getBoolean(R.styleable.PullToRefresh_ptrListViewExtrasEnabled, true);
        if (this.mListViewExtrasEnabled) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2, 1);
            int layoutId = a.getResourceId(R.styleable.PullToRefresh_ptrHeaderLayout, R.layout.default_pull_to_refresh_header_vertical);
            FrameLayout frame = new FrameLayout(this.getContext());
            this.mHeaderLoadingView = this.createLoadingLayout(this.getContext(), PullToRefreshBase.Mode.PULL_FROM_START, a, layoutId);
            this.mHeaderLoadingView.setVisibility(8);
            frame.addView((View)this.mHeaderLoadingView, (ViewGroup.LayoutParams)lp);
            ((InnerListView)this.mRefreshableView).addHeaderView((View)frame, null, false);
            this.mLvFooterLoadingFrame = new FrameLayout(this.getContext());
            this.mFooterLoadingView = this.createLoadingLayout(this.getContext(), PullToRefreshBase.Mode.PULL_FROM_END, a, layoutId);
            this.mFooterLoadingView.setVisibility(8);
            this.mLvFooterLoadingFrame.addView((View)this.mFooterLoadingView, (ViewGroup.LayoutParams)lp);
            if (!a.hasValue(R.styleable.PullToRefresh_ptrScrollingWhileRefreshingEnabled)) {
                this.setScrollingWhileRefreshingEnabled(true);
            }
        }
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (this.getState() == PullToRefreshBase.State.OVERSCROLLING) {
            this.setState(PullToRefreshBase.State.RESET, new boolean[0]);
            if (this.lv.getOuterScroller() != null) {
                this.lv.getOuterScroller().onInnerPullToRefreshScroll(0);
            }
        }
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.onScrollChangeListener != null) {
            this.onScrollChangeListener.onScrollChanged(l, t, oldl, oldt);
        }
        if (t <= 0 && oldt <= 0) {
            this.informOuterScrollerThatImScrolling(t);
        }
    }

    private void informOuterScrollerThatImScrolling(int t) {
        if (this.lv != null && this.lv.getOuterScroller() != null) {
            this.lv.getOuterScroller().onInnerPullToRefreshScroll(t);
        }
    }

    private void setOnScrollChangeListener(OnScrollChangeListener listener) {
        this.onScrollChangeListener = listener;
    }

    public static interface OnScrollChangeListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }

    protected class InternalListView
    extends InnerListView
    implements EmptyViewMethodAccessor {
        private boolean mAddedLvFooter;

        public InternalListView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.mAddedLvFooter = false;
        }

        protected void dispatchDraw(Canvas canvas) {
            try {
                super.dispatchDraw(canvas);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            try {
                return super.dispatchTouchEvent(ev);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                return false;
            }
        }

        public void setAdapter(ListAdapter adapter) {
            if (null != PullToRefreshInnerListView.this.mLvFooterLoadingFrame && !this.mAddedLvFooter) {
                this.mAddedLvFooter = true;
            }
            super.setAdapter(adapter);
        }

        @Override
        public void setEmptyView(View emptyView) {
            PullToRefreshInnerListView.this.setEmptyView(emptyView);
        }

        @Override
        public void setEmptyViewInternal(View emptyView) {
            super.setEmptyView(emptyView);
        }
    }

    @TargetApi(value=9)
    final class InternalListViewSDK9
    extends InternalListView {
        public InternalListViewSDK9(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
            boolean returnValue = super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
            OverscrollHelper.overScrollBy(PullToRefreshInnerListView.this, deltaX, scrollX, deltaY, scrollY, isTouchEvent);
            return returnValue;
        }
    }
}

