/*
 * Decompiled with CFR 0.152.
 */
package com.culiu.mhvp.integrated.ptr;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.culiu.mhvp.core.InnerScrollView;
import com.culiu.mhvp.integrated.ptr.R;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.OverscrollHelper;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.PullToRefreshBase;

public class PullToRefreshInnerScrollView
extends PullToRefreshBase<InnerScrollView> {
    InnerScrollView scrollView;
    OnReachBottomListener mOnReachBottomListener;
    private OnScrollChangeListener onScrollChangeListener;

    public PullToRefreshInnerScrollView(Context context) {
        super(context);
    }

    public PullToRefreshInnerScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PullToRefreshInnerScrollView(Context context, PullToRefreshBase.Mode mode) {
        super(context, mode);
    }

    public PullToRefreshInnerScrollView(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.AnimationStyle style) {
        super(context, mode, style);
    }

    @Override
    public final PullToRefreshBase.Orientation getPullToRefreshScrollDirection() {
        return PullToRefreshBase.Orientation.VERTICAL;
    }

    @Override
    protected InnerScrollView createRefreshableView(Context context, AttributeSet attrs) {
        this.scrollView = Build.VERSION.SDK_INT >= 9 ? new InternalScrollViewSDK9(context, attrs) : new InnerScrollView(context, attrs);
        this.scrollView.setId(R.id.scrollview);
        this.scrollView.setReceiveView((View)this);
        return this.scrollView;
    }

    @Override
    protected boolean isReadyForPullStart() {
        return ((InnerScrollView)this.mRefreshableView).getScrollY() == 0;
    }

    @Override
    protected boolean isReadyForPullEnd() {
        View scrollViewChild = ((InnerScrollView)this.mRefreshableView).getChildAt(0);
        if (null != scrollViewChild) {
            return ((InnerScrollView)this.mRefreshableView).getScrollY() >= scrollViewChild.getHeight() - this.getHeight();
        }
        return false;
    }

    public void setOnReachBottomListener(OnReachBottomListener mOnReachBottomListener) {
        this.mOnReachBottomListener = mOnReachBottomListener;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (this.getState() == PullToRefreshBase.State.OVERSCROLLING) {
            this.setState(PullToRefreshBase.State.RESET, new boolean[0]);
            if (this.scrollView.getOuterScroller() != null) {
                this.scrollView.getOuterScroller().onInnerPullToRefreshScroll(0);
            }
        }
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.onScrollChangeListener != null) {
            this.onScrollChangeListener.onScrollChanged(l, t, oldl, oldt);
        }
        if (t <= 0 && oldt <= 0) {
            this.informOuterScrollerThatImScrolling(t);
        }
    }

    private void informOuterScrollerThatImScrolling(int t) {
        if (this.scrollView != null && this.scrollView.getOuterScroller() != null) {
            this.scrollView.getOuterScroller().onInnerPullToRefreshScroll(t);
        }
    }

    private void setOnScrollChangeListener(OnScrollChangeListener listener) {
        this.onScrollChangeListener = listener;
    }

    public static interface OnScrollChangeListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }

    public static interface OnReachBottomListener {
        public void onReachBotton();

        public void onLeaveBottton();
    }

    @TargetApi(value=9)
    final class InternalScrollViewSDK9
    extends InnerScrollView {
        public InternalScrollViewSDK9(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
            boolean returnValue = super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
            OverscrollHelper.overScrollBy(PullToRefreshInnerScrollView.this, deltaX, scrollX, deltaY, scrollY, this.getScrollRange(), isTouchEvent);
            return returnValue;
        }

        private int getScrollRange() {
            int scrollRange = 0;
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                scrollRange = Math.max(0, child.getHeight() - (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()));
            }
            return scrollRange;
        }

        protected void onScrollChanged(int l, int t, int oldl, int oldt) {
            View view = this.getChildAt(this.getChildCount() - 1);
            int diff = view.getBottom() - (this.getHeight() + this.getScrollY());
            if (diff == 0) {
                if (PullToRefreshInnerScrollView.this.mOnReachBottomListener != null) {
                    PullToRefreshInnerScrollView.this.mOnReachBottomListener.onReachBotton();
                }
            } else if (PullToRefreshInnerScrollView.this.mOnReachBottomListener != null) {
                PullToRefreshInnerScrollView.this.mOnReachBottomListener.onLeaveBottton();
            }
            super.onScrollChanged(l, t, oldl, oldt);
        }
    }
}

