/*
 * Decompiled with CFR 0.152.
 */
package com.culiu.mhvp.integrated.ptr.pulltorefresh.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.culiu.mhvp.integrated.ptr.R;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.PullToRefreshBase;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.LoadingLayout;

public class RotateLoadingLayout
extends LoadingLayout {
    static final int ROTATION_ANIMATION_DURATION = 1200;
    private final Animation mRotateAnimation;
    private final Matrix mHeaderImageMatrix;
    private float mRotationPivotX;
    private float mRotationPivotY;
    private final boolean mRotateDrawableWhilePulling;

    public RotateLoadingLayout(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.Orientation scrollDirection, TypedArray attrs, int layoutId) {
        super(context, mode, scrollDirection, attrs, layoutId);
        this.mRotateDrawableWhilePulling = attrs.getBoolean(R.styleable.PullToRefresh_ptrRotateDrawableWhilePulling, true);
        this.mHeaderImage.setScaleType(ImageView.ScaleType.MATRIX);
        this.mHeaderImageMatrix = new Matrix();
        this.mHeaderImage.setImageMatrix(this.mHeaderImageMatrix);
        this.mRotateAnimation = new RotateAnimation(0.0f, 720.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateAnimation.setInterpolator(ANIMATION_INTERPOLATOR);
        this.mRotateAnimation.setDuration(1200L);
        this.mRotateAnimation.setRepeatCount(-1);
        this.mRotateAnimation.setRepeatMode(1);
    }

    @Override
    public void onLoadingDrawableSet(Drawable imageDrawable) {
        if (null != imageDrawable) {
            this.mRotationPivotX = Math.round((float)imageDrawable.getIntrinsicWidth() / 2.0f);
            this.mRotationPivotY = Math.round((float)imageDrawable.getIntrinsicHeight() / 2.0f);
        }
    }

    @Override
    protected void onPullImpl(float scaleOfLayout) {
        float angle = this.mRotateDrawableWhilePulling ? scaleOfLayout * 90.0f : Math.max(0.0f, Math.min(180.0f, scaleOfLayout * 360.0f - 180.0f));
        this.mHeaderImageMatrix.setRotate(angle, this.mRotationPivotX, this.mRotationPivotY);
        this.mHeaderImage.setImageMatrix(this.mHeaderImageMatrix);
    }

    @Override
    protected void refreshingImpl() {
        this.mHeaderImage.startAnimation(this.mRotateAnimation);
    }

    @Override
    protected void resetImpl() {
        this.mHeaderImage.clearAnimation();
        this.resetImageRotation();
    }

    private void resetImageRotation() {
        if (null != this.mHeaderImageMatrix) {
            this.mHeaderImageMatrix.reset();
            this.mHeaderImage.setImageMatrix(this.mHeaderImageMatrix);
        }
    }

    @Override
    protected void pullToRefreshImpl() {
    }

    @Override
    protected void releaseToRefreshImpl() {
    }

    @Override
    protected int getDefaultDrawableResId() {
        return R.drawable.default_ptr_rotate;
    }
}

