/*
 * Decompiled with CFR 0.152.
 */
package com.culiu.mhvp.integrated.ptr.pulltorefresh.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.culiu.mhvp.integrated.ptr.R;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.PullToRefreshBase;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.LoadingLayout;

@SuppressLint(value={"ViewConstructor"})
public class FlipLoadingLayout
extends LoadingLayout {
    static final int FLIP_ANIMATION_DURATION = 150;
    private final Animation mRotateAnimation;
    private final Animation mResetRotateAnimation;

    public FlipLoadingLayout(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.Orientation scrollDirection, TypedArray attrs, int layoutId) {
        super(context, mode, scrollDirection, attrs, layoutId);
        int rotateAngle = mode == PullToRefreshBase.Mode.PULL_FROM_START ? -180 : 180;
        this.mRotateAnimation = new RotateAnimation(0.0f, (float)rotateAngle, 1, 0.5f, 1, 0.5f);
        this.mRotateAnimation.setInterpolator(ANIMATION_INTERPOLATOR);
        this.mRotateAnimation.setDuration(150L);
        this.mRotateAnimation.setFillAfter(true);
        this.mResetRotateAnimation = new RotateAnimation((float)rotateAngle, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mResetRotateAnimation.setInterpolator(ANIMATION_INTERPOLATOR);
        this.mResetRotateAnimation.setDuration(150L);
        this.mResetRotateAnimation.setFillAfter(true);
    }

    @Override
    protected void onLoadingDrawableSet(Drawable imageDrawable) {
        if (null != imageDrawable) {
            int dHeight = imageDrawable.getIntrinsicHeight();
            int dWidth = imageDrawable.getIntrinsicWidth();
            ViewGroup.LayoutParams lp = this.mHeaderImage.getLayoutParams();
            lp.width = lp.height = Math.max(dHeight, dWidth);
            this.mHeaderImage.requestLayout();
            this.mHeaderImage.setScaleType(ImageView.ScaleType.MATRIX);
            Matrix matrix = new Matrix();
            matrix.postTranslate((float)(lp.width - dWidth) / 2.0f, (float)(lp.height - dHeight) / 2.0f);
            matrix.postRotate(this.getDrawableRotationAngle(), (float)lp.width / 2.0f, (float)lp.height / 2.0f);
            this.mHeaderImage.setImageMatrix(matrix);
        }
    }

    @Override
    protected void onPullImpl(float scaleOfLayout) {
    }

    @Override
    protected void pullToRefreshImpl() {
        if (this.mRotateAnimation == this.mHeaderImage.getAnimation()) {
            this.mHeaderImage.startAnimation(this.mResetRotateAnimation);
        }
    }

    @Override
    protected void refreshingImpl() {
        this.mHeaderImage.clearAnimation();
        this.mHeaderImage.setVisibility(4);
        this.mHeaderProgress.setVisibility(0);
    }

    @Override
    protected void releaseToRefreshImpl() {
        this.mHeaderImage.startAnimation(this.mRotateAnimation);
    }

    @Override
    protected void resetImpl() {
        this.mHeaderImage.clearAnimation();
        this.mHeaderProgress.setVisibility(8);
        this.mHeaderImage.setVisibility(0);
    }

    @Override
    protected int getDefaultDrawableResId() {
        return R.drawable.default_ptr_flip;
    }

    private float getDrawableRotationAngle() {
        float angle = 0.0f;
        switch (this.mMode) {
            case PULL_FROM_END: {
                if (this.mScrollDirection == PullToRefreshBase.Orientation.HORIZONTAL) {
                    angle = 90.0f;
                    break;
                }
                angle = 180.0f;
                break;
            }
            case PULL_FROM_START: {
                if (this.mScrollDirection != PullToRefreshBase.Orientation.HORIZONTAL) break;
                angle = 270.0f;
                break;
            }
        }
        return angle;
    }
}

