/*
 * Decompiled with CFR 0.152.
 */
package com.culiu.mhvp.integrated.ptr.pulltorefresh;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.culiu.mhvp.integrated.ptr.R;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.ILoadingLayout;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.IPullToRefresh;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.LoadingLayoutProxy;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.OverscrollHelper;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.FlipLoadingLayout;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.LoadingLayout;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.RotateLoadingLayout;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.Utils;
import com.culiu.mhvp.integrated.ptr.pulltorefresh.internal.ViewCompat;
import java.util.Random;

public abstract class PullToRefreshBase<T extends View>
extends LinearLayout
implements IPullToRefresh<T> {
    static final boolean DEBUG = true;
    static final boolean USE_HW_LAYERS = false;
    static final String LOG_TAG = "PullToRefresh";
    static final float FRICTION = 2.0f;
    public static final int SMOOTH_SCROLL_DURATION_MS = 200;
    public static final int SMOOTH_SCROLL_LONG_DURATION_MS = 325;
    static final int DEMO_SCROLL_INTERVAL = 225;
    static final String STATE_STATE = "ptr_state";
    static final String STATE_MODE = "ptr_mode";
    static final String STATE_CURRENT_MODE = "ptr_current_mode";
    static final String STATE_SCROLLING_REFRESHING_ENABLED = "ptr_disable_scrolling";
    static final String STATE_SHOW_REFRESHING_VIEW = "ptr_show_refreshing_view";
    static final String STATE_SUPER = "ptr_super";
    private int mTouchSlop;
    private float mLastMotionX;
    private float mLastMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private boolean mIsBeingDragged = false;
    private State mState = State.RESET;
    private Mode mMode = Mode.getDefault();
    private Mode mCurrentMode;
    public T mRefreshableView;
    private FrameLayout mRefreshableViewWrapper;
    private boolean mShowViewWhileRefreshing = true;
    private boolean mScrollingWhileRefreshingEnabled = false;
    private boolean mFilterTouchEvents = true;
    private boolean mOverScrollEnabled = true;
    private boolean mLayoutVisibilityChangesEnabled = true;
    private Interpolator mScrollAnimationInterpolator;
    private AnimationStyle mLoadingAnimationStyle = AnimationStyle.getDefault();
    private LoadingLayout mHeaderLayout;
    private LoadingLayout mFooterLayout;
    private OnRefreshListener<T> mOnRefreshListener;
    private OnRefreshListener2<T> mOnRefreshListener2;
    private OnPullEventListener<T> mOnPullEventListener;
    private SmoothScrollRunnable mCurrentSmoothScrollRunnable;
    private String[] mTipsArray;
    private Random mRandom;
    private String mTipsString = null;
    public int mBackWardPosition = 0;

    public PullToRefreshBase(Context context) {
        super(context);
        this.init(context, null);
    }

    public PullToRefreshBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PullToRefreshBase(Context context, Mode mode) {
        super(context);
        this.mMode = mode;
        this.init(context, null);
    }

    public PullToRefreshBase(Context context, Mode mode, AnimationStyle animStyle) {
        super(context);
        this.mMode = mode;
        this.mLoadingAnimationStyle = animStyle;
        this.init(context, null);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        T refreshableView = this.getRefreshableView();
        if (!(refreshableView instanceof ViewGroup)) {
            throw new UnsupportedOperationException("Refreshable View is not a ViewGroup so can't addView");
        }
        ((ViewGroup)refreshableView).addView(child, index, params);
    }

    @Override
    public final boolean demo() {
        if (this.mMode.showHeaderLoadingLayout() && this.isReadyForPullStart()) {
            this.smoothScrollToAndBack(-this.getHeaderSize() * 2);
            return true;
        }
        if (this.mMode.showFooterLoadingLayout() && this.isReadyForPullEnd()) {
            this.smoothScrollToAndBack(this.getFooterSize() * 2);
            return true;
        }
        return false;
    }

    @Override
    public final Mode getCurrentMode() {
        return this.mCurrentMode;
    }

    @Override
    public final boolean getFilterTouchEvents() {
        return this.mFilterTouchEvents;
    }

    @Override
    public final ILoadingLayout getLoadingLayoutProxy() {
        return this.getLoadingLayoutProxy(true, true);
    }

    @Override
    public final ILoadingLayout getLoadingLayoutProxy(boolean includeStart, boolean includeEnd) {
        return this.createLoadingLayoutProxy(includeStart, includeEnd);
    }

    @Override
    public final Mode getMode() {
        return this.mMode;
    }

    @Override
    public final T getRefreshableView() {
        return this.mRefreshableView;
    }

    @Override
    public final boolean getShowViewWhileRefreshing() {
        return this.mShowViewWhileRefreshing;
    }

    @Override
    public final State getState() {
        return this.mState;
    }

    public final boolean isDisableScrollingWhileRefreshing() {
        return !this.isScrollingWhileRefreshingEnabled();
    }

    @Override
    public final boolean isPullToRefreshEnabled() {
        return this.mMode.permitsPullToRefresh();
    }

    @Override
    public final boolean isPullToRefreshOverScrollEnabled() {
        return Build.VERSION.SDK_INT >= 9 && this.mOverScrollEnabled && OverscrollHelper.isAndroidOverScrollEnabled(this.mRefreshableView);
    }

    @Override
    public final boolean isRefreshing() {
        return this.mState == State.REFRESHING || this.mState == State.MANUAL_REFRESHING;
    }

    @Override
    public final boolean isScrollingWhileRefreshingEnabled() {
        return this.mScrollingWhileRefreshingEnabled;
    }

    public final boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isPullToRefreshEnabled()) {
            return false;
        }
        int action = event.getAction();
        if (action == 3 || action == 1) {
            this.mIsBeingDragged = false;
            return false;
        }
        if (action != 0 && this.mIsBeingDragged) {
            return true;
        }
        switch (action) {
            case 2: {
                float oppositeDiff;
                float diff;
                if (!this.mScrollingWhileRefreshingEnabled && this.isRefreshing()) {
                    return true;
                }
                if (!this.isReadyForPull()) break;
                float y = event.getY();
                float x = event.getX();
                switch (this.getPullToRefreshScrollDirection()) {
                    case HORIZONTAL: {
                        diff = x - this.mLastMotionX;
                        oppositeDiff = y - this.mLastMotionY;
                        break;
                    }
                    default: {
                        diff = y - this.mLastMotionY;
                        oppositeDiff = x - this.mLastMotionX;
                    }
                }
                float absDiff = Math.abs(diff);
                if (!(absDiff > (float)this.mTouchSlop) || this.mFilterTouchEvents && !(absDiff > Math.abs(oppositeDiff))) break;
                if (this.mMode.showHeaderLoadingLayout() && diff >= 1.0f && this.isReadyForPullStart()) {
                    this.mLastMotionY = y;
                    this.mLastMotionX = x;
                    this.mIsBeingDragged = true;
                    if (this.mMode != Mode.BOTH) break;
                    this.mCurrentMode = Mode.PULL_FROM_START;
                    break;
                }
                if (!this.mMode.showFooterLoadingLayout() || !(diff <= -1.0f) || !this.isReadyForPullEnd()) break;
                this.mLastMotionY = y;
                this.mLastMotionX = x;
                this.mIsBeingDragged = true;
                if (this.mMode != Mode.BOTH) break;
                this.mCurrentMode = Mode.PULL_FROM_END;
                break;
            }
            case 0: {
                if (this.mIsBeingDragged || !this.isReadyForPull()) break;
                this.mLastMotionY = this.mInitialMotionY = event.getY();
                this.mLastMotionX = this.mInitialMotionX = event.getX();
                this.mIsBeingDragged = false;
            }
        }
        return this.mIsBeingDragged;
    }

    @Override
    public final void onRefreshComplete() {
        if (this.isRefreshing()) {
            this.setState(State.RESET, new boolean[0]);
        }
    }

    public final boolean onTouchEvent(MotionEvent event) {
        if (!this.isPullToRefreshEnabled()) {
            return false;
        }
        if (!this.mScrollingWhileRefreshingEnabled && this.isRefreshing()) {
            return true;
        }
        if (event.getAction() == 0 && event.getEdgeFlags() != 0) {
            return false;
        }
        switch (event.getAction()) {
            case 2: {
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = event.getY();
                this.mLastMotionX = event.getX();
                this.pullEvent();
                return true;
            }
            case 0: {
                if (!this.isReadyForPull()) break;
                this.mLastMotionY = this.mInitialMotionY = event.getY();
                this.mLastMotionX = this.mInitialMotionX = event.getX();
                return true;
            }
            case 1: 
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.mIsBeingDragged = false;
                if (this.mState == State.RELEASE_TO_REFRESH && (null != this.mOnRefreshListener || null != this.mOnRefreshListener2)) {
                    this.setState(State.REFRESHING, true);
                    return true;
                }
                if (this.isRefreshing()) {
                    this.smoothScrollTo(0);
                    return true;
                }
                this.setState(State.RESET, new boolean[0]);
                return true;
            }
        }
        return false;
    }

    @Override
    public final void setScrollingWhileRefreshingEnabled(boolean allowScrollingWhileRefreshing) {
        this.mScrollingWhileRefreshingEnabled = allowScrollingWhileRefreshing;
    }

    public void setDisableScrollingWhileRefreshing(boolean disableScrollingWhileRefreshing) {
        this.setScrollingWhileRefreshingEnabled(!disableScrollingWhileRefreshing);
    }

    @Override
    public final void setFilterTouchEvents(boolean filterEvents) {
        this.mFilterTouchEvents = filterEvents;
    }

    public void setLastUpdatedLabel(CharSequence label) {
        this.getLoadingLayoutProxy().setLastUpdatedLabel(label);
    }

    public void setLoadingDrawable(Drawable drawable2) {
        this.getLoadingLayoutProxy().setLoadingDrawable(drawable2);
    }

    public void setLoadingDrawable(Drawable drawable2, Mode mode) {
        this.getLoadingLayoutProxy(mode.showHeaderLoadingLayout(), mode.showFooterLoadingLayout()).setLoadingDrawable(drawable2);
    }

    public void setLongClickable(boolean longClickable) {
        this.getRefreshableView().setLongClickable(longClickable);
    }

    @Override
    public final void setMode(Mode mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.updateUIForMode();
        }
    }

    @Override
    public void setOnPullEventListener(OnPullEventListener<T> listener) {
        this.mOnPullEventListener = listener;
    }

    @Override
    public final void setOnRefreshListener(OnRefreshListener<T> listener) {
        this.mOnRefreshListener = listener;
        this.mOnRefreshListener2 = null;
    }

    @Override
    public final void setOnRefreshListener(OnRefreshListener2<T> listener) {
        this.mOnRefreshListener2 = listener;
        this.mOnRefreshListener = null;
    }

    public void setPullLabel(CharSequence pullLabel) {
        this.getLoadingLayoutProxy().setPullLabel(pullLabel);
    }

    public void setPullLabel(CharSequence pullLabel, Mode mode) {
        this.getLoadingLayoutProxy(mode.showHeaderLoadingLayout(), mode.showFooterLoadingLayout()).setPullLabel(pullLabel);
    }

    public final void setPullToRefreshEnabled(boolean enable) {
        this.setMode(enable ? Mode.getDefault() : Mode.DISABLED);
    }

    @Override
    public final void setPullToRefreshOverScrollEnabled(boolean enabled) {
        this.mOverScrollEnabled = enabled;
    }

    @Override
    public final void setRefreshing() {
        this.setRefreshing(true);
    }

    @Override
    public final void setRefreshing(boolean doScroll) {
        if (!this.isRefreshing()) {
            this.setState(State.MANUAL_REFRESHING, doScroll);
        }
    }

    public void setRefreshingLabel(CharSequence refreshingLabel) {
        this.getLoadingLayoutProxy().setRefreshingLabel(refreshingLabel);
    }

    public void setRefreshingLabel(CharSequence refreshingLabel, Mode mode) {
        this.getLoadingLayoutProxy(mode.showHeaderLoadingLayout(), mode.showFooterLoadingLayout()).setRefreshingLabel(refreshingLabel);
    }

    public void setReleaseLabel(CharSequence releaseLabel) {
        this.setReleaseLabel(releaseLabel, Mode.BOTH);
    }

    public void setReleaseLabel(CharSequence releaseLabel, Mode mode) {
        this.getLoadingLayoutProxy(mode.showHeaderLoadingLayout(), mode.showFooterLoadingLayout()).setReleaseLabel(releaseLabel);
    }

    @Override
    public void setScrollAnimationInterpolator(Interpolator interpolator) {
        this.mScrollAnimationInterpolator = interpolator;
    }

    @Override
    public final void setShowViewWhileRefreshing(boolean showView) {
        this.mShowViewWhileRefreshing = showView;
    }

    public abstract Orientation getPullToRefreshScrollDirection();

    public final void setState(State state, boolean ... params) {
        this.mState = state;
        switch (this.mState) {
            case RESET: {
                this.onReset();
                break;
            }
            case PULL_TO_REFRESH: {
                this.onPullToRefresh();
                break;
            }
            case RELEASE_TO_REFRESH: {
                this.onReleaseToRefresh();
                break;
            }
            case REFRESHING: 
            case MANUAL_REFRESHING: {
                this.onRefreshing(params[0]);
                break;
            }
        }
        if (null != this.mOnPullEventListener) {
            this.mOnPullEventListener.onPullEvent(this, this.mState, this.mCurrentMode);
        }
    }

    protected final void addViewInternal(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
    }

    protected final void addViewInternal(View child, ViewGroup.LayoutParams params) {
        super.addView(child, -1, params);
    }

    protected LoadingLayout createLoadingLayout(Context context, Mode mode, TypedArray attrs, int layoutId) {
        LoadingLayout layout2 = this.mLoadingAnimationStyle.createLoadingLayout(context, mode, this.getPullToRefreshScrollDirection(), attrs, layoutId);
        this.setHeaderTipsText(layout2);
        layout2.setVisibility(4);
        return layout2;
    }

    protected LoadingLayoutProxy createLoadingLayoutProxy(boolean includeStart, boolean includeEnd) {
        LoadingLayoutProxy proxy = new LoadingLayoutProxy();
        if (includeStart && this.mMode.showHeaderLoadingLayout()) {
            proxy.addLayout(this.mHeaderLayout);
        }
        if (includeEnd && this.mMode.showFooterLoadingLayout()) {
            proxy.addLayout(this.mFooterLayout);
        }
        return proxy;
    }

    protected abstract T createRefreshableView(Context var1, AttributeSet var2);

    protected final void disableLoadingLayoutVisibilityChanges() {
        this.mLayoutVisibilityChangesEnabled = false;
    }

    protected final LoadingLayout getFooterLayout() {
        return this.mFooterLayout;
    }

    protected final int getFooterSize() {
        return this.mFooterLayout.getContentSize();
    }

    protected final LoadingLayout getHeaderLayout() {
        return this.mHeaderLayout;
    }

    public final int getHeaderSize() {
        return this.mHeaderLayout.getContentSize();
    }

    protected int getPullToRefreshScrollDuration() {
        return 200;
    }

    protected int getPullToRefreshScrollDurationLonger() {
        return 325;
    }

    protected FrameLayout getRefreshableViewWrapper() {
        return this.mRefreshableViewWrapper;
    }

    protected void handleStyledAttributes(TypedArray a) {
    }

    protected abstract boolean isReadyForPullEnd();

    protected abstract boolean isReadyForPullStart();

    protected void onPtrRestoreInstanceState(Bundle savedInstanceState) {
    }

    protected void onPtrSaveInstanceState(Bundle saveState) {
    }

    protected void onPullToRefresh() {
        switch (this.mCurrentMode) {
            case PULL_FROM_END: {
                this.mFooterLayout.pullToRefresh();
                break;
            }
            case PULL_FROM_START: {
                this.mHeaderLayout.pullToRefresh();
                break;
            }
        }
    }

    protected void onRefreshing(boolean doScroll) {
        if (this.mMode.showHeaderLoadingLayout()) {
            this.mHeaderLayout.refreshing();
        }
        if (this.mMode.showFooterLoadingLayout()) {
            this.mFooterLayout.refreshing();
        }
        if (doScroll) {
            if (this.mShowViewWhileRefreshing) {
                OnSmoothScrollFinishedListener listener = new OnSmoothScrollFinishedListener(){

                    @Override
                    public void onSmoothScrollFinished() {
                        PullToRefreshBase.this.callRefreshListener();
                    }
                };
                switch (this.mCurrentMode) {
                    case PULL_FROM_END: 
                    case MANUAL_REFRESH_ONLY: {
                        this.smoothScrollTo(this.getFooterSize(), listener);
                        break;
                    }
                    default: {
                        this.smoothScrollTo(-((int)((float)this.getHeaderSize() * LoadingLayout.SCALE_REFRESHING)), listener);
                        break;
                    }
                }
            } else {
                this.smoothScrollTo(0);
            }
        } else {
            this.callRefreshListener();
        }
    }

    protected void onReleaseToRefresh() {
        switch (this.mCurrentMode) {
            case PULL_FROM_END: {
                this.mFooterLayout.releaseToRefresh();
                break;
            }
            case PULL_FROM_START: {
                this.mHeaderLayout.releaseToRefresh();
                break;
            }
        }
    }

    protected void onReset() {
        this.mIsBeingDragged = false;
        this.mLayoutVisibilityChangesEnabled = true;
        this.mHeaderLayout.reset();
        this.mFooterLayout.reset();
        this.smoothScrollTo(0);
    }

    protected final void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.setMode(Mode.mapIntToValue(bundle.getInt(STATE_MODE, 0)));
            this.mCurrentMode = Mode.mapIntToValue(bundle.getInt(STATE_CURRENT_MODE, 0));
            this.mScrollingWhileRefreshingEnabled = bundle.getBoolean(STATE_SCROLLING_REFRESHING_ENABLED, false);
            this.mShowViewWhileRefreshing = bundle.getBoolean(STATE_SHOW_REFRESHING_VIEW, true);
            super.onRestoreInstanceState(bundle.getParcelable(STATE_SUPER));
            State viewState = State.mapIntToValue(bundle.getInt(STATE_STATE, 0));
            if (viewState == State.REFRESHING || viewState == State.MANUAL_REFRESHING) {
                this.setState(viewState, true);
            }
            this.onPtrRestoreInstanceState(bundle);
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected final Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        this.onPtrSaveInstanceState(bundle);
        bundle.putInt(STATE_STATE, this.mState.getIntValue());
        bundle.putInt(STATE_MODE, this.mMode.getIntValue());
        bundle.putInt(STATE_CURRENT_MODE, this.mCurrentMode.getIntValue());
        bundle.putBoolean(STATE_SCROLLING_REFRESHING_ENABLED, this.mScrollingWhileRefreshingEnabled);
        bundle.putBoolean(STATE_SHOW_REFRESHING_VIEW, this.mShowViewWhileRefreshing);
        bundle.putParcelable(STATE_SUPER, super.onSaveInstanceState());
        return bundle;
    }

    protected final void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.refreshLoadingViewsSize();
        this.refreshRefreshableViewSize(w, h);
        this.post(new Runnable(){

            @Override
            public void run() {
                PullToRefreshBase.this.requestLayout();
            }
        });
    }

    protected final void refreshLoadingViewsSize() {
        int maximumPullScroll = (int)((float)this.getMaximumPullScroll() * 1.2f);
        int pLeft = this.getPaddingLeft();
        int pTop = this.getPaddingTop();
        int pRight = this.getPaddingRight();
        int pBottom = this.getPaddingBottom();
        switch (this.getPullToRefreshScrollDirection()) {
            case HORIZONTAL: {
                if (this.mMode.showHeaderLoadingLayout()) {
                    this.mHeaderLayout.setWidth(maximumPullScroll);
                    pLeft = -maximumPullScroll;
                } else {
                    pLeft = 0;
                }
                if (this.mMode.showFooterLoadingLayout()) {
                    this.mFooterLayout.setWidth(maximumPullScroll);
                    pRight = -maximumPullScroll;
                    break;
                }
                pRight = 0;
                break;
            }
            case VERTICAL: {
                if (this.mMode.showHeaderLoadingLayout()) {
                    this.mHeaderLayout.setHeight(maximumPullScroll);
                    pTop = -maximumPullScroll;
                } else {
                    pTop = 0;
                }
                if (this.mMode.showFooterLoadingLayout()) {
                    this.mFooterLayout.setHeight(maximumPullScroll);
                    pBottom = -maximumPullScroll;
                    break;
                }
                pBottom = 0;
            }
        }
        this.setPadding(pLeft, pTop, pRight, pBottom);
    }

    protected final void refreshRefreshableViewSize(int width, int height) {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mRefreshableViewWrapper.getLayoutParams();
        switch (this.getPullToRefreshScrollDirection()) {
            case HORIZONTAL: {
                if (lp.width == width) break;
                lp.width = width;
                this.mRefreshableViewWrapper.requestLayout();
                break;
            }
            case VERTICAL: {
                if (lp.height == height) break;
                lp.height = height;
                this.mRefreshableViewWrapper.requestLayout();
            }
        }
    }

    protected final void setHeaderScroll(int value) {
        int maximumPullScroll = this.getMaximumPullScroll();
        value = Math.min(maximumPullScroll, Math.max(-maximumPullScroll, value));
        if (this.mLayoutVisibilityChangesEnabled) {
            if (value < 0) {
                this.mHeaderLayout.setVisibility(0);
            } else if (value > 0) {
                this.mFooterLayout.setVisibility(0);
            } else {
                this.mHeaderLayout.setVisibility(4);
                this.mFooterLayout.setVisibility(4);
            }
        }
        switch (this.getPullToRefreshScrollDirection()) {
            case VERTICAL: {
                this.scrollTo(0, value);
                break;
            }
            case HORIZONTAL: {
                this.scrollTo(value, 0);
            }
        }
    }

    protected final void smoothScrollTo(int scrollValue) {
        this.smoothScrollTo(scrollValue, this.getPullToRefreshScrollDuration());
    }

    protected final void smoothScrollTo(int scrollValue, OnSmoothScrollFinishedListener listener) {
        this.smoothScrollTo(scrollValue, this.getPullToRefreshScrollDuration(), 0L, listener);
    }

    protected final void smoothScrollToLonger(int scrollValue) {
        this.smoothScrollTo(scrollValue, this.getPullToRefreshScrollDurationLonger());
    }

    protected void updateUIForMode() {
        LinearLayout.LayoutParams lp = this.getLoadingLayoutLayoutParams();
        if (this == this.mHeaderLayout.getParent()) {
            this.removeView((View)this.mHeaderLayout);
        }
        if (this.mMode.showHeaderLoadingLayout()) {
            this.addViewInternal((View)this.mHeaderLayout, 0, (ViewGroup.LayoutParams)lp);
        }
        if (this == this.mFooterLayout.getParent()) {
            this.removeView((View)this.mFooterLayout);
        }
        if (this.mMode.showFooterLoadingLayout()) {
            this.addViewInternal((View)this.mFooterLayout, (ViewGroup.LayoutParams)lp);
        }
        this.refreshLoadingViewsSize();
        this.mCurrentMode = this.mMode != Mode.BOTH ? this.mMode : Mode.PULL_FROM_START;
    }

    private void addRefreshableView(Context context, T refreshableView) {
        this.mRefreshableViewWrapper = new FrameLayout(context);
        this.mRefreshableViewWrapper.addView(refreshableView, -1, -1);
        this.addViewInternal((View)this.mRefreshableViewWrapper, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    private void callRefreshListener() {
        if (null != this.mOnRefreshListener) {
            this.mOnRefreshListener.onRefresh(this);
        } else if (null != this.mOnRefreshListener2) {
            if (this.mCurrentMode == Mode.PULL_FROM_START) {
                this.mOnRefreshListener2.onPullDownToRefresh(this);
            } else if (this.mCurrentMode == Mode.PULL_FROM_END) {
                this.mOnRefreshListener2.onPullUpToRefresh(this);
            }
        }
    }

    private void init(Context context, AttributeSet attrs) {
        switch (this.getPullToRefreshScrollDirection()) {
            case HORIZONTAL: {
                this.setOrientation(0);
                break;
            }
            default: {
                this.setOrientation(1);
            }
        }
        this.setGravity(17);
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.mTouchSlop = config.getScaledTouchSlop();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PullToRefresh);
        if (a.hasValue(R.styleable.PullToRefresh_ptrMode)) {
            this.mMode = Mode.mapIntToValue(a.getInteger(R.styleable.PullToRefresh_ptrMode, 0));
        }
        if (a.hasValue(R.styleable.PullToRefresh_ptrAnimationStyle)) {
            this.mLoadingAnimationStyle = AnimationStyle.mapIntToValue(a.getInteger(R.styleable.PullToRefresh_ptrAnimationStyle, 0));
        }
        int layoutId = a.getResourceId(R.styleable.PullToRefresh_ptrHeaderLayout, R.layout.default_pull_to_refresh_header_vertical);
        this.mRefreshableView = this.createRefreshableView(context, attrs);
        this.addRefreshableView(context, this.mRefreshableView);
        this.mRandom = new Random();
        if (!this.isInEditMode()) {
            this.mTipsArray = context.getResources().getStringArray(R.array.loading_progress_tips_array);
        }
        this.mHeaderLayout = this.createLoadingLayout(context, Mode.PULL_FROM_START, a, layoutId);
        this.mFooterLayout = this.createLoadingLayout(context, Mode.PULL_FROM_END, a, layoutId);
        if (a.hasValue(R.styleable.PullToRefresh_ptrRefreshableViewBackground)) {
            Drawable background = a.getDrawable(R.styleable.PullToRefresh_ptrRefreshableViewBackground);
            if (null != background) {
                this.mRefreshableView.setBackgroundDrawable(background);
            }
        } else if (a.hasValue(R.styleable.PullToRefresh_ptrAdapterViewBackground)) {
            Utils.warnDeprecation("ptrAdapterViewBackground", "ptrRefreshableViewBackground");
            Drawable background = a.getDrawable(R.styleable.PullToRefresh_ptrAdapterViewBackground);
            if (null != background) {
                this.mRefreshableView.setBackgroundDrawable(background);
            }
        }
        if (a.hasValue(R.styleable.PullToRefresh_ptrOverScroll)) {
            this.mOverScrollEnabled = a.getBoolean(R.styleable.PullToRefresh_ptrOverScroll, true);
        }
        if (a.hasValue(R.styleable.PullToRefresh_ptrScrollingWhileRefreshingEnabled)) {
            this.mScrollingWhileRefreshingEnabled = a.getBoolean(R.styleable.PullToRefresh_ptrScrollingWhileRefreshingEnabled, false);
        }
        this.handleStyledAttributes(a);
        a.recycle();
        this.updateUIForMode();
    }

    private void setHeaderTipsText(LoadingLayout layout2) {
        if (this.mTipsArray != null && this.mRandom != null) {
            try {
                if (TextUtils.isEmpty((CharSequence)this.mTipsString)) {
                    this.mTipsString = this.mTipsArray[this.mRandom.nextInt(this.mTipsArray.length)];
                }
                layout2.setTipsText(this.mTipsString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isReadyForPull() {
        switch (this.mMode) {
            case PULL_FROM_START: {
                return this.isReadyForPullStart();
            }
            case PULL_FROM_END: {
                return this.isReadyForPullEnd();
            }
            case BOTH: {
                return this.isReadyForPullEnd() || this.isReadyForPullStart();
            }
        }
        return false;
    }

    private void pullEvent() {
        int itemDimension;
        int newScrollValue;
        float lastMotionValue;
        float initialMotionValue;
        switch (this.getPullToRefreshScrollDirection()) {
            case HORIZONTAL: {
                initialMotionValue = this.mInitialMotionX;
                lastMotionValue = this.mLastMotionX;
                break;
            }
            default: {
                initialMotionValue = this.mInitialMotionY;
                lastMotionValue = this.mLastMotionY;
            }
        }
        switch (this.mCurrentMode) {
            case PULL_FROM_END: {
                newScrollValue = Math.round(Math.max(initialMotionValue - lastMotionValue, 0.0f) / 2.0f);
                itemDimension = this.getFooterSize();
                break;
            }
            default: {
                newScrollValue = Math.round(Math.min(initialMotionValue - lastMotionValue, 0.0f) / 2.0f);
                itemDimension = (int)((float)this.getHeaderSize() * LoadingLayout.SCALE_REFRESHING);
            }
        }
        this.setHeaderScroll(newScrollValue);
        if (newScrollValue != 0 && !this.isRefreshing()) {
            float scale = (float)Math.abs(newScrollValue) / (float)itemDimension;
            switch (this.mCurrentMode) {
                case PULL_FROM_END: {
                    this.mFooterLayout.onPull(scale);
                    break;
                }
                default: {
                    this.mHeaderLayout.onPull(scale);
                }
            }
            if (this.mState != State.PULL_TO_REFRESH && itemDimension >= Math.abs(newScrollValue)) {
                this.setState(State.PULL_TO_REFRESH, new boolean[0]);
            } else if (this.mState == State.PULL_TO_REFRESH && itemDimension < Math.abs(newScrollValue)) {
                this.setState(State.RELEASE_TO_REFRESH, new boolean[0]);
            }
        }
    }

    private LinearLayout.LayoutParams getLoadingLayoutLayoutParams() {
        switch (this.getPullToRefreshScrollDirection()) {
            case HORIZONTAL: {
                return new LinearLayout.LayoutParams(-2, -1);
            }
        }
        return new LinearLayout.LayoutParams(-1, -2);
    }

    private int getMaximumPullScroll() {
        switch (this.getPullToRefreshScrollDirection()) {
            case HORIZONTAL: {
                return Math.round((float)this.getWidth() / 2.0f);
            }
        }
        return Math.round((float)this.getHeight() / 2.0f);
    }

    private final void smoothScrollTo(int scrollValue, long duration) {
        this.smoothScrollTo(scrollValue, duration, 0L, null);
    }

    private final void smoothScrollTo(int newScrollValue, long duration, long delayMillis, OnSmoothScrollFinishedListener listener) {
        int oldScrollValue;
        if (null != this.mCurrentSmoothScrollRunnable) {
            this.mCurrentSmoothScrollRunnable.stop();
        }
        switch (this.getPullToRefreshScrollDirection()) {
            case HORIZONTAL: {
                oldScrollValue = this.getScrollX();
                break;
            }
            default: {
                oldScrollValue = this.getScrollY();
            }
        }
        if (oldScrollValue != newScrollValue) {
            if (null == this.mScrollAnimationInterpolator) {
                this.mScrollAnimationInterpolator = new DecelerateInterpolator();
            }
            this.mCurrentSmoothScrollRunnable = new SmoothScrollRunnable(oldScrollValue, newScrollValue, duration, listener);
            if (delayMillis > 0L) {
                this.postDelayed(this.mCurrentSmoothScrollRunnable, delayMillis);
            } else {
                this.post(this.mCurrentSmoothScrollRunnable);
            }
        }
    }

    private final void smoothScrollToAndBack(int y) {
        this.smoothScrollTo(y, 200L, 0L, new OnSmoothScrollFinishedListener(){

            @Override
            public void onSmoothScrollFinished() {
                PullToRefreshBase.this.smoothScrollTo(0, 200L, 225L, null);
            }
        });
    }

    public int getBackWardPosition() {
        return this.mBackWardPosition;
    }

    public void setBackWardPosition(int backWardPosition) {
        this.mBackWardPosition = backWardPosition;
    }

    public void setScaleRefreshing(float scaleRefreshing) {
        if (this.mHeaderLayout != null) {
            LoadingLayout.setScaleRefreshing(scaleRefreshing);
        }
    }

    public static interface OnBackWardPositionVisibleListener {
        public void onBackWardPositionVisible();
    }

    static interface OnSmoothScrollFinishedListener {
        public void onSmoothScrollFinished();
    }

    final class SmoothScrollRunnable
    implements Runnable {
        private final Interpolator mInterpolator;
        private final int mScrollToY;
        private final int mScrollFromY;
        private final long mDuration;
        private OnSmoothScrollFinishedListener mListener;
        private boolean mContinueRunning = true;
        private long mStartTime = -1L;
        private int mCurrentY = -1;

        public SmoothScrollRunnable(int fromY, int toY, long duration, OnSmoothScrollFinishedListener listener) {
            this.mScrollFromY = fromY;
            this.mScrollToY = toY;
            this.mInterpolator = PullToRefreshBase.this.mScrollAnimationInterpolator;
            this.mDuration = duration;
            this.mListener = listener;
        }

        @Override
        public void run() {
            if (this.mStartTime == -1L) {
                this.mStartTime = System.currentTimeMillis();
            } else {
                long normalizedTime = 1000L * (System.currentTimeMillis() - this.mStartTime) / this.mDuration;
                normalizedTime = Math.max(Math.min(normalizedTime, 1000L), 0L);
                int deltaY = Math.round((float)(this.mScrollFromY - this.mScrollToY) * this.mInterpolator.getInterpolation((float)normalizedTime / 1000.0f));
                this.mCurrentY = this.mScrollFromY - deltaY;
                PullToRefreshBase.this.setHeaderScroll(this.mCurrentY);
            }
            if (this.mContinueRunning && this.mScrollToY != this.mCurrentY) {
                ViewCompat.postOnAnimation((View)PullToRefreshBase.this, this);
            } else if (null != this.mListener) {
                this.mListener.onSmoothScrollFinished();
            }
        }

        public void stop() {
            this.mContinueRunning = false;
            PullToRefreshBase.this.removeCallbacks(this);
        }
    }

    public static enum State {
        RESET(0),
        PULL_TO_REFRESH(1),
        RELEASE_TO_REFRESH(2),
        REFRESHING(8),
        MANUAL_REFRESHING(9),
        OVERSCROLLING(16);

        private int mIntValue;

        static State mapIntToValue(int stateInt) {
            for (State value : State.values()) {
                if (stateInt != value.getIntValue()) continue;
                return value;
            }
            return RESET;
        }

        private State(int intValue) {
            this.mIntValue = intValue;
        }

        int getIntValue() {
            return this.mIntValue;
        }
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }

    public static interface OnRefreshListener2<V extends View> {
        public void onPullDownToRefresh(PullToRefreshBase<V> var1);

        public void onPullUpToRefresh(PullToRefreshBase<V> var1);
    }

    public static interface OnRefreshListener<V extends View> {
        public void onRefresh(PullToRefreshBase<V> var1);
    }

    public static interface OnPullEventListener<V extends View> {
        public void onPullEvent(PullToRefreshBase<V> var1, State var2, Mode var3);
    }

    public static interface OnLastItemVisibleListener {
        public void onLastItemVisible();
    }

    public static enum Mode {
        DISABLED(0),
        PULL_FROM_START(1),
        PULL_FROM_END(2),
        BOTH(3),
        MANUAL_REFRESH_ONLY(4);

        public static Mode PULL_DOWN_TO_REFRESH;
        public static Mode PULL_UP_TO_REFRESH;
        private int mIntValue;

        static Mode mapIntToValue(int modeInt) {
            for (Mode value : Mode.values()) {
                if (modeInt != value.getIntValue()) continue;
                return value;
            }
            return Mode.getDefault();
        }

        static Mode getDefault() {
            return PULL_FROM_START;
        }

        private Mode(int modeInt) {
            this.mIntValue = modeInt;
        }

        boolean permitsPullToRefresh() {
            return this != DISABLED && this != MANUAL_REFRESH_ONLY;
        }

        public boolean showHeaderLoadingLayout() {
            return this == PULL_FROM_START || this == BOTH;
        }

        public boolean showFooterLoadingLayout() {
            return this == PULL_FROM_END || this == BOTH || this == MANUAL_REFRESH_ONLY;
        }

        int getIntValue() {
            return this.mIntValue;
        }

        static {
            PULL_DOWN_TO_REFRESH = PULL_FROM_START;
            PULL_UP_TO_REFRESH = PULL_FROM_END;
        }
    }

    public static enum AnimationStyle {
        ROTATE,
        FLIP;


        static AnimationStyle getDefault() {
            return ROTATE;
        }

        static AnimationStyle mapIntToValue(int modeInt) {
            switch (modeInt) {
                default: {
                    return ROTATE;
                }
                case 1: 
            }
            return FLIP;
        }

        LoadingLayout createLoadingLayout(Context context, Mode mode, Orientation scrollDirection, TypedArray attrs, int layoutId) {
            switch (this) {
                default: {
                    return new RotateLoadingLayout(context, mode, scrollDirection, attrs, layoutId);
                }
                case FLIP: 
            }
            return new FlipLoadingLayout(context, mode, scrollDirection, attrs, layoutId);
        }
    }
}

