/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Patterns;
import com.cuelinks.Cuelinks;
import java.util.Arrays;

public class CuelinksUtil {
    public static String getAffiliatedUrl(String url, String ... subId) {
        if (!TextUtils.isEmpty((CharSequence)url) || Patterns.WEB_URL.matcher(url).matches()) {
            String internalUrl = Cuelinks.getInternalUrl();
            String[] appSubId = Cuelinks.getSubId();
            StringBuilder affiliatedLinkBuilder = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)internalUrl) && url.contains(internalUrl)) {
                return url;
            }
            affiliatedLinkBuilder.append("https://linksredirect.com/?cid=").append(Cuelinks.getChannelId());
            if (subId != null && subId.length > 0) {
                CuelinksUtil.appendSubId(subId, affiliatedLinkBuilder);
            } else if (appSubId != null && appSubId.length > 0) {
                CuelinksUtil.appendSubId(appSubId, affiliatedLinkBuilder);
            }
            url = affiliatedLinkBuilder.append("&source=android&url=").append(url).toString();
        }
        return url;
    }

    private static void appendSubId(String[] subId, StringBuilder affiliatedLinkBuilder) {
        if (subId.length > 5) {
            throw new RuntimeException("Maximum 5 Sub Ids allowed - " + Arrays.toString(subId));
        }
        for (int i = 0; i < subId.length; ++i) {
            if (i == 0) {
                affiliatedLinkBuilder.append("&subid=");
            } else {
                affiliatedLinkBuilder.append("&subid").append(i + 1).append("=");
            }
            affiliatedLinkBuilder.append(subId[i].replaceAll("\\s", ""));
        }
    }

    public static Spanned fromHtml(String html) {
        Spanned result = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)html, (int)0) : Html.fromHtml((String)html);
        return result;
    }
}

