/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import com.cuelinks.CuelinksListener;
import com.cuelinks.CuelinksUtil;

public class CuelinksSpan
extends URLSpan {
    public static final Parcelable.Creator<CuelinksSpan> CREATOR = new Parcelable.Creator<CuelinksSpan>(){

        public CuelinksSpan createFromParcel(Parcel in) {
            return new CuelinksSpan(in);
        }

        public CuelinksSpan[] newArray(int size) {
            return new CuelinksSpan[size];
        }
    };
    private static CuelinksListener mListener;
    private static String[] mSubId;

    public CuelinksSpan(String url) {
        super(url);
    }

    public CuelinksSpan(Parcel parcel) {
        super(parcel);
    }

    private static CharSequence replaceSpan(CharSequence text, TextView view) {
        Spannable s;
        URLSpan[] spans;
        view.setAutoLinkMask(0);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        if (text instanceof Spannable && (spans = (URLSpan[])(s = (Spannable)text).getSpans(0, s.length(), URLSpan.class)) != null && spans.length > 0) {
            for (int i = spans.length - 1; i >= 0; --i) {
                URLSpan span = spans[i];
                int start = s.getSpanStart((Object)span);
                int end = s.getSpanEnd((Object)span);
                int flags = s.getSpanFlags((Object)span);
                s.removeSpan((Object)span);
                s.setSpan((Object)new CuelinksSpan(span.getURL()), start, end, flags);
            }
        }
        return text;
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view) {
        mListener = null;
        mSubId = null;
        return CuelinksSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinksListener cuelinksListener) {
        mListener = cuelinksListener;
        mSubId = null;
        return CuelinksSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinksListener cuelinksListener, String ... subId) {
        mListener = cuelinksListener;
        mSubId = subId;
        return CuelinksSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, String ... subId) {
        mListener = null;
        mSubId = subId;
        return CuelinksSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view) {
        return CuelinksSpan.affiliateHrefUrls((CharSequence)CuelinksUtil.fromHtml(html.toString()), view);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, String ... subId) {
        return CuelinksSpan.affiliateHrefUrls((CharSequence)CuelinksUtil.fromHtml(html.toString()), view, subId);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinksListener cuelinksListener) {
        return CuelinksSpan.affiliateHrefUrls((CharSequence)CuelinksUtil.fromHtml(html.toString()), view, cuelinksListener);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinksListener cuelinksListener, String ... subId) {
        return CuelinksSpan.affiliateHrefUrls((CharSequence)CuelinksUtil.fromHtml(html.toString()), view, cuelinksListener, subId);
    }

    public void onClick(View widget) {
        String url = CuelinksUtil.getAffiliatedUrl(this.getURL(), mSubId);
        Context context = widget.getContext();
        if (mListener == null) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            if (context != null) {
                intent.putExtra("com.android.browser.application_id", context.getPackageName());
                context.startActivity(intent);
            }
        } else {
            mListener.openUrl(url, context);
        }
    }
}

