package com.cuelinks;

import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Patterns;

import java.util.Arrays;

/**
 * Created by tasneem on 11/4/16.
 */
public class CuelinksUtil {

    /**
     * Convert provided link into cuelinks affiliated links except the urls start with provided internal url domain.
     *
     * @param url   Url to be affiliated
     * @param subId subId to capture in cuelinks
     * @return String
     */
    public static String getAffiliatedUrl(String url, String... subId) {
        if (!TextUtils.isEmpty(url) || Patterns.WEB_URL.matcher(url).matches()) {
            String internalUrl = Cuelinks.getInternalUrl();
            String[] appSubId = Cuelinks.getSubId();
            StringBuilder affiliatedLinkBuilder = new StringBuilder();
            if (!TextUtils.isEmpty(internalUrl) && url.contains(internalUrl)) {
                return url;
            }
            affiliatedLinkBuilder.append("https://linksredirect.com/?cid=").append(Cuelinks.getChannelId());
            if (subId != null && subId.length > 0) {
                appendSubId(subId, affiliatedLinkBuilder);
            } else if (appSubId != null && appSubId.length > 0) {
                appendSubId(appSubId, affiliatedLinkBuilder);
            }

            url = affiliatedLinkBuilder.append("&source=android&url=").append(url).toString();
        }
        return url;
    }

    private static void appendSubId(String[] subId, StringBuilder affiliatedLinkBuilder) {
        if (subId.length > 5) {
            throw new RuntimeException("Maximum 5 Sub Ids allowed - " + Arrays.toString(subId));
        }
        for (int i = 0; i < subId.length; i++) {
            if (i == 0) {
                affiliatedLinkBuilder.append("&subid=");
            } else {
                affiliatedLinkBuilder.append("&subid").append(i + 1).append("=");
            }
            affiliatedLinkBuilder.append(subId[i].replaceAll("\\s", ""));
        }
    }

    /**
     * Method to convert html data to android readable
     *
     * @param html html data to parse
     * @return Spanned
     */
    public static Spanned fromHtml(String html) {
        Spanned result;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            result = Html.fromHtml(html, Html.FROM_HTML_MODE_LEGACY);
        } else {
            result = Html.fromHtml(html);
        }
        return result;
    }
}
