package com.cuelinks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.provider.Browser;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;

/**
 * This code will perfectly work if user is using html data.
 *
 * @author tasneem
 */
public class CuelinksSpan extends URLSpan {
    public static final ParcelableSpan.Creator<CuelinksSpan> CREATOR
            = new ParcelableSpan.Creator<CuelinksSpan>() {
        public CuelinksSpan createFromParcel(Parcel in) {
            return new CuelinksSpan(in);
        }

        public CuelinksSpan[] newArray(int size) {
            return new CuelinksSpan[size];
        }
    };
    private static CuelinksListener mListener;
    private static String[] mSubId;

    public CuelinksSpan(String url) {
        super(url);
    }

    public CuelinksSpan(Parcel parcel) {
        super(parcel);
    }

    /**
     * Pass encoded html data
     *
     * @param text Html Encoded Text
     * @param view TextView
     * @return CharSequence
     */
    private static CharSequence replaceSpan(CharSequence text, TextView view) {
        view.setAutoLinkMask(0);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        if (text instanceof Spannable) {
            final Spannable s = (Spannable) text;
            final URLSpan[] spans = s.getSpans(0, s.length(), URLSpan.class);
            if (spans != null && spans.length > 0) {
                for (int i = spans.length - 1; i >= 0; i--) {
                    final URLSpan span = spans[i];
                    final int start = s.getSpanStart(span);
                    final int end = s.getSpanEnd(span);
                    final int flags = s.getSpanFlags(span);
                    s.removeSpan(span);
                    s.setSpan(new CuelinksSpan(span.getURL()), start, end, flags);
                }
            }
        }
        return text;
    }

    /**
     * @param text Normal Text
     * @param view TextView
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view) {
        mListener = null;
        mSubId = null;
        return replaceSpan(text, view);
    }

    /**
     * @param text             encoded text
     * @param view             TextView
     * @param cuelinksListener CuelinksListener to be handled
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinksListener cuelinksListener) {
        mListener = cuelinksListener;
        mSubId = null;
        return replaceSpan(text, view);
    }

    /**
     * @param text             Normal Text
     * @param view             TextView
     * @param cuelinksListener CuelinksListener to be handled
     * @param subId            Multiple Sub ids
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinksListener cuelinksListener, String... subId) {
        mListener = cuelinksListener;
        mSubId = subId;
        return replaceSpan(text, view);
    }

    /**
     * @param text  Normal Text
     * @param view  TextView
     * @param subId Multiple Sub ids
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, String... subId) {
        mListener = null;
        mSubId = subId;
        return replaceSpan(text, view);
    }

    /**
     * Parse the html code into normal code and then convert the normal links to affiliate links.
     * This will extract link from <a></a> tag.
     *
     * @param html Html text
     * @param view TextView
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view) {
        return affiliateHrefUrls(CuelinksUtil.fromHtml(html.toString()), view);
    }

    /**
     * @param html  Html Text
     * @param view  TextView
     * @param subId Multiple Sub ids
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, String... subId) {
        return affiliateHrefUrls(CuelinksUtil.fromHtml(html.toString()), view, subId);
    }

    /**
     * Parse the html code into normal code and then convert the normal links to affiliate links.
     * This will extract link from <a></a> tag.
     *
     * @param html             Html Text
     * @param view             TextView
     * @param cuelinksListener CuelinksListener to be handled
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinksListener cuelinksListener) {
        return affiliateHrefUrls(CuelinksUtil.fromHtml(html.toString()), view, cuelinksListener);
    }

    /**
     * @param html             Html Text
     * @param view             TextView
     * @param cuelinksListener CuelinksListener to be handled
     * @param subId            Multiple Sub ids
     * @return affiliate Href Urls text
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinksListener cuelinksListener, String... subId) {
        return affiliateHrefUrls(CuelinksUtil.fromHtml(html.toString()), view, cuelinksListener, subId);
    }

    @Override
    public void onClick(View widget) {
        String url = CuelinksUtil.getAffiliatedUrl(getURL(), mSubId);
        Context context = widget.getContext();
        if (mListener == null) {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            if (context != null) {
                intent.putExtra(Browser.EXTRA_APPLICATION_ID, context.getPackageName());
                context.startActivity(intent);
            }
        } else {
            mListener.openUrl(url, context);
        }
    }

}
